#coding: utf-8
from django.db import models
from django.utils.translation import ugettext_lazy as _
from diocesesim.models import getBaseAdmin, SharedBase
from django import forms


# Models
def getBaseCentroAnimacaoEspiritual():
    class BaseCentroAnimacaoEspiritual(SharedBase):
        nome = models.CharField(_(u'Nome'), max_length=255)
        director = models.CharField(_(u'Responsável/ Director'), max_length=255, null=True, blank=True)
        propiedade = models.CharField(_(u'Propriedade'), max_length=255, null=True, blank=True)
        morada = models.CharField(_(u'Morada'), max_length=255, null=True, blank=True)
        codigo_postal = models.CharField(_(u'Código postal'), max_length=255, null=True, blank=True)
        localidade = models.CharField(_(u'Localidade'), max_length=255, null=True, blank=True)
        telefone = models.CharField(_(u'Telefone'), max_length=255, null=True, blank=True)
        telemovel = models.CharField(_(u'Telemóvel'), max_length=255, null=True, blank=True)
        fax = models.CharField(_(u'Fax'), max_length=255, null=True, blank=True)
        email = models.CharField(_(u'Email'), max_length=255, null=True, blank=True)
        paginaweb = models.CharField(_(u'Página web'), max_length=255, null=True, blank=True)
        obs = models.TextField(_(u'Observações'), null=True, blank=True)

        class Meta:
            verbose_name = _(u'Centro de Animação Espiritual')
            verbose_name_plural = _(u'Centros de Animação Espiritual')
            abstract = True
            ordering = ['nome']

        def __unicode__(self):
            return self.nome
    return BaseCentroAnimacaoEspiritual
# Fim Models

# Admin
def getBaseCentroAnimacaoEspiritualForm(mymodel):
    class BaseCentroAnimacaoEspiritualForm(forms.ModelForm):
        class Meta:
            model = mymodel

    return BaseCentroAnimacaoEspiritualForm

def getBaseCentroAnimacaoEspiritualAdmin(mymodel):
    class BaseCentroAnimacaoEspiritualAdmin(getBaseAdmin(mymodel)):
        form = getBaseCentroAnimacaoEspiritualForm(mymodel)
        fieldsets = (
                     (None, {
                             'fields':(
                                       ('nome',),
                                       ('director',),
                                       ('propiedade',),
                                       ('morada',),
                                       ('codigo_postal','localidade',),
                                       ('telefone','telemovel',),
                                       ('fax','email',),
                                       ('paginaweb',),
                                       ('obs',),
                                       )
                             }),
                     )
        list_display = ('nome', 'alterado', 'id',)
        search_fields = ('nome', 'id', )

    return BaseCentroAnimacaoEspiritualAdmin
# Fim Admin
