#coding: utf-8
from django.db import models
from django.utils.translation import ugettext_lazy as _
from diocesesim.models import getBaseAdmin, SharedBase
from django import forms


# Models
def getBaseAssociacaoMovimentoObra():
    class BaseAssociacaoMovimentoObra(SharedBase):
        nome = models.CharField(_(u'Nome'), max_length=255)
        presidente = models.CharField(_(u'Presidente/ Coordenador'), max_length=255, null=True, blank=True)
        assistente = models.CharField(_(u'Assistente'), max_length=255, null=True, blank=True)
        morada = models.CharField(_(u'Morada'), max_length=255, null=True, blank=True)
        codigo_postal = models.CharField(_(u'Código postal'), max_length=255, null=True, blank=True)
        localidade = models.CharField(_(u'Localidade'), max_length=255, null=True, blank=True)
        telefone = models.CharField(_(u'Telefone'), max_length=255, null=True, blank=True)
        telemovel = models.CharField(_(u'Telemóvel'), max_length=255, null=True, blank=True)
        fax = models.CharField(_(u'Fax'), max_length=255, null=True, blank=True)
        email = models.CharField(_(u'Email'), max_length=255, null=True, blank=True)
        paginaweb = models.CharField(_(u'Página web'), max_length=255, null=True, blank=True)

        class Meta:
            verbose_name = _(u'Associação Movimento e Obra')
            verbose_name_plural = _(u'Associações Movimentos e Obras')
            abstract = True
            ordering = ['nome']

        def __unicode__(self):
            return self.nome
    return BaseAssociacaoMovimentoObra
# Fim Models

# Admin
def getBaseAssociacaoMovimentoObraForm(mymodel):
    class BaseAssociacaoMovimentoObraForm(forms.ModelForm):
        class Meta:
            model = mymodel

    return BaseAssociacaoMovimentoObraForm

def getBaseAssociacaoMovimentoObraAdmin(mymodel):
    class BaseAssociacaoMovimentoObraAdmin(getBaseAdmin(mymodel)):
        form = getBaseAssociacaoMovimentoObraForm(mymodel)
        fieldsets = (
                     (None, {
                             'fields':(
                                       ('nome',),
                                       ('presidente',),
                                       ('assistente',),
                                       ('morada',),
                                       ('codigo_postal','localidade',),
                                       ('telefone','telemovel',),
                                       ('fax','email',),
                                       ('paginaweb',),
                                       )
                             }),
                     )
        list_display = ('nome', 'alterado', 'id',)
        search_fields = ('nome', 'id', )

    return BaseAssociacaoMovimentoObraAdmin
# Fim Admin
