#coding: utf-8
from django.db import models
from django.contrib import admin
from django import forms

from elfinder.hooks.ElfinderImageField import ElfinderImageWidget
from tinymce import widgets as tinymce_widgets

from django.utils.translation import ugettext_lazy as _

from myadmin.admin import MyDioceseAdmin

try:
    from settings import DIOCESE_NOME
    diocese_nome = DIOCESE_NOME
except Exception, e:
    diocese_nome = ''


from django.contrib.auth.models import User
from datetime import datetime

from diocesesim.models import getBaseAdmin, SharedBase
from diocesesim.models import Base

from django.db.models import get_model

from django.db.models import Q

"""
# Ecclesia
from diocesesim.diocese.ecclesia import models as modelsEcclesia

class Ecclesia(modelsEcclesia.getBaseEcclesia()):
    pass

class EcclesiaForm(modelsEcclesia.getBaseEcclesiaForm(Ecclesia)):
    pass

seccao_fieldsets = modelsEcclesia.getBaseEcclesiaAdmin(Ecclesia).fieldsets

class EcclesiaAdmin(modelsEcclesia.getBaseEcclesiaAdmin(Ecclesia)):
    form = EcclesiaForm
    fieldsets = seccao_fieldsets

# Fim Ecclesia
"""


class Diacono(SharedBase):
    nome = models.CharField(_(u'Nome'), max_length=255)
    morada = models.CharField(_(u'Morada'), max_length=255, null=True, blank=True)
    codigo_postal = models.CharField(_(u'Código postal'), max_length=255, null=True, blank=True)
    localidade = models.CharField(_(u'Localidade'), max_length=255, null=True, blank=True)
    telefone = models.CharField(_(u'Telefone'), max_length=255, null=True, blank=True)
    telemovel = models.CharField(_(u'Telemóvel'), max_length=255, null=True, blank=True)
    fax = models.CharField(_(u'Fax'), max_length=255, null=True, blank=True)
    email = models.CharField(_(u'Email'), max_length=255, null=True, blank=True)
    paginaweb = models.CharField(_(u'Página web'), max_length=255, null=True, blank=True)
    data_nascimento = models.DateField(_(u'data nascimento'), help_text='(aaaa-mm-dd)', null=True, blank=True)
    data_ordenacoa = models.DateField(_(u'data ordenação'), help_text='(aaaa-mm-dd)', null=True, blank=True)
    obs = models.TextField(_(u'Observações'), null=True, blank=True)
    foto = models.CharField(_(u'Foto'), max_length=255, null=True, blank=True)
    telemovel_privado = models.CharField(_(u'Telemóvel Privado'), max_length=255, null=True, blank=True)
    nomeacoes = models.TextField(_(u'Nomeações'), null=True, blank=True)
    local_nascimento = models.CharField(_(u'Local de Nascimento'), max_length=255, null=True, blank=True)
    local_ordenacao  = models.CharField(_(u'Local de Ordenação'), max_length=255, null=True, blank=True)
    faleceu = models.BooleanField(_(u'Faleceu'), default=False)
    data_faleceu = models.DateField(_(u'Data Faleceu'), help_text='(aaaa-mm-dd)', null=True, blank=True)
    nomeacoes_actuais = models.TextField(_(u'Nomeações Actuais'), null=True, blank=True)
    #arciprestado = models.ForeignKey(get_model('diocese','Arciprestado'), verbose_name=_(u'Arciprestado'), related_name='dioceses_diaconos_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    #arciprestado = models.ForeignKey(Arciprestado, verbose_name=_(u'Arciprestado'), related_name='dioceses_diaconos_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    #arciprestado = models.ForeignKey('diocese.Arciprestado', verbose_name=_(u'Arciprestado'), related_name='dioceses_diaconos_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)

    class Meta:
        verbose_name = _(u'Diácono')
        verbose_name_plural = _(u'Diáconos')
        #abstract = True

    def __unicode__(self):
        return self.nome



class DiaconoArciprestado(models.Model):
    diacono = models.ForeignKey(Diacono, verbose_name=_(u'Diacono'), related_name='dioceses_diaconoarciprestados_diaconoarciprestados_diacono')
    arciprestado = models.ForeignKey('diocese.Arciprestado', verbose_name=_(u'Arciprestado'), related_name='dioceses_diaconoarciprestados_diaconoarciprestados_arciprestado')

    class Meta(Base.Meta):
        #abstract = True
        verbose_name = _(u'Arciprestado')
        verbose_name_plural = _(u'Arciprestados')
        unique_together = ('diacono', 'arciprestado',)

    def __unicode__(self):
        try:
            arciprestado = self.arciprestado.arciprestado
        except Exception, e:
            arciprestado=''
        return arciprestado

        


# Presbitero
from diocesesim.diocese.presbitero import models as modelsPresbitero

PRESBITERO_TIPOS_CHOICES=(
    (1, _(u'Religioso')),
    (2, _(u'Arquidiocesano')),
    (3, _(u'Arquidiocesano a Residir Fora')),
    (4, _(u'De Fora a Residir na Arquidiocese')),
)

PRESBITERO_PRESBITERO_TIPOS_CHOICES=(
    (1, _(u'Padre')),
    (2, _(u'Monsenhor')),
    (3, _(u'Cónego')),
    (4, _(u'Mon. Cónego')),
)

class Presbitero(modelsPresbitero.getBasePresbitero(PRESBITERO_TIPOS_CHOICES)):
    foto = models.CharField(_(u'Foto'), max_length=255, null=True, blank=True)
    telemovel_privado = models.CharField(_(u'Telemóvel Privado'), max_length=255, null=True, blank=True)
    tipo_clero = models.PositiveIntegerField(_(u'Tipo'), max_length=1, choices=PRESBITERO_PRESBITERO_TIPOS_CHOICES, null=True, blank=True)
    igreja = models.CharField(_(u'Igreja'), max_length=255, null=True, blank=True)
    arcipreste = models.BooleanField(_(u'Arcipreste'), default=False)
    vice_arcipreste = models.BooleanField(_(u'Vice-Arcipreste'), default=False)
    paroco = models.BooleanField(_(u'Pároco'), default=False)
    capelao = models.BooleanField(_(u'Capelão'), default=False)
    reitor = models.BooleanField(_(u'Reitor'), default=False)
    habilitacoes_academicas = models.TextField(_(u'Habilitações Académicas'), null=True, blank=True)
    publicacoes = models.TextField(_(u'Publicações'), null=True, blank=True)
    formacao_permanente = models.TextField(_(u'Formação Permanente'), null=True, blank=True)
    fraternidade_sacerdotal = models.BooleanField(_(u'Fraternidade Sacerdotal'), default=False)
    cartao_sacerdotal = models.IntegerField(_(u'Cartão Sacerdotal'), max_length=2, null=True, blank=True)
    nomeacoes = models.TextField(_(u'Nomeações'), null=True, blank=True)
    local_nascimento = models.CharField(_(u'Local de Nascimento'), max_length=255, null=True, blank=True)
    local_ordenacao  = models.CharField(_(u'Local de Ordenação'), max_length=255, null=True, blank=True)
    faleceu = models.BooleanField(_(u'Faleceu'), default=False)
    data_faleceu = models.DateField(_(u'Data Faleceu'), help_text='(aaaa-mm-dd)', null=True, blank=True)
    nomeacoes_actuais = models.TextField(_(u'Nomeações Actuais'), null=True, blank=True)
    #diacono = models.BooleanField(_(u'Diacono'), default=False)
    #arciprestado = models.ForeignKey(get_model('diocese','Arciprestado'), verbose_name=_(u'Arciprestado'), related_name='dioceses_presbiteros_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    #arciprestado = models.ForeignKey(Arciprestado, verbose_name=_(u'Arciprestado'), related_name='dioceses_presbiteros_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    #arciprestado = models.ForeignKey('diocese.Arciprestado', verbose_name=_(u'Arciprestado'), related_name='dioceses_presbiteros_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)

    #arciprestados = models.ManyToManyField('diocese.Arciprestado', through='diocese.PresbiteroArciprestado', related_name='dioceses_presbiteros_arciprestado', null=True, blank=True)

    #pass
    def get_clero_tipo(self):
        try:
            return dict(PRESBITERO_TIPOS_CHOICES)[self.clero_tipo]
        except Exception, e:
            #pass
            return None

    def get_paroquias(self):
        try:
            return get_model('diocese','Paroquia').objects.filter(Q(padre1=self.pk) | Q(padre2=self.pk) | Q(padre3=self.pk))
        except Exception, e:
            #pass
            return None


class PresbiteroRetiros(modelsPresbitero.getBasePresbiteroRetiros(Presbitero)):
    pass


class PresbiteroArciprestado(models.Model):
    presbitero = models.ForeignKey(Presbitero, verbose_name=_(u'Presbitero'), related_name='dioceses_presbiteroarciprestados_presbiteroarciprestados_presbitero')
    arciprestado = models.ForeignKey('diocese.Arciprestado', verbose_name=_(u'Arciprestado'), related_name='dioceses_presbiteroarciprestados_presbiteroarciprestados_arciprestado')

    class Meta(Base.Meta):
        #abstract = True
        verbose_name = _(u'Arciprestado')
        verbose_name_plural = _(u'Arciprestados')
        unique_together = ('presbitero', 'arciprestado',)

    def __unicode__(self):
        try:
            arciprestado = self.arciprestado.arciprestado
        except Exception, e:
            arciprestado=''
        return arciprestado

# Fim Presbitero





# Bispo
from diocesesim.diocese.bispo import models as modelsBispo

BISPO_TIPOS_CHOICES=(
    (1, _(u'Diocesano')),
    (2, _(u'Auxiliar')),
    (3, _(u'Coadjutor')),
    (4, _(u'Emérito')),
    (6, _(u'Emérito de outra Diocese')),
)

class Bispo(modelsBispo.getBaseBispo(BISPO_TIPOS_CHOICES)):
    foto = models.CharField(_(u'Foto'), max_length=255, null=True, blank=True)
    telemovel_privado = models.CharField(_(u'Telemóvel Privado'), max_length=255, null=True, blank=True)
    faleceu = models.BooleanField(_(u'Faleceu'), default=False)
    data_faleceu = models.DateField(_(u'Data Faleceu'), help_text='(aaaa-mm-dd)', null=True, blank=True)
    fraternidade_sacerdotal = models.BooleanField(_(u'Fraternidade Sacerdotal'), default=False)
    habilitacoes_academicas = models.TextField(_(u'Habilitações Académicas'), null=True, blank=True)
    nomeacoes = models.TextField(_(u'Nomeações'), null=True, blank=True)
    #noticia = models.TextField('Notícia', null=True, blank=True)
    #arciprestado = models.ForeignKey(get_model('diocese','Arciprestado'), verbose_name=_(u'Arciprestado'), related_name='dioceses_bispos_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    #arciprestado = models.ForeignKey(Arciprestado, verbose_name=_(u'Arciprestado'), related_name='dioceses_bispos_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    #arciprestado = models.ForeignKey('diocese.Arciprestado', verbose_name=_(u'Arciprestado'), related_name='dioceses_bispos_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)


class BispoArciprestado(models.Model):
    bispo = models.ForeignKey(Bispo, verbose_name=_(u'Bispo'), related_name='dioceses_bispoarciprestados_bispoarciprestados_bispo')
    arciprestado = models.ForeignKey('diocese.Arciprestado', verbose_name=_(u'Arciprestado'), related_name='dioceses_bispoarciprestados_bispoarciprestados_arciprestado')

    class Meta(Base.Meta):
        #abstract = True
        verbose_name = _(u'Arciprestado')
        verbose_name_plural = _(u'Arciprestados')
        unique_together = ('bispo', 'arciprestado',)

    def __unicode__(self):
        try:
            arciprestado = self.arciprestado.arciprestado
        except Exception, e:
            arciprestado=''
        return arciprestado

        
# Fim Bispo







# DiaconoPermanente
from diocesesim.diocese.diaconopermanente import models as modelsDiaconoPermanente

class DiaconoPermanente(modelsDiaconoPermanente.getBaseDiaconoPermanente()):
    foto = models.CharField(_(u'Foto'), max_length=255, null=True, blank=True)
    telemovel_privado = models.CharField(_(u'Telemóvel Privado'), max_length=255, null=True, blank=True)
    cartao_sacerdotal = models.IntegerField(_(u'Cartão Sacerdotal'), max_length=2, null=True, blank=True)
    nomeacoes = models.TextField(_(u'Nomeações'), null=True, blank=True)
    local_ordenacao = models.CharField(_(u'Local de Ordenação'), max_length=255, null=True, blank=True)
    faleceu = models.BooleanField(_(u'Faleceu'), default=False)
    data_faleceu = models.DateField(_(u'Data Faleceu'), help_text='(aaaa-mm-dd)', null=True, blank=True)
    delegado_coordenador = models.CharField(_(u'Delegado/Coordenador'), max_length=255, null=True, blank=True)
    local_nascimento = models.CharField(_(u'Local de Nascimento'), max_length=255, null=True, blank=True)
    #pass
    #arciprestado = models.ForeignKey(get_model('diocese','Arciprestado'), verbose_name=_(u'Arciprestado'), related_name='dioceses_diaconopermanentes_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    #arciprestado = models.ForeignKey(Arciprestado, verbose_name=_(u'Arciprestado'), related_name='dioceses_diaconopermanentes_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    #arciprestado = models.ForeignKey('diocese.Arciprestado', verbose_name=_(u'Arciprestado'), related_name='dioceses_diaconopermanentes_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)



class DiaconoPermanenteRetiros(modelsDiaconoPermanente.getBaseDiaconoPermanenteRetiros(DiaconoPermanente)):
    pass


class DiaconoPermanenteArciprestado(models.Model):
    diaconopermanente = models.ForeignKey(DiaconoPermanente, verbose_name=_(u'Diacono Permanente'), related_name='dioceses_diaconopermanentearciprestados_diaconopermanentearciprestados_diaconopermanente')
    arciprestado = models.ForeignKey('diocese.Arciprestado', verbose_name=_(u'Arciprestado'), related_name='dioceses_diaconopermanentearciprestados_diaconopermanentearciprestados_arciprestado')

    class Meta(Base.Meta):
        #abstract = True
        verbose_name = _(u'Arciprestado')
        verbose_name_plural = _(u'Arciprestados')
        unique_together = ('diaconopermanente', 'arciprestado',)

    def __unicode__(self):
        try:
            arciprestado = self.arciprestado.arciprestado
        except Exception, e:
            arciprestado=''
        return arciprestado

        
# Fim DiaconoPermanente








# Arciprestado
from diocesesim.diocese.arciprestado import models as modelsArciprestado

class Arciprestado(modelsArciprestado.getBaseArciprestado(Presbitero)):
    logo = models.CharField(_(u'Logo'), max_length=255, null=True, blank=True)
    #pass


# Fim Arciprestado


# NotaHistorica
from diocesesim.diocese.notahistorica import models as modelsNotaHistorica

class NotaHistorica(modelsNotaHistorica.getBaseNotaHistorica()):
    pass


# Fim NotaHistorica



# CuriaDiocesana
from diocesesim.diocese.curiadiocesana import models as modelsCuriaDiocesana

class CuriaDiocesana(modelsCuriaDiocesana.getBaseCuriaDiocesana()):
    #arciprestado = models.ForeignKey(get_model('diocese','Arciprestado'), verbose_name=_(u'Arciprestado'), related_name='dioceses_curiadiocesanas_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    arciprestado = models.ForeignKey(Arciprestado, verbose_name=_(u'Arciprestado'), related_name='dioceses_curiadiocesanas_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    director = models.CharField(_(u'Director'), max_length=255, null=True, blank=True)
    chanceler = models.CharField(_(u'Chanceler'), max_length=255, null=True, blank=True)
    secretariado_geral = models.CharField(_(u'Secretariado Geral'), max_length=255, null=True, blank=True)
    consultor_juridico = models.CharField(_(u'Consultor Jurídico'), max_length=255, null=True, blank=True)
    servico_legados_pios = models.CharField(_(u'Serviço de Legados Pios'), max_length=255, null=True, blank=True)
    associacoes_religiosas = models.CharField(_(u'Associações Religiosas'), max_length=255, null=True, blank=True)
    arquivo_secreto = models.CharField(_(u'Arquivo Secreto'), max_length=255, null=True, blank=True)
    arquivo_historico = models.CharField(_(u'Arquivo Histórico'), max_length=255, null=True, blank=True)
    notario = models.TextField(_(u'Notário'), null=True, blank=True)
    feriados = models.TextField(_(u'Feriados da Cúria'), null=True, blank=True)
    administradorcasaarquiepiscopal = models.CharField(_(u'Administrador da Casa Arquiepiscopal'), max_length=255, null=True, blank=True)
    foto = models.CharField(_(u'Foto'), max_length=255, null=True, blank=True)
    #pass
    def mostra_telemoveis(self):
        try:
            telemoveis = self.telemovel.replace(";", "/").split("/") if not self.telemovel is None else {}
        except Exception, e:
            telemoveis={}
        return telemoveis
    def mostra_conselho_episcopal(self):
        try:
            conselho_episcopal = self.conselho_episcopal.split("\n") if not self.conselho_episcopal is None else {}
        except Exception, e:
            conselho_episcopal={}
        return conselho_episcopal
    def mostra_vigarios_gerais(self):
        try:
            vigarios_gerais = self.vigarios_gerais.split("\n") if not self.vigarios_gerais is None else {}
        except Exception, e:
            vigarios_gerais={}
        return vigarios_gerais
    def mostra_direvigarios_episcopais(self):
        try:
            direvigarios_episcopais = self.direvigarios_episcopais.split("\n") if not self.direvigarios_episcopais is None else {}
        except Exception, e:
            direvigarios_episcopais={}
        return direvigarios_episcopais
    def mostra_secretariado_geral(self):
        try:
            secretariado_geral = self.secretariado_geral.replace(";", "/").split("/") if not self.secretariado_geral is None else {}
        except Exception, e:
            secretariado_geral={}
        return secretariado_geral





# Fim CuriaDiocesana


# Chancelaria
from diocesesim.diocese.chancelaria import models as modelsChancelaria

class Chancelaria(modelsChancelaria.getBaseChancelaria()):
    #arciprestado = models.ForeignKey(get_model('diocese','Arciprestado'), verbose_name=_(u'Arciprestado'), related_name='dioceses_chancelarias_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    arciprestado = models.ForeignKey(Arciprestado, verbose_name=_(u'Arciprestado'), related_name='dioceses_chancelarias_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    foto = models.CharField(_(u'Foto'), max_length=255, null=True, blank=True)
    #pass

# Fim Chancelaria


# GestaoRecursos
from diocesesim.diocese.gestaorecursos import models as modelsGestaoRecursos

class GestaoRecursos(modelsGestaoRecursos.getBaseGestaoRecursos()):
    #arciprestado = models.ForeignKey(get_model('diocese','Arciprestado'), verbose_name=_(u'Arciprestado'), related_name='dioceses_gestaorecursos_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    arciprestado = models.ForeignKey(Arciprestado, verbose_name=_(u'Arciprestado'), related_name='dioceses_gestaorecursos_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    membros_natos = models.TextField(_(u'Membros Natos'), null=True, blank=True)
    membros_eleitos = models.TextField(_(u'Membros Eleitos'), null=True, blank=True)
    foto = models.CharField(_(u'Foto'), max_length=255, null=True, blank=True)
    #pass
    def mostra_tesouraria(self):
        try:
            tesouraria = self.tesouraria.replace(";", "\n").split("\n") if not self.tesouraria is None else {}
        except Exception, e:
            tesouraria={}
        return tesouraria
    def mostra_assuntos_economicos(self):
        try:
            assuntos_economicos = self.assuntos_economicos.replace(";", "\n").split("\n") if not self.assuntos_economicos is None else {}
        except Exception, e:
            assuntos_economicos={}
        return assuntos_economicos
    def mostra_membros_natos(self):
        membros_natos={}
        try:
            membros_natos = self.membros_natos.replace(";", "\n").split("\n") if not self.membros_natos is None else {}
        except Exception, e:
            membros_natos={}
        return membros_natos
    def mostra_membros_eleitos(self):
        membros_eleitos={}
        try:
            membros_eleitos = self.membros_eleitos.replace(";", "\n").split("\n") if not self.membros_eleitos is None else {}
        except Exception, e:
            membros_eleitos={}
        return membros_eleitos


# Fim GestaoRecursos


# ConselhoPresbiteral
from diocesesim.diocese.concelhopresbiteral import models as modelsConselhoPresbiteral

class ConselhoPresbiteral(modelsConselhoPresbiteral.getBaseConselhoPresbiteral()):
    #arciprestado = models.ForeignKey(get_model('diocese','Arciprestado'), verbose_name=_(u'Arciprestado'), related_name='dioceses_conselhopresbiterals_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    arciprestado = models.ForeignKey(Arciprestado, verbose_name=_(u'Arciprestado'), related_name='dioceses_conselhopresbiterals_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    morada = models.CharField(_(u'Morada'), max_length=255, null=True, blank=True)
    codigo_postal = models.CharField(_(u'Código postal'), max_length=255, null=True, blank=True)
    localidade = models.CharField(_(u'Localidade'), max_length=255, null=True, blank=True)
    telefone = models.CharField(_(u'Telefone'), max_length=255, null=True, blank=True)
    fax = models.CharField(_(u'Fax'), max_length=255, null=True, blank=True)
    email = models.CharField(_(u'Email'), max_length=255, null=True, blank=True)
    paginaweb = models.CharField(_(u'Página web'), max_length=255, null=True, blank=True)
    foto = models.CharField(_(u'Foto'), max_length=255, null=True, blank=True)
    #pass


# Fim ConselhoPresbiteral


# ColegioConsultores
from diocesesim.diocese.colegioconsultores import models as modelsColegioConsultores

class ColegioConsultores(modelsColegioConsultores.getBaseColegioConsultores()):
    #arciprestado = models.ForeignKey(get_model('diocese','Arciprestado'), verbose_name=_(u'Arciprestado'), related_name='dioceses_colegioconsultoress_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    arciprestado = models.ForeignKey(Arciprestado, verbose_name=_(u'Arciprestado'), related_name='dioceses_colegioconsultoress_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    morada = models.CharField(_(u'Morada'), max_length=255, null=True, blank=True)
    codigo_postal = models.CharField(_(u'Código postal'), max_length=255, null=True, blank=True)
    localidade = models.CharField(_(u'Localidade'), max_length=255, null=True, blank=True)
    telefone = models.CharField(_(u'Telefone'), max_length=255, null=True, blank=True)
    fax = models.CharField(_(u'Fax'), max_length=255, null=True, blank=True)
    email = models.CharField(_(u'Email'), max_length=255, null=True, blank=True)
    paginaweb = models.CharField(_(u'Página web'), max_length=255, null=True, blank=True)
    foto = models.CharField(_(u'Foto'), max_length=255, null=True, blank=True)
    #pass


# Fim ColegioConsultores


# Cabido
from diocesesim.diocese.cabido import models as modelsCabido

class Cabido(modelsCabido.getBaseCabido()):
    morada = models.CharField(_(u'Morada'), max_length=255, null=True, blank=True)
    telefone = models.CharField(_(u'Telefone'), max_length=255, null=True, blank=True)
    email = models.CharField(_(u'Email'), max_length=255, null=True, blank=True)
    arcipreste = models.CharField(_(u'Arcipreste'), max_length=255, null=True, blank=True)
    fax = models.CharField(_(u'Fax'), max_length=255, null=True, blank=True)

# Fim Cabido


# ConselhoPastoral
from diocesesim.diocese.conselhopastoral import models as modelsConselhoPastoral

class ConselhoPastoral(modelsConselhoPastoral.getBaseConselhoPastoral()):
    #arciprestado = models.ForeignKey(get_model('diocese','Arciprestado'), verbose_name=_(u'Arciprestado'), related_name='dioceses_conselhopastorals_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    arciprestado = models.ForeignKey(Arciprestado, verbose_name=_(u'Arciprestado'), related_name='dioceses_conselhopastorals_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    morada = models.CharField(_(u'Morada'), max_length=255, null=True, blank=True)
    codigo_postal = models.CharField(_(u'Código postal'), max_length=255, null=True, blank=True)
    localidade = models.CharField(_(u'Localidade'), max_length=255, null=True, blank=True)
    telefone = models.CharField(_(u'Telefone'), max_length=255, null=True, blank=True)
    fax = models.CharField(_(u'Fax'), max_length=255, null=True, blank=True)
    email = models.CharField(_(u'Email'), max_length=255, null=True, blank=True)
    paginaweb = models.CharField(_(u'Página web'), max_length=255, null=True, blank=True)
    foto = models.CharField(_(u'Foto'), max_length=255, null=True, blank=True)
    #pass

# Fim ConselhoPastoral


# ColegioArciprestes
from diocesesim.diocese.colegioarciprestes import models as modelsColegioArciprestes

class ColegioArciprestes(modelsColegioArciprestes.getBaseColegioArciprestes()):
    #arciprestado = models.ForeignKey(get_model('diocese','Arciprestado'), verbose_name=_(u'Arciprestado'), related_name='dioceses_colegioarciprestess_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    arciprestado = models.ForeignKey(Arciprestado, verbose_name=_(u'Arciprestado'), related_name='dioceses_colegioarciprestess_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    morada = models.CharField(_(u'Morada'), max_length=255, null=True, blank=True)
    codigo_postal = models.CharField(_(u'Código postal'), max_length=255, null=True, blank=True)
    localidade = models.CharField(_(u'Localidade'), max_length=255, null=True, blank=True)
    telefone = models.CharField(_(u'Telefone'), max_length=255, null=True, blank=True)
    fax = models.CharField(_(u'Fax'), max_length=255, null=True, blank=True)
    email = models.CharField(_(u'Email'), max_length=255, null=True, blank=True)
    paginaweb = models.CharField(_(u'Página web'), max_length=255, null=True, blank=True)
    foto = models.CharField(_(u'Foto'), max_length=255, null=True, blank=True)
    #pass

# Fim ColegioArciprestes


# Secretariado
from diocesesim.diocese.secretariado import models as modelsSecretariado

class Secretariado(modelsSecretariado.getBaseSecretariado()):
    #arciprestado = models.ForeignKey(get_model('diocese','Arciprestado'), verbose_name=_(u'Arciprestado'), related_name='dioceses_secretariados_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    arciprestado = models.ForeignKey(Arciprestado, verbose_name=_(u'Arciprestado'), related_name='dioceses_secretariados_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    foto = models.CharField(_(u'Foto'), max_length=255, null=True, blank=True)
    #pass

    def get_paginaweb(self):
        if self.paginaweb is None:
            return None
        else:
            return ('http://' if not self.paginaweb.startswith('http://') else '') + self.paginaweb

# Fim Secretariado


# Comissao
from diocesesim.diocese.comissao import models as modelsComissao

class Comissao(modelsComissao.getBaseComissao()):
    #arciprestado = models.ForeignKey(get_model('diocese','Arciprestado'), verbose_name=_(u'Arciprestado'), related_name='dioceses_comissaos_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    arciprestado = models.ForeignKey(Arciprestado, verbose_name=_(u'Arciprestado'), related_name='dioceses_comissaos_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    foto = models.CharField(_(u'Foto'), max_length=255, null=True, blank=True)
    #pass

# Fim Comissao


# TribunalEclesiastico
from diocesesim.diocese.tribunaleclesiastico import models as modelsTribunalEclesiastico

class TribunalEclesiastico(modelsTribunalEclesiastico.getBaseTribunalEclesiastico()):
    #arciprestado = models.ForeignKey(get_model('diocese','Arciprestado'), verbose_name=_(u'Arciprestado'), related_name='dioceses_tribunaleclesiasticos_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    arciprestado = models.ForeignKey(Arciprestado, verbose_name=_(u'Arciprestado'), related_name='dioceses_tribunaleclesiasticos_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    foto = models.CharField(_(u'Foto'), max_length=255, null=True, blank=True)
    #pass
    def mostra_telemoveis(self):
        try:
            telemoveis = self.telemovel.replace(";", "/").split("/") if not self.telemovel is None else {}
        except Exception, e:
            telemoveis={}
        return telemoveis
    def mostra_vigariojudicialad(self):
        try:
            vigariojudicialad = self.vigariojudicialad.replace(",", ";").split(";") if not self.vigariojudicialad is None else {}
        except Exception, e:
            vigariojudicialad={}
        return vigariojudicialad
    def mostra_juizes_diocesanos(self):
        try:
            juizes_diocesanos = self.juizes_diocesanos.replace(",", "\n").split("\n") if not self.juizes_diocesanos is None else {}
        except Exception, e:
            juizes_diocesanos={}
        return juizes_diocesanos
    def mostra_notario_actuario(self):
        try:
            notario_actuario = self.notario_actuario.replace(",", "\n").split("\n") if not self.notario_actuario is None else {}
        except Exception, e:
            notario_actuario={}
        return notario_actuario



# Fim TribunalEclesiastico


# Seminario
from diocesesim.diocese.seminario import models as modelsSeminario

class Seminario(modelsSeminario.getBaseSeminario()):
    #arciprestado = models.ForeignKey(get_model('diocese','Arciprestado'), verbose_name=_(u'Arciprestado'), related_name='dioceses_seminarios_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    arciprestado = models.ForeignKey(Arciprestado, verbose_name=_(u'Arciprestado'), related_name='dioceses_seminarios_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    foto = models.CharField(_(u'Foto'), max_length=255, null=True, blank=True)
    #pass

    def get_url(self):
        if self.paginaweb is None:
            return None
        else:
            return ('http://' if not self.paginaweb.startswith('http://') else '') + self.paginaweb


# Fim Seminario


# DiaconadoPermanente
from diocesesim.diocese.diaconadopermanente import models as modelsDiaconadoPermanente

class DiaconadoPermanente(modelsDiaconadoPermanente.getBaseDiaconadoPermanente()):
    #arciprestado = models.ForeignKey(get_model('diocese','Arciprestado'), verbose_name=_(u'Arciprestado'), related_name='dioceses_diaconadopermanentes_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    arciprestado = models.ForeignKey(Arciprestado, verbose_name=_(u'Arciprestado'), related_name='dioceses_diaconadopermanentes_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    foto = models.CharField(_(u'Foto'), max_length=255, null=True, blank=True)
    #pass


# Fim DiaconadoPermanente


# FormacaoAgentePastoral
from diocesesim.diocese.formacaoagentepastoral import models as modelsFormacaoAgentePastoral

class FormacaoAgentePastoral(modelsFormacaoAgentePastoral.getBaseFormacaoAgentePastoral()):
    #arciprestado = models.ForeignKey(get_model('diocese','Arciprestado'), verbose_name=_(u'Arciprestado'), related_name='dioceses_formacaoagentepastorals_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    arciprestado = models.ForeignKey(Arciprestado, verbose_name=_(u'Arciprestado'), related_name='dioceses_formacaoagentepastorals_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    foto = models.CharField(_(u'Foto'), max_length=255, null=True, blank=True)
    #pass

# Fim FormacaoAgentePastoral



# CentroVidaCrista
from diocesesim.diocese.centrovidacrista import models as modelsCentroVidaCrista

CENTROVIDACRISTA_TIPOS_CHOICES=(
    (1, _(u'Reitorias/Capelanias')),
    (2, _(u'Santuários')),
)

class CentroVidaCrista(modelsCentroVidaCrista.getBaseCentroVidaCrista(CENTROVIDACRISTA_TIPOS_CHOICES)):
    #arciprestado = models.ForeignKey(get_model('diocese','Arciprestado'), verbose_name=_(u'Arciprestado'), related_name='dioceses_centrovidacristas_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    arciprestado = models.ForeignKey(Arciprestado, verbose_name=_(u'Arciprestado'), related_name='dioceses_centrovidacristas_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    foto = models.CharField(_(u'Foto'), max_length=255, null=True, blank=True)
    #pass

# Fim CentroVidaCrista



# AssociacaoObraPresbitero
from diocesesim.diocese.associacaoobrapresbitero import models as modelsAssociacaoObraPresbitero

class AssociacaoObraPresbitero(modelsAssociacaoObraPresbitero.getBaseAssociacaoObraPresbitero()):
    #arciprestado = models.ForeignKey(get_model('diocese','Arciprestado'), verbose_name=_(u'Arciprestado'), related_name='dioceses_associacaoobrapersbiteros_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    arciprestado = models.ForeignKey(Arciprestado, verbose_name=_(u'Arciprestado'), related_name='dioceses_associacaoobrapersbiteros_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    membros_eleitos = models.TextField(_(u'Membros Eleitos'), null=True, blank=True)
    foto = models.CharField(_(u'Foto'), max_length=255, null=True, blank=True)
    #pass
    def mostra_membros_eleitos(self):
        membros_eleitos={}
        try:
            membros_eleitos = self.membros_eleitos.replace(";", "").split("\n") if not self.membros_eleitos is None else {}
        except Exception, e:
            membros_eleitos={}
        return membros_eleitos

# Fim AssociacaoObraPresbitero


# PrelaturaPessoal
from diocesesim.diocese.prelaturapessoal import models as modelsPrelaturaPessoal

PRELATURAPESSOAL_CONGREGACOES_CHOICES = (
    ('', _(u'---------')),
    (1, _(u'Adoradoras Escravas do Santíssimo Sacramento e da Caridade - AASC')),
    (2, _(u'Aliança de Santa Maria (ASM)')),
    (3, _(u'Auxiliadoras da Caridade')),
    (4, _(u'Beneditinas Missionárias de Tutzing – OSB')),
    (5, _(u'Carmelitas Missionárias – C.M.')),
    (6, _(u'Carmelitas Missionárias Teresinas')),
    (7, _(u'Congregação da Apresentação de Maria - PM')),
    (10, _(u'Congregação da Divina Providência e Sagrada Família – DPSF')),
    (13, _(u'Congregação das Irmãs do Santíssimo Salvador')),
    (11, _(u'Congregação das Irmãs Franciscanas Hospitaleiras da Imaculada Conceição - CONFHIC')),
    (14, _(u'Congregação das Irmãs Servas da Sagrada Família')),
    (8, _(u'Congregação das Monjas Beneditinas da Rainha dos Apóstolos')),
    (15, _(u'Congregação das Servas Franciscanas de Nossa Senhora das Graças')),
    (9, _(u'Congregação do Bom Pastor')),
    (16, _(u'Cooperadoras Paroquiais de Santa Maria – CPSM')),
    (17, _(u'Criaditas dos Pobres')),
    (96, _(u'Doroteias (ou Irmãs Doroteias) - Província do norte')),
    (95, _(u'Doroteias (ou Irmãs Doroteias) - Província do Sul')),
    (18, _(u'Escravas da Eucaristia – ESEMD')),
    (19, _(u'Escravas do Sagrado Coração de Jesus – ACI')),
    (12, _(u'Filhas da Caridade – Canossianas Missionárias')),
    (20, _(u'Filhas da Caridade de São Vicente de Paulo')),
    (22, _(u'Filhas de Maria Auxiliadora - (FMA) – Salesianas')),
    (23, _(u'Filhas de Maria Mãe da Igreja – FMMI')),
    (24, _(u'Filhas de Nossa Senhora das Dores')),
    (28, _(u'Filhas de S. Camilo')),
    (27, _(u'Filhas de Santa Maria de Guadalupe - F.S.M.G')),
    (21, _(u'Filhas do Coração de Maria – F.C.M.')),
    (32, _(u'Franciscanas de Nossa Senhora do Bom Conselho – FBC')),
    (29, _(u'Franciscanas Missionárias da Mãe do Divino Pastor – FMMDP')),
    (30, _(u'Franciscanas Missionárias de Maria – FMM')),
    (31, _(u'Franciscanas Missionárias de Nossa Senhora – F.M.N.S.')),
    (33, _(u'Fraternidade Franciscana da Divina Providência')),
    (34, _(u'Fraternidade Missionária Verbum Dei')),
    (25, _(u'Instituto das Irmãs da Misericórdia de Verona')),
    (42, _(u'Instituto das Pequenas Missionárias de Maria Imaculada – IPMMI')),
    (43, _(u'Instituto das Religiosas do Sagrado Coração de Maria - RSCM')),
    (35, _(u'Instituto Filhas de Santa Maria de Leuca')),
    (36, _(u'Instituto Irmãs Missionárias de Nossa Senhora de Fátima')),
    (37, _(u'Instituto Jesus Maria José')),
    (44, _(u'Irmãs Angélicas de São Paulo')),
    (45, _(u'Irmãs Carmelitas – CSCJ')),
    (46, _(u'Irmãs Concepcionistas ao Serviço dos Pobres – CSP')),
    (100, _(u'Irmãs da Caridade do Sagrado Coração de Jesus')),
    (77, _(u'Irmãs da Santa Cruz')),
    (72, _(u'Irmãs de Nossa Senhora da Glória')),
    (78, _(u'Irmãs de São João Baptista e de Maria Raínha')),
    (47, _(u'Irmãs Discípulas do Divino Mestre')),
    (49, _(u'Irmãs Dominicanas de Santa Catarina de Sena')),
    (48, _(u'Irmãs Dominicanas Irlandesas (do Bom Sucesso)')),
    (76, _(u'Irmãs dos Sagrados Corações – SS.CC')),
    (51, _(u'Irmãs Franciscanas da Imaculada')),
    (52, _(u'Irmãs Franciscanas da Imaculada Conceição')),
    (97, _(u'Irmãs Franciscanas de Nossa Senhora das Vitórias - Cúria Geral')),
    (98, _(u'Irmãs Franciscanas de Nossa Senhora das Vitórias - Província de Cristo Rei')),
    (99, _(u'Irmãs Franciscanas de Nossa Senhora das Vitórias - Província do Coração de Maria')),
    (50, _(u'Irmãs Franciscanas Evangelizadoras de Nossa Senhora da Esperança – FENSE')),
    (56, _(u'Irmãs Hospitaleiras do Sagrado Coração de Jesus')),
    (39, _(u'Irmãs Mercedárias da Caridade')),
    (57, _(u'Irmãs Missionárias Combonianas')),
    (58, _(u'Irmãs Missionárias da Consolata')),
    (70, _(u'Irmãs Missionárias de S. Pedro Claver')),
    (59, _(u'Irmãs Missionárias do Espírito Santo')),
    (71, _(u'Irmãs Missionárias Scalabrinianas')),
    (73, _(u'Irmãs Oblatas do Santíssimo Redentor')),
    (74, _(u'Irmãs Paulinas – FSP')),
    (75, _(u'Irmãs Reparadoras Missionárias da Santa Face')),
    (79, _(u'Irmãs S. José de Cluny – S.J.C.')),
    (60, _(u'Irmãs Servas de Maria Reparadoras – SMR')),
    (61, _(u'Irmãs Servidoras de Jesus do Cottolengo do Padre Alegre')),
    (63, _(u'Irmãzinhas da Assunção – I . A.')),
    (64, _(u'Irmãzinhas de Jesus')),
    (62, _(u'Irmãzinhas dos Anciãos desamparados')),
    (65, _(u'Irmãzinhas dos Pobres – I.P.')),
    (67, _(u'Missionárias Claretianas -  M.C.')),
    (40, _(u'Missionárias Cordimarianas – MC')),
    (68, _(u'Missionárias Cruzadas da Igreja – M.C.I.')),
    (66, _(u'Missionárias da Caridade (Da Madre Teresa de Calcutá) – M.C.')),
    (53, _(u'Missionárias de São Domingos')),
    (82, _(u'Missionárias do Precioso Sangue – C.P.S.')),
    (84, _(u'Missionárias do Santíssimo – M.S.S.')),
    (69, _(u'Missionárias Dominicanas do Rosário')),
    (81, _(u'Missionárias dos Pobres')),
    (80, _(u'Missionárias Eucarísticas de Nazaré – M.E.N.')),
    (83, _(u'Missionárias Reparadoras do Sagrado Coração de Jesus – M.R.')),
    (85, _(u'Missionárias Servas do Espírito Santo')),
    (86, _(u'Oblatas do Coração de Jesus')),
    (87, _(u'Oblatas do Divino Coração – O.D.C.')),
    (41, _(u'Religiosas da Instrução Cristã')),
    (89, _(u'Religiosas de Maria de Imaculada – R.M.I.')),
    (88, _(u'Religiosas do Amor de Deus – R.A.D.')),
    (90, _(u'Reparadoras de Nossa Senhora das Dores de Fátima')),
    (91, _(u'Servas da Divina Providência')),
    (55, _(u'Servas da Santa Igreja – S.S.I.')),
    (38, _(u'Servas de Jesus da Caridade – S. de J.')),
    (93, _(u'Servas de Maria (S de M)')),
    (94, _(u'Servas de Nossa Senhora de Fátima – SNSF')),
    (92, _(u'Servas Franciscanas  Reparadoras de Jesus Sacramentado – SFRJS')),
    (54, _(u'Teresianas – STJ')),
)

class PrelaturaPessoal(modelsPrelaturaPessoal.getBasePrelaturaPessoal(PRELATURAPESSOAL_CONGREGACOES_CHOICES)):
    #arciprestado = models.ForeignKey(get_model('diocese','Arciprestado'), verbose_name=_(u'Arciprestado'), related_name='dioceses_prelaturapessoals_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    arciprestado = models.ForeignKey(Arciprestado, verbose_name=_(u'Arciprestado'), related_name='dioceses_prelaturapessoals_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    foto = models.CharField(_(u'Foto'), max_length=255, null=True, blank=True)
    #pass

# Fim PrelaturaPessoal


# InstitutoReligiosoFeminino
from diocesesim.diocese.institutoreligiosofeminino import models as modelsInstitutoReligiosoFeminino

INSTITUTORELIGIOSOFEMININO_CONGREGACOES_CHOICES = (
    ('', _(u'---------')),
    (1, _(u'Adoradoras Escravas do Santíssimo Sacramento e da Caridade - AASC')),
    (2, _(u'Aliança de Santa Maria (ASM)')),
    (3, _(u'Auxiliadoras da Caridade')),
    (4, _(u'Beneditinas Missionárias de Tutzing – OSB')),
    (5, _(u'Carmelitas Missionárias – C.M.')),
    (6, _(u'Carmelitas Missionárias Teresinas')),
    (7, _(u'Congregação da Apresentação de Maria - PM')),
    (10, _(u'Congregação da Divina Providência e Sagrada Família – DPSF')),
    (13, _(u'Congregação das Irmãs do Santíssimo Salvador')),
    (11, _(u'Congregação das Irmãs Franciscanas Hospitaleiras da Imaculada Conceição - CONFHIC')),
    (14, _(u'Congregação das Irmãs Servas da Sagrada Família')),
    (8, _(u'Congregação das Monjas Beneditinas da Rainha dos Apóstolos')),
    (15, _(u'Congregação das Servas Franciscanas de Nossa Senhora das Graças')),
    (9, _(u'Congregação do Bom Pastor')),
    (16, _(u'Cooperadoras Paroquiais de Santa Maria – CPSM')),
    (17, _(u'Criaditas dos Pobres')),
    (96, _(u'Doroteias (ou Irmãs Doroteias) - Província do norte')),
    (95, _(u'Doroteias (ou Irmãs Doroteias) - Província do Sul')),
    (18, _(u'Escravas da Eucaristia – ESEMD')),
    (19, _(u'Escravas do Sagrado Coração de Jesus – ACI')),
    (12, _(u'Filhas da Caridade – Canossianas Missionárias')),
    (20, _(u'Filhas da Caridade de São Vicente de Paulo')),
    (22, _(u'Filhas de Maria Auxiliadora - (FMA) – Salesianas')),
    (23, _(u'Filhas de Maria Mãe da Igreja – FMMI')),
    (24, _(u'Filhas de Nossa Senhora das Dores')),
    (28, _(u'Filhas de S. Camilo')),
    (27, _(u'Filhas de Santa Maria de Guadalupe - F.S.M.G')),
    (21, _(u'Filhas do Coração de Maria – F.C.M.')),
    (32, _(u'Franciscanas de Nossa Senhora do Bom Conselho – FBC')),
    (29, _(u'Franciscanas Missionárias da Mãe do Divino Pastor – FMMDP')),
    (30, _(u'Franciscanas Missionárias de Maria – FMM')),
    (31, _(u'Franciscanas Missionárias de Nossa Senhora – F.M.N.S.')),
    (33, _(u'Fraternidade Franciscana da Divina Providência')),
    (34, _(u'Fraternidade Missionária Verbum Dei')),
    (25, _(u'Instituto das Irmãs da Misericórdia de Verona')),
    (42, _(u'Instituto das Pequenas Missionárias de Maria Imaculada – IPMMI')),
    (43, _(u'Instituto das Religiosas do Sagrado Coração de Maria - RSCM')),
    (35, _(u'Instituto Filhas de Santa Maria de Leuca')),
    (36, _(u'Instituto Irmãs Missionárias de Nossa Senhora de Fátima')),
    (37, _(u'Instituto Jesus Maria José')),
    (44, _(u'Irmãs Angélicas de São Paulo')),
    (45, _(u'Irmãs Carmelitas – CSCJ')),
    (46, _(u'Irmãs Concepcionistas ao Serviço dos Pobres – CSP')),
    (100, _(u'Irmãs da Caridade do Sagrado Coração de Jesus')),
    (77, _(u'Irmãs da Santa Cruz')),
    (72, _(u'Irmãs de Nossa Senhora da Glória')),
    (78, _(u'Irmãs de São João Baptista e de Maria Raínha')),
    (47, _(u'Irmãs Discípulas do Divino Mestre')),
    (49, _(u'Irmãs Dominicanas de Santa Catarina de Sena')),
    (48, _(u'Irmãs Dominicanas Irlandesas (do Bom Sucesso)')),
    (76, _(u'Irmãs dos Sagrados Corações – SS.CC')),
    (51, _(u'Irmãs Franciscanas da Imaculada')),
    (52, _(u'Irmãs Franciscanas da Imaculada Conceição')),
    (97, _(u'Irmãs Franciscanas de Nossa Senhora das Vitórias - Cúria Geral')),
    (98, _(u'Irmãs Franciscanas de Nossa Senhora das Vitórias - Província de Cristo Rei')),
    (99, _(u'Irmãs Franciscanas de Nossa Senhora das Vitórias - Província do Coração de Maria')),
    (50, _(u'Irmãs Franciscanas Evangelizadoras de Nossa Senhora da Esperança – FENSE')),
    (56, _(u'Irmãs Hospitaleiras do Sagrado Coração de Jesus')),
    (39, _(u'Irmãs Mercedárias da Caridade')),
    (57, _(u'Irmãs Missionárias Combonianas')),
    (58, _(u'Irmãs Missionárias da Consolata')),
    (70, _(u'Irmãs Missionárias de S. Pedro Claver')),
    (59, _(u'Irmãs Missionárias do Espírito Santo')),
    (71, _(u'Irmãs Missionárias Scalabrinianas')),
    (73, _(u'Irmãs Oblatas do Santíssimo Redentor')),
    (74, _(u'Irmãs Paulinas – FSP')),
    (75, _(u'Irmãs Reparadoras Missionárias da Santa Face')),
    (79, _(u'Irmãs S. José de Cluny – S.J.C.')),
    (60, _(u'Irmãs Servas de Maria Reparadoras – SMR')),
    (61, _(u'Irmãs Servidoras de Jesus do Cottolengo do Padre Alegre')),
    (63, _(u'Irmãzinhas da Assunção – I . A.')),
    (64, _(u'Irmãzinhas de Jesus')),
    (62, _(u'Irmãzinhas dos Anciãos desamparados')),
    (65, _(u'Irmãzinhas dos Pobres – I.P.')),
    (67, _(u'Missionárias Claretianas -  M.C.')),
    (40, _(u'Missionárias Cordimarianas – MC')),
    (68, _(u'Missionárias Cruzadas da Igreja – M.C.I.')),
    (66, _(u'Missionárias da Caridade (Da Madre Teresa de Calcutá) – M.C.')),
    (53, _(u'Missionárias de São Domingos')),
    (82, _(u'Missionárias do Precioso Sangue – C.P.S.')),
    (84, _(u'Missionárias do Santíssimo – M.S.S.')),
    (69, _(u'Missionárias Dominicanas do Rosário')),
    (81, _(u'Missionárias dos Pobres')),
    (80, _(u'Missionárias Eucarísticas de Nazaré – M.E.N.')),
    (83, _(u'Missionárias Reparadoras do Sagrado Coração de Jesus – M.R.')),
    (85, _(u'Missionárias Servas do Espírito Santo')),
    (86, _(u'Oblatas do Coração de Jesus')),
    (87, _(u'Oblatas do Divino Coração – O.D.C.')),
    (41, _(u'Religiosas da Instrução Cristã')),
    (89, _(u'Religiosas de Maria de Imaculada – R.M.I.')),
    (88, _(u'Religiosas do Amor de Deus – R.A.D.')),
    (90, _(u'Reparadoras de Nossa Senhora das Dores de Fátima')),
    (91, _(u'Servas da Divina Providência')),
    (55, _(u'Servas da Santa Igreja – S.S.I.')),
    (38, _(u'Servas de Jesus da Caridade – S. de J.')),
    (93, _(u'Servas de Maria (S de M)')),
    (94, _(u'Servas de Nossa Senhora de Fátima – SNSF')),
    (92, _(u'Servas Franciscanas  Reparadoras de Jesus Sacramentado – SFRJS')),
    (54, _(u'Teresianas – STJ')),
)

class InstitutoReligiosoFeminino(modelsInstitutoReligiosoFeminino.getBaseInstitutoReligiosoFeminino(INSTITUTORELIGIOSOFEMININO_CONGREGACOES_CHOICES)):
    #arciprestado = models.ForeignKey(get_model('diocese','Arciprestado'), verbose_name=_(u'Arciprestado'), related_name='dioceses_institutoreligiosofemininos_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    arciprestado = models.ForeignKey(Arciprestado, verbose_name=_(u'Arciprestado'), related_name='dioceses_institutoreligiosofemininos_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    foto = models.CharField(_(u'Foto'), max_length=255, null=True, blank=True)
    #pass

    def get_url(self):
        if self.paginaweb is None:
            return None
        else:
            return ('http://' if not self.paginaweb.startswith('http://') else '') + self.paginaweb


# Fim InstitutoReligiosoFeminino


# InstitutoReligiosoMasculino
from diocesesim.diocese.institutoreligiosomasculino import models as modelsInstitutoReligiosoMasculino

INSTITUTORELIGIOSOMASCULINO_CONGREGACOES_CHOICES = (
    ('', _(u'---------')),
    (31, _(u'Agostinhos – O.S.A.')),
    (2, _(u'Beneditinos – O.S.B.')),
    (11, _(u'Carmelitas – Ordem do Carmo - O. CARM.')),
    (3, _(u'Carmelitas Descalços – O.C.D. ')),
    (4, _(u'Cartuxos – O-Cart')),
    (38, _(u'Consolata – I. M. C.')),
    (7, _(u'Dehonianos – SCJ')),
    (8, _(u'Dominicanos – O.P.')),
    (9, _(u'Dominicanos Irlandeses – O.P.')),
    (10, _(u'Espiritanos – C.S.Sp.')),
    (29, _(u'Filhos da Caridade - F.C.')),
    (30, _(u'Frades Menores Conventuais – O.F.M. Conv.')),
    (19, _(u'Franciscanos – O.F.M.')),
    (1, _(u'Irmãos de Jesus')),
    (14, _(u'Irmãos de La Salle - Lassalistas – F.S.C. ')),
    (12, _(u'Irmãos de S. João de Deus, O.H.')),
    (26, _(u'Irmãozinhos de São Francisco de Assis – FISFA')),
    (34, _(u'Jesuítas – S.J.')),
    (28, _(u'Maristas – F.M.S')),
    (5, _(u'Missionários Claretianos – C.M.F.')),
    (18, _(u'Missionários Combonianos – M.C.C.J')),
    (35, _(u'Missionários de São João Baptista – M.S.J.B.')),
    (20, _(u'Missionários do Verbo Divino ')),
    (33, _(u'Missionários Monfortinos – S.M.M.')),
    (25, _(u'Missionários Redentoristas – C.S.S.R.')),
    (6, _(u'Ordem de Santa Cruz - Padres Crúzios')),
    (17, _(u'Padres Capuchinhos – O.F.M.CAP. ')),
    (39, _(u'Padres de Schoenstatt')),
    (36, _(u'Padres Marianos – M.I.C.')),
    (32, _(u'Padres Palotinos')),
    (37, _(u'Padres Paulistas – SSP')),
    (13, _(u'Padres Vicentinos – C.M.')),
    (27, _(u'Passionistas – CP.')),
    (15, _(u'Preciosíssimo Sangue – C.P.P.S.')),
    (24, _(u'Sagrados Corações – SS.CC.')),
    (16, _(u'Salesianos – SDB')),
    (23, _(u'Scalabrinianos – C.S.')),
    (22, _(u'Shalom (Comunidade) ')),
    (21, _(u'Sociedade Missionária da Boa Nova – SMBN')),
)

class InstitutoReligiosoMasculino(modelsInstitutoReligiosoMasculino.getBaseInstitutoReligiosoMasculino(INSTITUTORELIGIOSOMASCULINO_CONGREGACOES_CHOICES)):
    #arciprestado = models.ForeignKey(get_model('diocese','Arciprestado'), verbose_name=_(u'Arciprestado'), related_name='dioceses_institutoreligiosomasculinos_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    arciprestado = models.ForeignKey(Arciprestado, verbose_name=_(u'Arciprestado'), related_name='dioceses_institutoreligiosomasculinos_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    foto = models.CharField(_(u'Foto'), max_length=255, null=True, blank=True)
    #pass

    def get_url(self):
        if self.paginaweb is None:
            return None
        else:
            return ('http://' if not self.paginaweb.startswith('http://') else '') + self.paginaweb


# Fim InstitutoReligiosoMasculino


# InstitutoSecular
from diocesesim.diocese.institutosecular import models as modelsInstitutoSecular

INSTITUTOSECLARES_INSTITUTOS_CHOICES = (
      ('', _(u'---------')),
      (6, _(u'Ancilla Domini')),
      (7, _(u'Anunciatinas')),
      (8, _(u'Caritas Chisti – C.C.')),
      (9, _(u'Companhia Missionária do Coração de Jesus')),
      (10, _(u'Cooperadoras da Família')),
      (11, _(u'Filiação Cordimariana')),
      (19, _(u'Instituto Secular da Sagrada Família – ISSF')),
      (12, _(u'Instituto Secular do Coração de Jesus – (Família Cor Unum)')),
      (21, _(u'Instituto Servas do Apostolado – ISA')),
      (13, _(u'Irmãs de Maria de Schoenstatt – ISSM')),
      (15, _(u'Missionárias Combonianas')),
      (14, _(u'Missionárias do Amor Misericordioso do Coração de Jesus – MAMCJ')),
      (16, _(u'Nossa Senhora de Schoenstatt – ISNSS')),
      (17, _(u'Padres de Schoenstatt – ISch')),
      (18, _(u'Pequena Família Franciscana')),
      (20, _(u'Santa Família – ISF')),
      (22, _(u'Voluntárias de D. Bosco – VDB')),
)

class InstitutoSecular(modelsInstitutoSecular.getBaseInstitutoSecular(INSTITUTOSECLARES_INSTITUTOS_CHOICES)):
    #arciprestado = models.ForeignKey(get_model('diocese','Arciprestado'), verbose_name=_(u'Arciprestado'), related_name='dioceses_institutoseculars_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    arciprestado = models.ForeignKey(Arciprestado, verbose_name=_(u'Arciprestado'), related_name='dioceses_institutoseculars_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    assistente = models.CharField(_(u'Assistente'), max_length=255, null=True, blank=True)
    foto = models.CharField(_(u'Foto'), max_length=255, null=True, blank=True)
    #pass

    def get_url(self):
        if self.paginaweb is None:
            return None
        else:
            return ('http://' if not self.paginaweb.startswith('http://') else '') + self.paginaweb

# Fim InstitutoSecular


# SociedadeVidaApostolica
from diocesesim.diocese.sociedadevidaapostolica import models as modelsSociedadeVidaApostolica

class SociedadeVidaApostolica(modelsSociedadeVidaApostolica.getBaseSociedadeVidaApostolica()):
    foto = models.CharField(_(u'Foto'), max_length=255, null=True, blank=True)
    #pass

# Fim SociedadeVidaApostolica


# AssociacaoMovimentoObra
from diocesesim.diocese.associacaomovimentoobra import models as modelsAssociacaoMovimentoObra

class AssociacaoMovimentoObra(modelsAssociacaoMovimentoObra.getBaseAssociacaoMovimentoObra()):
    #arciprestado = models.ForeignKey(get_model('diocese','Arciprestado'), verbose_name=_(u'Arciprestado'), related_name='dioceses_associacaomovimentoobras_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    arciprestado = models.ForeignKey(Arciprestado, verbose_name=_(u'Arciprestado'), related_name='dioceses_associacaomovimentoobras_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    foto = models.CharField(_(u'Foto'), max_length=255, null=True, blank=True)
    #pass

# Fim AssociacaoMovimentoObra


# CentroAnimacaoEspiritual
from diocesesim.diocese.centroanimacaoespiritual import models as modelsCentroAnimacaoEspiritual

class CentroAnimacaoEspiritual(modelsCentroAnimacaoEspiritual.getBaseCentroAnimacaoEspiritual()):
    #arciprestado = models.ForeignKey(get_model('diocese','Arciprestado'), verbose_name=_(u'Arciprestado'), related_name='dioceses_centroanimacaoespirituals_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    arciprestado = models.ForeignKey(Arciprestado, verbose_name=_(u'Arciprestado'), related_name='dioceses_centroanimacaoespirituals_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    assistente = models.CharField(_(u'Assistente'), max_length=255, null=True, blank=True)
    foto = models.CharField(_(u'Foto'), max_length=255, null=True, blank=True)
    #pass

# Fim CentroAnimacaoEspiritual


# ObraAccaoSocioCaritativa
from diocesesim.diocese.obraaccaosociocaritativa import models as modelsObraAccaoSocioCaritativa

OBRAACAOCARITATIVA_VALENCIAS_CHOICES = (
    ('', _(u'---------')),
    (15, _(u'Apoio domiciliário')),
    (8, _(u'ATL')),
    (16, _(u'Centro de Dia')),
    (3, _(u'Centros Sociais Paroquiais')),
    (6, _(u'Infantários e Creches')),
    (19, _(u'Jardim de Infância')),
    (11, _(u'Lar - Estudantes')),
    (13, _(u'Lar - Idosos')),
    (12, _(u'Lar - Jovens')),
    (9, _(u'Outro')),
    (14, _(u'Patronatos')),
    (20, _(u'Reabilitação e Reinserção Social de Toxicodependentes')),
)

class Valencias(modelsObraAccaoSocioCaritativa.getBaseValencias()):
    pass

class ObraAccaoSocioCaritativa(modelsObraAccaoSocioCaritativa.getBaseObraAccaoSocioCaritativa(Valencias, OBRAACAOCARITATIVA_VALENCIAS_CHOICES)):
    #arciprestado = models.ForeignKey(get_model('diocese','Arciprestado'), verbose_name=_(u'Arciprestado'), related_name='dioceses_obraaccaosociocaritativas_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    arciprestado = models.ForeignKey(Arciprestado, verbose_name=_(u'Arciprestado'), related_name='dioceses_obraaccaosociocaritativas_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    assistente = models.CharField(_(u'Assistente'), max_length=255, null=True, blank=True)
    foto = models.CharField(_(u'Foto'), max_length=255, null=True, blank=True)
    #pass

# Fim ObraAccaoSocioCaritativa


# EscolaCatolica
from diocesesim.diocese.escolacatolica import models as modelsEscolaCatolica

class EscolaCatolica(modelsEscolaCatolica.getBaseEscolaCatolica()):
    #arciprestado = models.ForeignKey(get_model('diocese','Arciprestado'), verbose_name=_(u'Arciprestado'), related_name='dioceses_escolacatolicas_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    arciprestado = models.ForeignKey(Arciprestado, verbose_name=_(u'Arciprestado'), related_name='dioceses_escolacatolicas_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    foto = models.CharField(_(u'Foto'), max_length=255, null=True, blank=True)
    #pass

# Fim EscolaCatolica


# InstituicaoCultural
from diocesesim.diocese.instituicaocultural import models as modelsInstituicaoCultural

class InstituicaoCultural(modelsInstituicaoCultural.getBaseInstituicaoCultural()):
    #arciprestado = models.ForeignKey(get_model('diocese','Arciprestado'), verbose_name=_(u'Arciprestado'), related_name='dioceses_institutoculturals_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    arciprestado = models.ForeignKey(Arciprestado, verbose_name=_(u'Arciprestado'), related_name='dioceses_institutoculturals_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    foto = models.CharField(_(u'Foto'), max_length=255, null=True, blank=True)
    #pass

class InstituicaoCulturalForm(modelsInstituicaoCultural.getBaseInstituicaoCulturalForm(InstituicaoCultural)):
    nome = forms.CharField(label=_(u'Nome'), max_length=255, required=True, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    director = forms.CharField(label=_(u'Responsável/ Director'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    propriedade = forms.CharField(label=_(u'Propriedade'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    morada = forms.CharField(label=_(u'Morada'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    codigo_postal = forms.CharField(label=_(u'Código postal'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    localidade = forms.CharField(label=_(u'Localidade'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telefone = forms.CharField(label=_(u'Telefone'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telemovel = forms.CharField(label=_(u'Telemóvel'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    fax = forms.CharField(label=_(u'Fax'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    email = forms.CharField(label=_(u'Email'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    paginaweb = forms.CharField(label=_(u'Página web'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    obs = forms.CharField(label=_(u'Observações'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    foto = forms.CharField(label=u'Foto', widget=ElfinderImageWidget, required=False)

    class Meta(modelsInstituicaoCultural.getBaseInstituicaoCulturalForm(InstituicaoCultural).Meta):
        widgets = {
                'fs': forms.widgets.HiddenInput,
                'foto': ElfinderImageWidget(attrs={'a':'a'}),
            }

# Fim InstituicaoCultural


# ComunicacaoSocial
from diocesesim.diocese.comunicacaosocial import models as modelsComunicacaoSocial

COMUNICACAOSOCIAL_TIPOS_CHOICES = (
    ('', _(u'---------')),
    (1, _(u'Boletim')),
    (7, _(u'Editora')),
    (6, _(u'Jornal')),
    (5, _(u'Livraria')),
    (4, _(u'Rádio')),
    (3, _(u'Revista')),
    (2, _(u'Tipografia')),
)

COMUNICACAOSOCIAL_PERIOCIDADES_CHOICES = (
    ('', _(u'---------')),
    (9, _(u'Anual')),
    (7, _(u'Bimensal')),
    (8, _(u'Bimestral')),
    (6, _(u'Diário')),
    (5, _(u'Mensal')),
    (4, _(u'Quadrimestral')),
    (3, _(u'Quinzenal')),
    (2, _(u'Semanal')),
    (1, _(u'Trimestral')),
)

class ComunicacaoSocial(modelsComunicacaoSocial.getBaseComunicacaoSocial(COMUNICACAOSOCIAL_TIPOS_CHOICES, COMUNICACAOSOCIAL_PERIOCIDADES_CHOICES)):
    #arciprestado = models.ForeignKey(get_model('diocese','Arciprestado'), verbose_name=_(u'Arciprestado'), related_name='dioceses_comicacaosocials_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    arciprestado = models.ForeignKey(Arciprestado, verbose_name=_(u'Arciprestado'), related_name='dioceses_comicacaosocials_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    foto = models.CharField(_(u'Foto'), max_length=255, null=True, blank=True)
    #pass

# Fim ComunicacaoSocial


# DadosEstatisticos
from diocesesim.diocese.dadosestatisticos import models as modelsDadosEstatisticos

class DadosEstatisticos(modelsDadosEstatisticos.getBaseDadosEstatisticos()):
    pass

class DadosEstatisticosForm(modelsDadosEstatisticos.getBaseDadosEstatisticosForm(DadosEstatisticos)):
    ano = forms.IntegerField(label=_(u'ANO'), required=True, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    superficie = forms.IntegerField(label=_(u'Superfície (Km2)'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    populacao = forms.IntegerField(label=_(u'População'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    catolicos = forms.IntegerField(label=_(u'Católicos'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    arciprestados = forms.IntegerField(label=_(u'Arciprestados (vigararias ou ouvidorias)'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    paroquias = forms.IntegerField(label=_(u'Paróquias (ou equiparadas)'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    pclerodiocesano = forms.IntegerField(label=_(u'- com pároco próprio (clero diocesano)'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    pcleroreligioso = forms.IntegerField(label=_(u'- com pároco próprio (clero religioso)'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    poutrosacerdote = forms.IntegerField(label=_(u'-  administradas por outro sacerdote (1)'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    pdiaconosper = forms.IntegerField(label=_(u'-  confiadas a diáconos permanentes'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    preligiosas = forms.IntegerField(label=_(u'-  confiadas a religiosas'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    pleigos = forms.IntegerField(label=_(u'-  confiadas a leigos'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    totalmentevacantes = forms.IntegerField(label=_(u'-  totalmente vacantes'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    capelanias = forms.IntegerField(label=_(u'Capelanias (2)'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    sacerdotesdiocesanos = forms.IntegerField(label=_(u'Sacerdotes diocesanos (incardinados)'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    spdiocesepropria = forms.IntegerField(label=_(u'- em serviço pastoral na diocese própria'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    spnoutradiocese = forms.IntegerField(label=_(u'- em serviço pastoral noutra diocese'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    foraservicopastoral = forms.IntegerField(label=_(u'-  fora do serviço pastoral'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    srrdiocese = forms.IntegerField(label=_(u'Sacerdotes religiosos residentes na diocese'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    srrtotalpartesdiocese = forms.IntegerField(label=_(u'- total ou em parte ao serviço da diocese'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    srrservicoinstituto = forms.IntegerField(label=_(u'- ao serviço estrito do seu instituto'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    srrforaservicopastoral = forms.IntegerField(label=_(u'-  fora do serviço pastoral (3)'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    religiososprofessosnsacerdotes = forms.IntegerField(label=_(u'Religiosos professos não sacerdotes (4)'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    religiosasprofessasrd = forms.IntegerField(label=_(u'Religiosas professas residentes na diocese'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    diaconospermanentes = forms.IntegerField(label=_(u'Diáconos Permanentes (já ordenados)'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    candidatossacerdocio = forms.IntegerField(label=_(u'Candidatos ao Sacerdócio (5)'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    cscelrodiocesano = forms.IntegerField(label=_(u'-  para o clero diocesano'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    cscleroreligioso = forms.IntegerField(label=_(u'-  para o clero religioso'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    del1 = forms.IntegerField(label=_(u'Para  candidatos ao sacerdócio'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    cficlerodiocesano = forms.IntegerField(label=_(u'-  do clero diocesano'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    cficleroreligioso = forms.IntegerField(label=_(u'-  do clero religioso'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    del2 = forms.IntegerField(label=_(u'Centros de instrução e educação (6)'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    cieescolasmaternoinfantis = forms.IntegerField(label=_(u'-  Escolas materno-infantis'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    cieescolasprimarias = forms.IntegerField(label=_(u'-  Escolas primárias'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    cieescolassecundarias = forms.IntegerField(label=_(u'-  Escolas secundárias'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    cieinstitutossuperiores = forms.IntegerField(label=_(u'- Institutos Superiores'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    cieuniversidadecatolica = forms.IntegerField(label=_(u'- Faculdades da UCP'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    cashospitais = forms.IntegerField(label=_(u'Hospitais'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    #del0 = forms.IntegerField(label=_(u' '), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    casambulatorios = forms.IntegerField(label=_(u'Ambulatórios e dispensários'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    cascasasdeidosos = forms.IntegerField(label=_(u'Casas de idosos, doentes e crónicos  deficientes'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    casorfanatos = forms.IntegerField(label=_(u'Orfanatos e outros centros de tutela da infância'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    cascreches = forms.IntegerField(label=_(u'Creches'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    casconsultoriosfamiliares = forms.IntegerField(label=_(u'Consultórios familiares (8)'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    cascentrosespeciais = forms.IntegerField(label=_(u'Centros especiais de educação ou reeducação social'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    cascentrossociais = forms.IntegerField(label=_(u'Centros sociais canonicamente erectos (9)'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    casconfrarias = forms.IntegerField(label=_(u'Confrarias e Irmandades canonicamente erectas (10)'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    casmisericordias = forms.IntegerField(label=_(u'Misericórdias (incluídas ou não no já referido)'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    vsbaptizados = forms.IntegerField(label=_(u'Baptizados'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    vsate1ano = forms.IntegerField(label=_(u'-  até 1 ano'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    vsde1a7anos = forms.IntegerField(label=_(u'-  de 1 a 7 anos'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    vsapos7anos = forms.IntegerField(label=_(u'-  após os 7 anos'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    vsconfirmacoes = forms.IntegerField(label=_(u'Confirmações'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    vsprimeirascomunhoes = forms.IntegerField(label=_(u'Primeiras Comunhões'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    vsmatrimonioscanonicos = forms.IntegerField(label=_(u'Matrimónios canónicos'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    vsmcentrecatolicos = forms.IntegerField(label=_(u'- entre católicos '), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    vsmcentrecatolicoencatolico = forms.IntegerField(label=_(u'- entre católico e não católico'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    ecseditorascatolicas = forms.IntegerField(label=_(u'Editoras católicas na diocese (11)'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    ecslivrarias = forms.IntegerField(label=_(u'Livrarias e distribuidoras católicas (12)'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    ecsjornaisdiarios = forms.IntegerField(label=_(u'Jornais (13) - Diários'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    ecsjornaissemanarios = forms.IntegerField(label=_(u'- Semanários'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    ecsjornaisquinzenarios = forms.IntegerField(label=_(u'- Quinzenários'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    ecsjornaismensarios = forms.IntegerField(label=_(u'- Mensários'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    ecsboletinsparoquiais = forms.IntegerField(label=_(u'Boletins Paroquiais e Interparoquiais'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    ecsradiosregionais = forms.IntegerField(label=_(u'Rádios (14) - Regionais'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    ecsradioslocais = forms.IntegerField(label=_(u'- Locais'), required=False, widget=forms.widgets.TextInput(attrs={'class':'vIntegerField fieldEcclesia'}))
    obs = forms.CharField(label=_(u'Observações'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))

# Fim DadosEstatisticos


# Paroquia
from diocesesim.diocese.paroquia import models as modelsParoquia

PAROQUIA_ORAGOS_CHOICES = (
    ('', _(u'---------')),
    (155, _(u'Apresentação de Nossa Senhora')),
    (116, _(u'Beato Nuno de Santa Maria')),
    (117, _(u'Beatos Nicolau Dinis e Bento de Castro')),
    (153, _(u'Bom Jesus')),
    (28, _(u'Bom Jesus Menino')),
    (417, _(u'Cadeira de São Pedro')),
    (157, _(u'Cadeira de São Pedro de Antioquia')),
    (341, _(u'Coração de Jesus')),
    (383, _(u'Coração de Maria')),
    (288, _(u'Coração Imaculado de Maria')),
    (143, _(u'Coração Imaculado de Maria e São João Baptista')),
    (358, _(u'Cristo-Rei')),
    (149, _(u'Degolação de São João Baptista')),
    (364, _(u'Divino Espírito Santo')),
    (405, _(u'Divino Salvador')),
    (271, _(u'Doze Apóstolos')),
    (108, _(u'Espírito Santo')),
    (195, _(u'Espírito Santo e Santo Antão')),
    (150, _(u'Exaltação de Santa Cruz')),
    (218, _(u'Imaculada Conceição')),
    (114, _(u'Imaculada Conceição e Santa Teresa de Ávila')),
    (245, _(u'Imaculado Coração de Maria')),
    (22, _(u'Jesus, Maria e José')),
    (148, _(u'Natividade de Nossa Senhora')),
    (348, _(u'Nossa Senhora')),
    (208, _(u'Nossa Senhora ao Pé da Cruz')),
    (161, _(u'Nossa Senhora Auxiliadora')),
    (219, _(u'Nossa Senhora Calçada')),
    (224, _(u'Nossa Senhora Conduzende')),
    (203, _(u'Nossa Senhora Coros')),
    (71, _(u'Nossa Senhora da Abela')),
    (19, _(u'Nossa Senhora da Ajuda')),
    (320, _(u'Nossa Senhora da Ajuda e São Lourenço')),
    (204, _(u'Nossa Senhora da Alagoa')),
    (133, _(u'Nossa Senhora da Alegria')),
    (419, _(u'Nossa Senhora da Anunciação')),
    (379, _(u'Nossa Senhora da Anunciada')),
    (13, _(u'Nossa Senhora da Apresentação')),
    (336, _(u'Nossa Senhora da Assunção')),
    (300, _(u'Nossa Senhora da Assunção e Ressurreição de Cristo')),
    (183, _(u'Nossa Senhora da Atalaia')),
    (142, _(u'Nossa Senhora da Atocha')),
    (401, _(u'Nossa Senhora da Azinheira')),
    (441, _(u'Nossa Senhora da Boa Água')),
    (162, _(u'Nossa Senhora da Boa Esperança')),
    (160, _(u'Nossa Senhora da Boa Fé')),
    (381, _(u'Nossa Senhora da Boa Hora')),
    (240, _(u'Nossa Senhora da Boa Memória')),
    (293, _(u'Nossa Senhora da Boa Nova')),
    (24, _(u'Nossa Senhora da Boa Viagem')),
    (47, _(u'Nossa Senhora da Boa-Hora')),
    (281, _(u'Nossa Senhora da Conceição')),
    (201, _(u'Nossa Senhora da Consolação')),
    (228, _(u'Nossa Senhora da Corredoura')),
    (53, _(u'Nossa Senhora da Encarnação')),
    (308, _(u'Nossa Senhora da Encarnação e São Domingos')),
    (92, _(u'Nossa Senhora da Esperança')),
    (63, _(u'Nossa Senhora da Estrela')),
    (407, _(u'Nossa Senhora da Expectação')),
    (292, _(u'Nossa Senhora da Fé')),
    (243, _(u'Nossa Senhora da Gaiola')),
    (362, _(u'Nossa Senhora da Glória')),
    (70, _(u'Nossa Senhora da Graça')),
    (66, _(u'Nossa Senhora da Guadalupe')),
    (390, _(u'Nossa Senhora da Guia')),
    (322, _(u'Nossa Senhora da Hora')),
    (440, _(u'Nossa Senhora da Incarnação')),
    (169, _(u'Nossa Senhora da Lagoa')),
    (290, _(u'Nossa Senhora da Lapa')),
    (399, _(u'Nossa Senhora da Livração')),
    (167, _(u'Nossa Senhora da Luz')),
    (286, _(u'Nossa Senhora da Misericórdia')),
    (353, _(u'Nossa Senhora da Natividade')),
    (43, _(u'Nossa Senhora da Nazaré')),
    (111, _(u'Nossa Senhora da Oliveira')),
    (171, _(u'Nossa Senhora da Orada')),
    (411, _(u'Nossa Senhora da Ouvida')),
    (151, _(u'Nossa Senhora da Paz')),
    (251, _(u'Nossa Senhora da Pena')),
    (212, _(u'Nossa Senhora da Penha')),
    (31, _(u'Nossa Senhora da Penha de França')),
    (4, _(u'Nossa Senhora da Piedade')),
    (277, _(u'Nossa Senhora da Porta do Céu')),
    (227, _(u'Nossa Senhora da Pureza')),
    (339, _(u'Nossa Senhora da Purificação')),
    (377, _(u'Nossa Senhora da Redenção')),
    (365, _(u'Nossa Senhora da Ribeira')),
    (282, _(u'Nossa Senhora da Salvação')),
    (18, _(u'Nossa Senhora da Saúde')),
    (305, _(u'Nossa Senhora da Saúde e São Sebastião')),
    (213, _(u'Nossa Senhora da Silva')),
    (72, _(u'Nossa Senhora da Soledade')),
    (175, _(u'Nossa Senhora da Vila')),
    (395, _(u'Nossa Senhora da Vinha')),
    (328, _(u'Nossa Senhora da Visitação')),
    (279, _(u'Nossa Senhora da Vitória')),
    (193, _(u'Nossa Senhora da Vitória e Santa Rita')),
    (6, _(u'Nossa Senhora das Angústias')),
    (280, _(u'Nossa Senhora das Areias')),
    (40, _(u'Nossa Senhora das Areias e São Jacinto')),
    (418, _(u'Nossa Senhora das Boas Novas')),
    (172, _(u'Nossa Senhora das Brotas')),
    (232, _(u'Nossa Senhora das Candeias')),
    (272, _(u'Nossa Senhora das Dores')),
    (158, _(u'Nossa Senhora das Graças')),
    (403, _(u'Nossa Senhora das Júnias')),
    (250, _(u'Nossa Senhora das Mercês')),
    (247, _(u'Nossa Senhora das Misericórdias')),
    (16, _(u'Nossa Senhora das Necessidades')),
    (57, _(u'Nossa Senhora das Neves')),
    (139, _(u'Nossa Senhora das Ondas')),
    (196, _(u'Nossa Senhora das Preces')),
    (67, _(u'Nossa Senhora das Relíquias')),
    (285, _(u'Nossa Senhora das Virtudes')),
    (296, _(u'Nossa Senhora de Aboboriz')),
    (2, _(u'Nossa Senhora de Alva')),
    (97, _(u'Nossa Senhora de Assunção')),
    (33, _(u'Nossa Senhora de Belém')),
    (156, _(u'Nossa Senhora de Espariz')),
    (360, _(u'Nossa Senhora de Fátima')),
    (164, _(u'Nossa Senhora de Guadalupe')),
    (34, _(u'Nossa Senhora de la Salette')),
    (128, _(u'Nossa Senhora de Lurdes')),
    (366, _(u'Nossa Senhora de Marvila')),
    (306, _(u'Nossa Senhora de Monserrate')),
    (199, _(u'Nossa Senhora do Açor')),
    (223, _(u'Nossa Senhora do Ameal')),
    (266, _(u'Nossa Senhora do Amparo')),
    (12, _(u'Nossa Senhora do Ar')),
    (174, _(u'Nossa Senhora do Bispo')),
    (194, _(u'Nossa Senhora do Bom Caminho')),
    (326, _(u'Nossa Senhora do Bom Despacho')),
    (188, _(u'Nossa Senhora do Bom Sucesso')),
    (45, _(u'Nossa Senhora do Bom Sucesso e São Paio')),
    (309, _(u'Nossa Senhora do Cabo')),
    (42, _(u'Nossa Senhora do Carmo')),
    (215, _(u'Nossa Senhora do Castelo')),
    (244, _(u'Nossa Senhora do Desterro')),
    (226, _(u'Nossa Senhora do Enxertado')),
    (432, _(u'Nossa Senhora do Espinheiro')),
    (29, _(u'Nossa Senhora do Guadalupe')),
    (197, _(u'Nossa Senhora do Livramento')),
    (187, _(u'Nossa Senhora do Loreto')),
    (229, _(u'Nossa Senhora do Loureiro')),
    (159, _(u'Nossa Senhora do Monte')),
    (380, _(u'Nossa Senhora do Monte Sião')),
    (36, _(u'Nossa Senhora do Ó')),
    (59, _(u'Nossa Senhora do Outeiro')),
    (238, _(u'Nossa Senhora do Patrocínio')),
    (294, _(u'Nossa Senhora do Perpétuo Socorro')),
    (30, _(u'Nossa Senhora do Pilar')),
    (297, _(u'Nossa Senhora do Pópulo')),
    (311, _(u'Nossa Senhora do Porto Salvo')),
    (408, _(u'Nossa Senhora do Pranto')),
    (370, _(u'Nossa Senhora do Reclamador')),
    (166, _(u'Nossa Senhora do Rosário')),
    (7, _(u'Nossa Senhora do Socorro')),
    (235, _(u'Nossa Senhora do Torrão')),
    (412, _(u'Nossa Senhora do Viso')),
    (433, _(u'Nossa Senhora dos Altos Céus')),
    (20, _(u'Nossa Senhora dos Anjos')),
    (299, _(u'Nossa Senhora dos Mártires')),
    (10, _(u'Nossa Senhora dos Milagres')),
    (258, _(u'Nossa Senhora dos Navegantes')),
    (25, _(u'Nossa Senhora dos Prazeres')),
    (106, _(u'Nossa Senhora dos Reis')),
    (8, _(u'Nossa Senhora dos Remédios')),
    (236, _(u'Nossa Senhora Entre Vinhas')),
    (50, _(u'Nossa Senhora Entre-as-Vinhas')),
    (136, _(u'Nossa Senhora Finisterra')),
    (23, _(u'Nossa Senhora Mãe de Deus')),
    (424, _(u'Nossa Senhora Mãe dos Homens')),
    (233, _(u'Nossa Senhora Piedade')),
    (124, _(u'Nossa Senhora Rainha')),
    (189, _(u'Nossa Senhora Rainha do Mundo')),
    (303, _(u'Nossa Senhora Rainha dos Apóstolos')),
    (205, _(u'Nossa Senhora Rocamador')),
    (95, _(u'Nosso Senhor dos Navegantes')),
    (434, _(u'O Salvador')),
    (186, _(u'Rei Salvador')),
    (270, _(u'Reis Magos')),
    (268, _(u'Sagrada Família')),
    (46, _(u'Sagrado Coração de Jesus')),
    (298, _(u'Sagrado Coração de Maria')),
    (284, _(u'Salvador do Mundo')),
    (406, _(u'Santa Águeda')),
    (54, _(u'Santa Ana')),
    (51, _(u'Santa Bárbara')),
    (259, _(u'Santa Beatriz')),
    (60, _(u'Santa Brígida')),
    (242, _(u'Santa Catarina')),
    (107, _(u'Santa Catarina de Alexandria')),
    (252, _(u'Santa Catarina do Monte Sinai')),
    (104, _(u'Santa Catarina Maior')),
    (146, _(u'Santa Cecília')),
    (333, _(u'Santa Clara')),
    (52, _(u'Santa Clara de Assis')),
    (421, _(u'Santa Columba')),
    (386, _(u'Santa Comba')),
    (359, _(u'Santa Cristina')),
    (394, _(u'Santa Cristina e São Silvestre')),
    (352, _(u'Santa Cruz')),
    (41, _(u'Santa Cruz e Nossa Senhora da Apresentação')),
    (126, _(u'Santa Engrácia')),
    (144, _(u'Santa Eufemia')),
    (105, _(u'Santa Eugénia')),
    (331, _(u'Santa Eulália')),
    (313, _(u'Santa Iria')),
    (91, _(u'Santa Isabel')),
    (439, _(u'Santa Isabel de Portugal')),
    (273, _(u'Santa Joana')),
    (38, _(u'Santa Joana Princesa')),
    (173, _(u'Santa Justa')),
    (323, _(u'Santa Leocádia')),
    (75, _(u'Santa Lucrécia')),
    (181, _(u'Santa Luzia')),
    (324, _(u'Santa Margarida')),
    (182, _(u'Santa Maria')),
    (425, _(u'Santa Maria da Devesa')),
    (404, _(u'Santa Maria da Feira')),
    (384, _(u'Santa Maria da Graça')),
    (168, _(u'Santa Maria da Lagoa')),
    (44, _(u'Santa Maria da Natividade')),
    (388, _(u'Santa Maria da Porta')),
    (372, _(u'Santa Maria da Serra e São João Baptista')),
    (385, _(u'Santa Maria das Neves')),
    (179, _(u'Santa Maria de Alcáçova')),
    (5, _(u'Santa Maria do Castelo')),
    (392, _(u'Santa Maria dos Anjos')),
    (371, _(u'Santa Maria dos Olivais')),
    (315, _(u'Santa Maria e São Miguel')),
    (376, _(u'Santa Maria e São Pedro')),
    (115, _(u'Santa Maria e São Vicente')),
    (137, _(u'Santa Maria Madalena')),
    (147, _(u'Santa Maria Maior')),
    (3, _(u'Santa Maria Nossa Senhora da Assunção')),
    (349, _(u'Santa Maria Nossa Senhora da Expectação')),
    (154, _(u'Santa Marinha')),
    (98, _(u'Santa Marta')),
    (198, _(u'Santa Quitéria')),
    (32, _(u'Santa Rita')),
    (81, _(u'Santa Senhorinha')),
    (176, _(u'Santa Sofia')),
    (319, _(u'Santa Susana')),
    (82, _(u'Santa Tecla')),
    (287, _(u'Santa Teresa do Menino Jesus')),
    (184, _(u'Santa Vitória')),
    (253, _(u'Santas Justa e Rufina')),
    (378, _(u'Santiago')),
    (423, _(u'Santiago Maior')),
    (11, _(u'Santíssima Trindade')),
    (248, _(u'Santíssimo Coração de Jesus')),
    (302, _(u'Santíssimo Nome de Jesus')),
    (289, _(u'Santíssimo Redentor')),
    (278, _(u'Santíssimo Sacramento')),
    (48, _(u'Santíssimo Salvador')),
    (327, _(u'Santo Adrião')),
    (129, _(u'Santo Agostinho')),
    (64, _(u'Santo Aleixo')),
    (65, _(u'Santo Amador')),
    (110, _(u'Santo Amaro')),
    (332, _(u'Santo André')),
    (249, _(u'Santo André e Santa Marinha')),
    (77, _(u'Santo André, Apóstolo')),
    (274, _(u'Santo Anjo de Portugal')),
    (387, _(u'Santo Antão')),
    (382, _(u'Santo António')),
    (191, _(u'Santo António de Lisboa')),
    (109, _(u'Santo Apolinário')),
    (262, _(u'Santo Condestável')),
    (9, _(u'Santo Cristo')),
    (347, _(u'Santo Cruz')),
    (237, _(u'Santo Elias')),
    (78, _(u'Santo Emilião')),
    (123, _(u'Santo Estevão')),
    (260, _(u'Santo Eugénio')),
    (415, _(u'Santo Eusébio')),
    (361, _(u'Santo Eustáquio')),
    (113, _(u'Santo Ildefonso')),
    (414, _(u'Santo Isidoro')),
    (37, _(u'Santo Isidoro de Sevilha')),
    (375, _(u'Santo Isidro')),
    (214, _(u'Santo Nome de Jesus')),
    (356, _(u'Santo Ovídio')),
    (85, _(u'Santo Tirso')),
    (15, _(u'Santos Reis Magos')),
    (263, _(u'Santos Veríssimo, Máxima e Júlia')),
    (337, _(u'São Barnabé')),
    (241, _(u'São Bartolomeu')),
    (291, _(u'São Bento')),
    (118, _(u'São Bento e São Francisco')),
    (39, _(u'São Bernardo')),
    (127, _(u'São Brás')),
    (367, _(u'São Braz')),
    (61, _(u'São Brissos')),
    (141, _(u'São Caetano')),
    (410, _(u'São Carlos Borromeu')),
    (88, _(u'São Cipriano')),
    (100, _(u'São Ciríaco')),
    (83, _(u'São Cláudio')),
    (87, _(u'São Clemente')),
    (211, _(u'São Cosme')),
    (351, _(u'São Cosme e São Damião')),
    (125, _(u'São Cristóvão')),
    (255, _(u'São Cristóvão e São Lourenço')),
    (62, _(u'São Cucufate')),
    (427, _(u'São Dâmaso ')),
    (73, _(u'São Domingos')),
    (230, _(u'São Domingos de Gusmão')),
    (178, _(u'São Domingos Sávio')),
    (222, _(u'São Facundo')),
    (330, _(u'São Faustino')),
    (225, _(u'São Faustino e São Jovita')),
    (393, _(u'São Felix')),
    (334, _(u'São Félix de Gerona')),
    (94, _(u'São Félix e Santa Marinha')),
    (112, _(u'São Filipe')),
    (400, _(u'São Francisco')),
    (239, _(u'São Francisco de Assis')),
    (442, _(u'São Francisco de Borja')),
    (264, _(u'São Francisco de Paula')),
    (265, _(u'São Francisco Xavier')),
    (120, _(u'São Frutuoso')),
    (135, _(u'São Gabriel Arcanjo')),
    (121, _(u'São Genésio')),
    (145, _(u'São Gens')),
    (177, _(u'São Geraldo')),
    (329, _(u'São Gonçalo')),
    (192, _(u'São Gonçalo de Amarante')),
    (207, _(u'São Gregório')),
    (283, _(u'São Gregório Magno')),
    (99, _(u'São Jerónimo')),
    (89, _(u'São João')),
    (314, _(u'São João Baptista')),
    (131, _(u'São João Baptista e Nossa Senhora da Conceição')),
    (101, _(u'São João Bosco')),
    (275, _(u'São João de Brito')),
    (276, _(u'São João de Deus')),
    (317, _(u'São João Degolado')),
    (429, _(u'São João do Souto ')),
    (420, _(u'São João Evangelista')),
    (17, _(u'São Jorge')),
    (134, _(u'São José')),
    (430, _(u'São José de São Lázaro ')),
    (374, _(u'São José Operário')),
    (391, _(u'São Julião')),
    (312, _(u'São Julião e Santa Bárbara')),
    (426, _(u'São Julião Mártir')),
    (132, _(u'São Justo')),
    (119, _(u'São Justo e Santa Justa')),
    (27, _(u'São Lázaro')),
    (304, _(u'São Leonardo')),
    (84, _(u'São Lourenço')),
    (318, _(u'São Lucas')),
    (68, _(u'São Luís')),
    (1, _(u'São Luís, Bispo')),
    (140, _(u'São Mamede')),
    (165, _(u'São Manços')),
    (55, _(u'São Marcos')),
    (93, _(u'São Martinho')),
    (389, _(u'São Martinho de Tours')),
    (138, _(u'São Martinho e Santa Maria de Alcáçova')),
    (90, _(u'São Mateus')),
    (58, _(u'São Matias')),
    (261, _(u'São Maximiliano Kolbe')),
    (80, _(u'São Miguel')),
    (413, _(u'São Miguel Arcanjo')),
    (335, _(u'São Nicolau')),
    (234, _(u'São Nicolau de Bari')),
    (256, _(u'São Nicolau e São Julião')),
    (35, _(u'São Paio')),
    (398, _(u'São Pantaleão')),
    (363, _(u'São Paulo')),
    (438, _(u'São Paulo, Apóstolo')),
    (200, _(u'São Pedro')),
    (202, _(u'São Pedro ad Vincula')),
    (396, _(u'São Pedro da Cadeira')),
    (220, _(u'São Pedro de Antioquia')),
    (350, _(u'São Pedro de Fins')),
    (316, _(u'São Pedro de Penaferrim')),
    (416, _(u'São Pedro de Verona')),
    (307, _(u'São Pedro dos Grilhões')),
    (301, _(u'São Pedro e São João')),
    (321, _(u'São Pedro e São Tiago')),
    (56, _(u'São Pedro, Apóstolo')),
    (102, _(u'São Pelágio')),
    (122, _(u'São Romão')),
    (21, _(u'São Roque')),
    (74, _(u'São Salvador')),
    (221, _(u'São Salvador do Mundo')),
    (185, _(u'São Saturnino')),
    (209, _(u'São Sebastião')),
    (435, _(u'São Sebastião, Mártir')),
    (369, _(u'São Silvestre')),
    (409, _(u'São Simão')),
    (96, _(u'São Simão e São Judas Tadeu')),
    (69, _(u'São Teotónio')),
    (217, _(u'São Tiago')),
    (254, _(u'São Tiago e São Martinho')),
    (437, _(u'São Tiago e São Mateus')),
    (231, _(u'São Tiago Maior')),
    (190, _(u'São Tiago Menor')),
    (431, _(u'São Tiago, Apóstolo')),
    (267, _(u'São Tomás de Aquino')),
    (402, _(u'São Tomé')),
    (86, _(u'São Torcato')),
    (343, _(u'São Veríssimo')),
    (76, _(u'São Vicente')),
    (269, _(u'São Vicente de Paulo')),
    (14, _(u'São Vicente Ferreira')),
    (436, _(u'São Vicente, Mártir')),
    (257, _(u'São Vicente, São Tomé e Salvador')),
    (428, _(u'São Vítor ')),
    (26, _(u'Senhor Bom Jesus')),
    (180, _(u'Senhor da Boa Fé')),
    (354, _(u'Senhor da Vera Cruz')),
    (342, _(u'Senhor do Bonfim')),
    (397, _(u'Senhor do Socorro')),
    (355, _(u'Senhor dos Aflitos')),
    (346, _(u'Senhor Jesus')),
    (368, _(u'Senhor Jesus dos Aflitos')),
    (246, _(u'Senhor Jesus dos Milagres')),
    (310, _(u'Senhor Jesus dos Navegantes')),
    (295, _(u'Senhor Jesus e São Pedro')),
    (340, _(u'Senhora da Ajuda')),
    (357, _(u'Senhora da Assunção')),
    (344, _(u'Senhora da Conceição')),
    (325, _(u'Senhora da Expectação')),
    (163, _(u'Senhora da Saúde')),
    (338, _(u'Senhora Do Amparo')),
    (206, _(u'Senhora dos Anjos')),
    (422, _(u'Transfiguração de Nosso Senhor')),
    (216, _(u'Transfiguração de Nosso Senhor Jesus Cristo')),
    (103, _(u'Transfiguração do Senhor')),
    (170, _(u'Vera Cruz')),
)
class Paroquia(modelsParoquia.getBaseParoquia(Arciprestado,Presbitero, PAROQUIA_ORAGOS_CHOICES)):
    foto = models.CharField(_(u'Foto'), max_length=255, null=True, blank=True)
    horario_missas = models.CharField(_(u'Horários das missas'), max_length=255, null=True, blank=True)
    horario_confissoes = models.CharField(_(u'Horários das Confissões'), max_length=255, null=True, blank=True)
    #pass
    def get_orago(self):
        try:
            return dict(PAROQUIA_ORAGOS_CHOICES)[self.orago]
        except Exception, e:
            #pass
            return None

    def get_paginaweb(self):
        if self.paginaweb is None:
            return None
        else:
            return ('http://' if not self.paginaweb.startswith('http://') else '') + self.paginaweb


# Fim Paroquia











# Models




class DiaconoRetiros(models.Model):
    #diacono = models.ForeignKey(get_model('diocese','Diacono'), verbose_name=_(u'Diacono'), related_name='dioceses_diaconoretiross_diaconoretiros_diacono')
    diacono = models.ForeignKey(Diacono, verbose_name=_(u'Diacono'), related_name='dioceses_diaconoretiross_diaconoretiros_diacono')
    ano = models.IntegerField(_(u'Ano'), max_length=4, null=True, blank=True)
    observacoes = models.CharField(u'Observações', max_length=255, null=True, blank=True)

    class Meta(Base.Meta):
        #abstract = True
        verbose_name = _(u'Retiro')
        verbose_name_plural = _(u'Retiros')
        unique_together = ('diacono', 'ano',)

    def __unicode__(self):
        try:
            retiro = self.diacono.nome+' - '+self.ano
        except Exception, e:
            retiro=''
        return retiro


class DiaconoParoquias(models.Model):
    #diacono = models.ForeignKey(get_model('diocese','Diacono'), verbose_name=_(u'Diacono'), related_name='dioceses_diaconoparoquiass_diaconoparoquias_diacono')
    #paroquia = models.ForeignKey(get_model('diocese','Paroquia'), verbose_name=_(u'Paroquia'), related_name='dioceses_diaconoparoquiass_diaconoparoquias_paroquia')
    diacono = models.ForeignKey(Diacono, verbose_name=_(u'Diacono'), related_name='dioceses_diaconoparoquiass_diaconoparoquias_diacono')
    paroquia = models.ForeignKey(Paroquia, verbose_name=_(u'Paroquia'), related_name='dioceses_diaconoparoquiass_diaconoparoquias_paroquia')

    class Meta(Base.Meta):
        #abstract = True
        verbose_name = _(u'Paroquia')
        verbose_name_plural = _(u'Paroquias')
        unique_together = ('diacono', 'paroquia',)

    def __unicode__(self):
        try:
            paroquia = self.paroquia.nome
        except Exception, e:
            paroquia=''
        return paroquia
# Fim Models


###
###
###


# Models
class OutraInstituicao(SharedBase):
    nome = models.CharField(_(u'Nome'), max_length=255)
    morada = models.CharField(_(u'Morada'), max_length=255, null=True, blank=True)
    codigo_postal = models.CharField(_(u'Código postal'), max_length=255, null=True, blank=True)
    localidade = models.CharField(_(u'Localidade'), max_length=255, null=True, blank=True)
    telefone = models.CharField(_(u'Telefone'), max_length=255, null=True, blank=True)
    telemovel = models.CharField(_(u'Telemóvel'), max_length=255, null=True, blank=True)
    fax = models.CharField(_(u'Fax'), max_length=255, null=True, blank=True)
    email = models.CharField(_(u'Email'), max_length=255, null=True, blank=True)
    paginaweb = models.CharField(_(u'Página web'), max_length=255, null=True, blank=True)
    #arciprestado = models.ForeignKey(get_model('diocese','Arciprestado'), verbose_name=_(u'Arciprestado'), related_name='dioceses_outrainstituicaos_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    arciprestado = models.ForeignKey(Arciprestado, verbose_name=_(u'Arciprestado'), related_name='dioceses_outrainstituicaos_arciprestado', null=True, blank=True, on_delete=models.SET_NULL)
    director = models.CharField(_(u'Director'), max_length=255, null=True, blank=True)
    foto = models.CharField(_(u'Foto'), max_length=255, null=True, blank=True)
    class Meta:
        verbose_name = _(u'Outra Instituição')
        verbose_name_plural = _(u'Outras Instituições')
        #abstract = True

    def __unicode__(self):
        return self.nome
# Fim Models



