# -*- coding: utf-8 -*-
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):
        # Adding field 'Presbitero.arciprestado'
        db.add_column('diocese_presbitero', 'arciprestado',
                      self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='dioceses_presbiteros_arciprestado', null=True, on_delete=models.SET_NULL, to=orm['diocese.Arciprestado']),
                      keep_default=False)

        # Adding field 'DiaconoPermanente.arciprestado'
        db.add_column('diocese_diaconopermanente', 'arciprestado',
                      self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='dioceses_diaconopermanentes_arciprestado', null=True, on_delete=models.SET_NULL, to=orm['diocese.Arciprestado']),
                      keep_default=False)

        # Adding field 'Bispo.arciprestado'
        db.add_column('diocese_bispo', 'arciprestado',
                      self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='dioceses_bispos_arciprestado', null=True, on_delete=models.SET_NULL, to=orm['diocese.Arciprestado']),
                      keep_default=False)

        # Adding field 'Diacono.arciprestado'
        db.add_column('diocese_diacono', 'arciprestado',
                      self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='dioceses_diaconos_arciprestado', null=True, on_delete=models.SET_NULL, to=orm['diocese.Arciprestado']),
                      keep_default=False)


    def backwards(self, orm):
        # Deleting field 'Presbitero.arciprestado'
        db.delete_column('diocese_presbitero', 'arciprestado_id')

        # Deleting field 'DiaconoPermanente.arciprestado'
        db.delete_column('diocese_diaconopermanente', 'arciprestado_id')

        # Deleting field 'Bispo.arciprestado'
        db.delete_column('diocese_bispo', 'arciprestado_id')

        # Deleting field 'Diacono.arciprestado'
        db.delete_column('diocese_diacono', 'arciprestado_id')


    models = {
        'auth.group': {
            'Meta': {'object_name': 'Group'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '80'}),
            'permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'})
        },
        'auth.permission': {
            'Meta': {'ordering': "('content_type__app_label', 'content_type__model', 'codename')", 'unique_together': "(('content_type', 'codename'),)", 'object_name': 'Permission'},
            'codename': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'content_type': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['contenttypes.ContentType']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '50'})
        },
        'auth.user': {
            'Meta': {'object_name': 'User'},
            'date_joined': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'email': ('django.db.models.fields.EmailField', [], {'max_length': '75', 'blank': 'True'}),
            'first_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'groups': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Group']", 'symmetrical': 'False', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'is_active': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'is_staff': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_superuser': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'last_login': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'last_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'password': ('django.db.models.fields.CharField', [], {'max_length': '128'}),
            'user_permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'}),
            'username': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '30'})
        },
        'contenttypes.contenttype': {
            'Meta': {'ordering': "('name',)", 'unique_together': "(('app_label', 'model'),)", 'object_name': 'ContentType', 'db_table': "'django_content_type'"},
            'app_label': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'model': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'})
        },
        'diocese.arciprestado': {
            'Meta': {'ordering': "['arciprestado']", 'object_name': 'Arciprestado'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_arciprestado_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'arcipreste': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'arcipreste_adjunto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_arciprestado_criado_por'", 'to': "orm['auth.User']"}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_arciprestado_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'logo': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'presbitero_arcipreste': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_arciprestado_presbitero_arcipreste'", 'null': 'True', 'to': "orm['diocese.Presbitero']"}),
            'presbitero_arcipreste_adjunto': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_arciprestado_presbitero_arcipreste_adjunto'", 'null': 'True', 'to': "orm['diocese.Presbitero']"})
        },
        'diocese.associacaomovimentoobra': {
            'Meta': {'ordering': "['nome']", 'object_name': 'AssociacaoMovimentoObra'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_associacaomovimentoobra_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'dioceses_associacaomovimentoobras_arciprestado'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['diocese.Arciprestado']"}),
            'assistente': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_associacaomovimentoobra_criado_por'", 'to': "orm['auth.User']"}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_associacaomovimentoobra_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'presidente': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.associacaoobrapresbitero': {
            'Meta': {'ordering': "['nome']", 'object_name': 'AssociacaoObraPresbitero'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_associacaoobrapresbitero_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'dioceses_associacaoobrapersbiteros_arciprestado'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['diocese.Arciprestado']"}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_associacaoobrapresbitero_criado_por'", 'to': "orm['auth.User']"}),
            'director': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_associacaoobrapresbitero_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'membros_eleitos': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'obs': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.bispo': {
            'Meta': {'ordering': "['nome']", 'object_name': 'Bispo'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_bispo_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'dioceses_bispos_arciprestado'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['diocese.Arciprestado']"}),
            'bispo_tipo': ('django.db.models.fields.PositiveIntegerField', [], {'default': '1', 'max_length': '1'}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_bispo_criado_por'", 'to': "orm['auth.User']"}),
            'curriculo': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'data_faleceu': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'data_nascimento': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'data_nomeacao': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'data_orden_episc': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'data_orden_presbiteral': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'data_resignacao': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'data_tomada': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'faleceu': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fraternidade_sacerdotal': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_bispo_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'habilitacoes_academicas': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'local_nascimento': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'local_ordenacao_presb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'local_ordenacoa_episc': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'nomeacoes': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'observacoes': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel_privado': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.cabido': {
            'Meta': {'ordering': "['nome']", 'object_name': 'Cabido'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_cabido_alterado_por'", 'to': "orm['auth.User']"}),
            'arcediago': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'arcipreste': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'arquivo_capitular': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'beneficiados': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'capitulares': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'chantre': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_cabido_criado_por'", 'to': "orm['auth.User']"}),
            'deao': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'dignidades': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_cabido_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'honorarios': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'jubilados': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'mestre_escola': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'penitenciario': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'presidente': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'secretario': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'tesoureiro': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'vice_presidente': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.centroanimacaoespiritual': {
            'Meta': {'ordering': "['nome']", 'object_name': 'CentroAnimacaoEspiritual'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_centroanimacaoespiritual_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'dioceses_centroanimacaoespirituals_arciprestado'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['diocese.Arciprestado']"}),
            'assistente': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_centroanimacaoespiritual_criado_por'", 'to': "orm['auth.User']"}),
            'director': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_centroanimacaoespiritual_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'obs': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'propiedade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.centrovidacrista': {
            'Meta': {'ordering': "['nome']", 'object_name': 'CentroVidaCrista'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_centrovidacrista_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'dioceses_centrovidacristas_arciprestado'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['diocese.Arciprestado']"}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_centrovidacrista_criado_por'", 'to': "orm['auth.User']"}),
            'director': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_centrovidacrista_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'obs': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'propriedade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'tipo': ('django.db.models.fields.PositiveIntegerField', [], {'default': '1', 'max_length': '1'})
        },
        'diocese.chancelaria': {
            'Meta': {'ordering': "['nome']", 'object_name': 'Chancelaria'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_chancelaria_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'dioceses_chancelarias_arciprestado'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['diocese.Arciprestado']"}),
            'arquivo_historico': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'arquivo_secreto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'associacoes_religiosas': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'chanceler': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'consultor_juridico': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_chancelaria_criado_por'", 'to': "orm['auth.User']"}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_chancelaria_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'notario': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'secretariado_deral': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'servico_del_pios': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'vice_chanceler': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.colegioarciprestes': {
            'Meta': {'ordering': "['nome']", 'object_name': 'ColegioArciprestes'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_colegioarciprestes_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'dioceses_colegioarciprestess_arciprestado'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['diocese.Arciprestado']"}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'colegio_arciprestes': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_colegioarciprestes_criado_por'", 'to': "orm['auth.User']"}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_colegioarciprestes_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.colegioconsultores': {
            'Meta': {'ordering': "['nome']", 'object_name': 'ColegioConsultores'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_colegioconsultores_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'dioceses_colegioconsultoress_arciprestado'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['diocese.Arciprestado']"}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'colegio_consultores': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_colegioconsultores_criado_por'", 'to': "orm['auth.User']"}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_colegioconsultores_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.comissao': {
            'Meta': {'ordering': "['nome']", 'object_name': 'Comissao'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_comissao_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'dioceses_comissaos_arciprestado'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['diocese.Arciprestado']"}),
            'assistente': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_comissao_criado_por'", 'to': "orm['auth.User']"}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_comissao_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'membros': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'presidente': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'sector_departamento': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.comunicacaosocial': {
            'Meta': {'ordering': "['nome']", 'object_name': 'ComunicacaoSocial'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_comunicacaosocial_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'dioceses_comicacaosocials_arciprestado'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['diocese.Arciprestado']"}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_comunicacaosocial_criado_por'", 'to': "orm['auth.User']"}),
            'director': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_comunicacaosocial_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'obs': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'periocidade': ('django.db.models.fields.PositiveIntegerField', [], {'max_length': '1', 'null': 'True', 'blank': 'True'}),
            'propriedade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'tipo': ('django.db.models.fields.PositiveIntegerField', [], {'max_length': '1', 'null': 'True', 'blank': 'True'})
        },
        'diocese.conselhopastoral': {
            'Meta': {'ordering': "['nome']", 'object_name': 'ConselhoPastoral'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_conselhopastoral_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'dioceses_conselhopastorals_arciprestado'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['diocese.Arciprestado']"}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'comissao_permanente': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_conselhopastoral_criado_por'", 'to': "orm['auth.User']"}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_conselhopastoral_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'mandato': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'membros_designados': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'membros_eleitos': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'membros_natos': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.conselhopresbiteral': {
            'Meta': {'ordering': "['nome']", 'object_name': 'ConselhoPresbiteral'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_conselhopresbiteral_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'dioceses_conselhopresbiterals_arciprestado'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['diocese.Arciprestado']"}),
            'associados_presidencia': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'conselho_permanente': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_conselhopresbiteral_criado_por'", 'to': "orm['auth.User']"}),
            'designados_bispo': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_conselhopresbiteral_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'membros_natos': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'por_eleicao': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.curiadiocesana': {
            'Meta': {'ordering': "['nome']", 'object_name': 'CuriaDiocesana'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'administradorcasaarquiepiscopal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_curiadiocesana_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'dioceses_curiadiocesanas_arciprestado'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['diocese.Arciprestado']"}),
            'arquivo_historico': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'arquivo_secreto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'associacoes_religiosas': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'chanceler': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'chefe_gabinete': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'conselho_episcopal': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'consultor_juridico': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_curiadiocesana_criado_por'", 'to': "orm['auth.User']"}),
            'delegados_episcopais': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'director': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'direvigarios_episcopais': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'feriados': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_curiadiocesana_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'gabinete_informacao': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'horarios': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'moderador': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'notario': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'provigario_geral': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'secretaria_episcopal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'secretariado_geral': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'secretario_particular': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'servico_legados_pios': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'vigarios_gerais': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'vigarios_gerais_ad': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'})
        },
        'diocese.dadosestatisticos': {
            'Meta': {'ordering': "['ano']", 'object_name': 'DadosEstatisticos'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_dadosestatisticos_alterado_por'", 'to': "orm['auth.User']"}),
            'ano': ('django.db.models.fields.IntegerField', [], {'unique': 'True'}),
            'arciprestados': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'candidatossacerdocio': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'capelanias': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'casambulatorios': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'cascasasdeidosos': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'cascentrosespeciais': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'cascentrossociais': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'casconfrarias': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'casconsultoriosfamiliares': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'cascreches': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'cashospitais': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'casmisericordias': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'casorfanatos': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'catolicos': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'cficlerodiocesano': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'cficleroreligioso': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'cieescolasmaternoinfantis': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'cieescolasprimarias': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'cieescolassecundarias': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'cieinstitutossuperiores': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'cieuniversidadecatolica': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_dadosestatisticos_criado_por'", 'to': "orm['auth.User']"}),
            'cscelrodiocesano': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'cscleroreligioso': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'del1': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'del2': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'diaconospermanentes': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'ecsboletinsparoquiais': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'ecseditorascatolicas': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'ecsjornaisdiarios': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'ecsjornaismensarios': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'ecsjornaisquinzenarios': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'ecsjornaissemanarios': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'ecslivrarias': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'ecsradioslocais': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'ecsradiosregionais': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'foraservicopastoral': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_dadosestatisticos_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'obs': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'paroquias': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'pclerodiocesano': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'pcleroreligioso': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'pdiaconosper': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'pleigos': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'populacao': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'poutrosacerdote': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'preligiosas': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'religiosasprofessasrd': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'religiososprofessosnsacerdotes': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'sacerdotesdiocesanos': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'spdiocesepropria': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'spnoutradiocese': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'srrdiocese': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'srrforaservicopastoral': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'srrservicoinstituto': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'srrtotalpartesdiocese': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'superficie': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'totalmentevacantes': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'vsapos7anos': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'vsate1ano': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'vsbaptizados': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'vsconfirmacoes': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'vsde1a7anos': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'vsmatrimonioscanonicos': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'vsmcentrecatolicoencatolico': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'vsmcentrecatolicos': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'vsprimeirascomunhoes': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'})
        },
        'diocese.diaconadopermanente': {
            'Meta': {'ordering': "['nome']", 'object_name': 'DiaconadoPermanente'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_diaconadopermanente_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'dioceses_diaconadopermanentes_arciprestado'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['diocese.Arciprestado']"}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_diaconadopermanente_criado_por'", 'to': "orm['auth.User']"}),
            'delegado': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_diaconadopermanente_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'seleccao_formacao': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.diacono': {
            'Meta': {'object_name': 'Diacono'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_diacono_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'dioceses_diaconos_arciprestado'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['diocese.Arciprestado']"}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_diacono_criado_por'", 'to': "orm['auth.User']"}),
            'data_faleceu': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'data_nascimento': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'data_ordenacoa': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'faleceu': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_diacono_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'local_nascimento': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'local_ordenacao': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'nomeacoes': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'nomeacoes_actuais': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'obs': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel_privado': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.diaconoparoquias': {
            'Meta': {'unique_together': "(('diacono', 'paroquia'),)", 'object_name': 'DiaconoParoquias'},
            'diacono': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'dioceses_diaconoparoquiass_diaconoparoquias_diacono'", 'to': "orm['diocese.Diacono']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'paroquia': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'dioceses_diaconoparoquiass_diaconoparoquias_paroquia'", 'to': "orm['diocese.Paroquia']"})
        },
        'diocese.diaconopermanente': {
            'Meta': {'ordering': "['nome']", 'object_name': 'DiaconoPermanente'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_diaconopermanente_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'dioceses_diaconopermanentes_arciprestado'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['diocese.Arciprestado']"}),
            'cartao_sacerdotal': ('django.db.models.fields.IntegerField', [], {'max_length': '2', 'null': 'True', 'blank': 'True'}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_diaconopermanente_criado_por'", 'to': "orm['auth.User']"}),
            'data_faleceu': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'data_nascimento': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'data_ordenacoa': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'delegado_coordenador': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'faleceu': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_diaconopermanente_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'local_nascimento': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'local_ordenacao': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'nomeacoes': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'obs': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'serv_pastoral': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel_privado': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.diaconopermanenteretiros': {
            'Meta': {'unique_together': "(('diaconopermanente', 'ano'),)", 'object_name': 'DiaconoPermanenteRetiros'},
            'ano': ('django.db.models.fields.IntegerField', [], {'max_length': '4', 'null': 'True', 'blank': 'True'}),
            'diaconopermanente': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_diaconopermanenteretiros_diaconopermanenteretiros'", 'to': "orm['diocese.DiaconoPermanente']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'observacoes': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.diaconoretiros': {
            'Meta': {'unique_together': "(('diacono', 'ano'),)", 'object_name': 'DiaconoRetiros'},
            'ano': ('django.db.models.fields.IntegerField', [], {'max_length': '4', 'null': 'True', 'blank': 'True'}),
            'diacono': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'dioceses_diaconoretiross_diaconoretiros_diacono'", 'to': "orm['diocese.Diacono']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'observacoes': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.ecclesia': {
            'Meta': {'object_name': 'Ecclesia'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_ecclesia_alterado_por'", 'to': "orm['auth.User']"}),
            'codigo': ('django.db.models.fields.IntegerField', [], {}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_ecclesia_criado_por'", 'to': "orm['auth.User']"}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_ecclesia_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'tabela': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'tipo': ('django.db.models.fields.CharField', [], {'max_length': '1'})
        },
        'diocese.escolacatolica': {
            'Meta': {'ordering': "['nome']", 'object_name': 'EscolaCatolica'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_escolacatolica_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'dioceses_escolacatolicas_arciprestado'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['diocese.Arciprestado']"}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_escolacatolica_criado_por'", 'to': "orm['auth.User']"}),
            'director': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'escolaridade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_escolacatolica_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'propriedade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.formacaoagentepastoral': {
            'Meta': {'ordering': "['nome']", 'object_name': 'FormacaoAgentePastoral'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_formacaoagentepastoral_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'dioceses_formacaoagentepastorals_arciprestado'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['diocese.Arciprestado']"}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_formacaoagentepastoral_criado_por'", 'to': "orm['auth.User']"}),
            'director': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_formacaoagentepastoral_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'obs': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'propriedade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.gestaorecursos': {
            'Meta': {'ordering': "['nome']", 'object_name': 'GestaoRecursos'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_gestaorecursos_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'dioceses_gestaorecursos_arciprestado'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['diocese.Arciprestado']"}),
            'assuntos_economicos': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_gestaorecursos_criado_por'", 'to': "orm['auth.User']"}),
            'economo': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_gestaorecursos_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'membros_eleitos': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'membros_natos': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'tesouraria': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.instituicaocultural': {
            'Meta': {'ordering': "['nome']", 'object_name': 'InstituicaoCultural'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_instituicaocultural_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'dioceses_institutoculturals_arciprestado'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['diocese.Arciprestado']"}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_instituicaocultural_criado_por'", 'to': "orm['auth.User']"}),
            'director': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_instituicaocultural_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'obs': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'propriedade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.institutoreligiosofeminino': {
            'Meta': {'ordering': "['nome']", 'object_name': 'InstitutoReligiosoFeminino'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_institutoreligiosofeminino_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'dioceses_institutoreligiosofemininos_arciprestado'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['diocese.Arciprestado']"}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'comunidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'congregacao_id': ('django.db.models.fields.PositiveIntegerField', [], {'max_length': '3', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_institutoreligiosofeminino_criado_por'", 'to': "orm['auth.User']"}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_institutoreligiosofeminino_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'membros': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'superiora': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.institutoreligiosomasculino': {
            'Meta': {'ordering': "['nome']", 'object_name': 'InstitutoReligiosoMasculino'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_institutoreligiosomasculino_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'dioceses_institutoreligiosomasculinos_arciprestado'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['diocese.Arciprestado']"}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'comunidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'congregacao_id': ('django.db.models.fields.PositiveIntegerField', [], {'max_length': '2', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_institutoreligiosomasculino_criado_por'", 'to': "orm['auth.User']"}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_institutoreligiosomasculino_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'membros': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'superior': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.institutosecular': {
            'Meta': {'ordering': "['nome']", 'object_name': 'InstitutoSecular'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_institutosecular_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'dioceses_institutoseculars_arciprestado'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['diocese.Arciprestado']"}),
            'assistente': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'comunidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_institutosecular_criado_por'", 'to': "orm['auth.User']"}),
            'director': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_institutosecular_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'instituto_secular_n_id': ('django.db.models.fields.PositiveIntegerField', [], {'max_length': '2', 'null': 'True', 'blank': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'obs': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.notahistorica': {
            'Meta': {'ordering': "['nome']", 'object_name': 'NotaHistorica'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_notahistorica_alterado_por'", 'to': "orm['auth.User']"}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_notahistorica_criado_por'", 'to': "orm['auth.User']"}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_notahistorica_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'nota_historica': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'sufraganea': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.obraaccaosociocaritativa': {
            'Meta': {'ordering': "['nome']", 'object_name': 'ObraAccaoSocioCaritativa'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_obraaccaosociocaritativa_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'dioceses_obraaccaosociocaritativas_arciprestado'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['diocese.Arciprestado']"}),
            'assistente': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_obraaccaosociocaritativa_criado_por'", 'to': "orm['auth.User']"}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_obraaccaosociocaritativa_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'multipo_id': ('django.db.models.fields.related.ManyToManyField', [], {'symmetrical': 'False', 'to': "orm['diocese.Valencias']", 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'obs': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'propriedade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'responsavel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'tipo': ('django.db.models.fields.PositiveIntegerField', [], {'default': '15', 'max_length': '2'})
        },
        'diocese.outrainstituicao': {
            'Meta': {'object_name': 'OutraInstituicao'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_outrainstituicao_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'dioceses_outrainstituicaos_arciprestado'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['diocese.Arciprestado']"}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_outrainstituicao_criado_por'", 'to': "orm['auth.User']"}),
            'director': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_outrainstituicao_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.paroquia': {
            'Meta': {'ordering': "['nome']", 'object_name': 'Paroquia'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_paroquia_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_paroquia_paroquia_arciprestado'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['diocese.Arciprestado']"}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_paroquia_criado_por'", 'to': "orm['auth.User']"}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_paroquia_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'horario_confissoes': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'horario_missas': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'orago': ('django.db.models.fields.PositiveIntegerField', [], {'max_length': '3', 'null': 'True', 'blank': 'True'}),
            'padre1': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_paroquia_paroquia_padre1'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['diocese.Presbitero']"}),
            'padre2': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_paroquia_paroquia_padre2'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['diocese.Presbitero']"}),
            'padre3': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_paroquia_paroquia_padre3'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['diocese.Presbitero']"}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.prelaturapessoal': {
            'Meta': {'ordering': "['nome']", 'object_name': 'PrelaturaPessoal'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_prelaturapessoal_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'dioceses_prelaturapessoals_arciprestado'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['diocese.Arciprestado']"}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'comunidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'congregacao_id': ('django.db.models.fields.PositiveIntegerField', [], {'max_length': '3', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_prelaturapessoal_criado_por'", 'to': "orm['auth.User']"}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_prelaturapessoal_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'membros': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'superiora': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.presbitero': {
            'Meta': {'ordering': "['nome']", 'object_name': 'Presbitero'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_presbitero_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'dioceses_presbiteros_arciprestado'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['diocese.Arciprestado']"}),
            'arcipreste': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'capelao': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'cartao_sacerdotal': ('django.db.models.fields.IntegerField', [], {'max_length': '2', 'null': 'True', 'blank': 'True'}),
            'clero_tipo': ('django.db.models.fields.PositiveIntegerField', [], {'default': '1', 'max_length': '1'}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_presbitero_criado_por'", 'to': "orm['auth.User']"}),
            'data_faleceu': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'data_nascimento': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'data_ordenacoa': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'faleceu': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'formacao_permanente': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fraternidade_sacerdotal': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_presbitero_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'habilitacoes_academicas': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'igreja': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'local_nascimento': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'local_ordenacao': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'nomeacoes': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'nomeacoes_actuais': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'obs': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'paroco': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'publicacoes': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'reitor': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'serv_pastoral': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel_privado': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'tipo_clero': ('django.db.models.fields.PositiveIntegerField', [], {'max_length': '1', 'null': 'True', 'blank': 'True'}),
            'vice_arcipreste': ('django.db.models.fields.BooleanField', [], {'default': 'False'})
        },
        'diocese.presbiteroretiros': {
            'Meta': {'unique_together': "(('presbitero', 'ano'),)", 'object_name': 'PresbiteroRetiros'},
            'ano': ('django.db.models.fields.IntegerField', [], {'max_length': '4', 'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'observacoes': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'presbitero': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_presbiteroretiros_presbiteroretiros'", 'to': "orm['diocese.Presbitero']"})
        },
        'diocese.secretariado': {
            'Meta': {'ordering': "['nome']", 'object_name': 'Secretariado'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_secretariado_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'dioceses_secretariados_arciprestado'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['diocese.Arciprestado']"}),
            'assistente': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'coordenador': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_secretariado_criado_por'", 'to': "orm['auth.User']"}),
            'director': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_secretariado_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'sector_departamento': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.seminario': {
            'Meta': {'ordering': "['nome']", 'object_name': 'Seminario'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_seminario_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'dioceses_seminarios_arciprestado'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['diocese.Arciprestado']"}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'confessor': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_seminario_criado_por'", 'to': "orm['auth.User']"}),
            'director_espiritual': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'economo': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'equipa_resp': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_seminario_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'obs': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'prefeito': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'reitor': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'secretario': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'tesoureiro': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'vice_reitor': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.sociedadevidaapostolica': {
            'Meta': {'ordering': "['nome']", 'object_name': 'SociedadeVidaApostolica'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_sociedadevidaapostolica_alterado_por'", 'to': "orm['auth.User']"}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_sociedadevidaapostolica_criado_por'", 'to': "orm['auth.User']"}),
            'director': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_sociedadevidaapostolica_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.tribunaleclesiastico': {
            'Meta': {'ordering': "['nome']", 'object_name': 'TribunalEclesiastico'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'advogados_oficio': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_tribunaleclesiastico_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'dioceses_tribunaleclesiasticos_arciprestado'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['diocese.Arciprestado']"}),
            'auditores': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_tribunaleclesiastico_criado_por'", 'to': "orm['auth.User']"}),
            'defensor_vinculo': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_tribunaleclesiastico_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'juizes_diocesanos': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'meirinho': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'notario_actuario': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'obs': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'promotor_justica': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'vigario_judicial': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'vigariojudicialad': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.valencias': {
            'Meta': {'object_name': 'Valencias'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_valencias_alterado_por'", 'to': "orm['auth.User']"}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_valencias_criado_por'", 'to': "orm['auth.User']"}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_valencias_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'})
        },
        'elfinder.filecollection': {
            'Meta': {'object_name': 'FileCollection'},
            'dir': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'url': ('django.db.models.fields.CharField', [], {'max_length': '255'})
        }
    }

    complete_apps = ['diocese']