# -*- coding: utf-8 -*-
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):
        # Adding model 'Ecclesia'
        db.create_table('diocese_ecclesia', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_ecclesia_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_ecclesia_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_ecclesia_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('codigo_ecclesia', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('tabela', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('tipo', self.gf('django.db.models.fields.CharField')(max_length=1)),
            ('codigo', self.gf('django.db.models.fields.IntegerField')()),
        ))
        db.send_create_signal('diocese', ['Ecclesia'])

        # Adding model 'Presbitero'
        db.create_table('diocese_presbitero', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_presbitero_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_presbitero_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_presbitero_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('codigo_ecclesia', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('nome', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('clero_tipo', self.gf('django.db.models.fields.PositiveIntegerField')(default=1, max_length=1)),
            ('data_nascimento', self.gf('django.db.models.fields.DateField')(null=True, blank=True)),
            ('data_ordenacoa', self.gf('django.db.models.fields.DateField')(null=True, blank=True)),
            ('morada', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('codigo_postal', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('localidade', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telefone', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telemovel', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('fax', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('email', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('paginaweb', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('serv_pastoral', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('obs', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('foto', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telemovel_privado', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('tipo_clero', self.gf('django.db.models.fields.PositiveIntegerField')(max_length=1, null=True, blank=True)),
            ('igreja', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('arcipreste', self.gf('django.db.models.fields.BooleanField')(default=False)),
            ('vice_arcipreste', self.gf('django.db.models.fields.BooleanField')(default=False)),
            ('paroco', self.gf('django.db.models.fields.BooleanField')(default=False)),
            ('capelao', self.gf('django.db.models.fields.BooleanField')(default=False)),
            ('reitor', self.gf('django.db.models.fields.BooleanField')(default=False)),
            ('habilitacoes_academicas', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('publicacoes', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('formacao_permanente', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('fraternidade_sacerdotal', self.gf('django.db.models.fields.BooleanField')(default=False)),
            ('cartao_sacerdotal', self.gf('django.db.models.fields.IntegerField')(max_length=2, null=True, blank=True)),
            ('nomeacoes', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('local_nascimento', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('local_ordenacao', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('faleceu', self.gf('django.db.models.fields.BooleanField')(default=False)),
            ('data_faleceu', self.gf('django.db.models.fields.DateField')(null=True, blank=True)),
            ('nomeacoes_actuais', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
        ))
        db.send_create_signal('diocese', ['Presbitero'])

        # Adding model 'PresbiteroRetiros'
        db.create_table('diocese_presbiteroretiros', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('presbitero', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_presbiteroretiros_presbiteroretiros', to=orm['diocese.Presbitero'])),
            ('ano', self.gf('django.db.models.fields.IntegerField')(max_length=4, null=True, blank=True)),
            ('observacoes', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
        ))
        db.send_create_signal('diocese', ['PresbiteroRetiros'])

        # Adding unique constraint on 'PresbiteroRetiros', fields ['presbitero', 'ano']
        db.create_unique('diocese_presbiteroretiros', ['presbitero_id', 'ano'])

        # Adding model 'DiaconoPermanente'
        db.create_table('diocese_diaconopermanente', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_diaconopermanente_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_diaconopermanente_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_diaconopermanente_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('codigo_ecclesia', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('nome', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('data_nascimento', self.gf('django.db.models.fields.DateField')(null=True, blank=True)),
            ('data_ordenacoa', self.gf('django.db.models.fields.DateField')(null=True, blank=True)),
            ('morada', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('codigo_postal', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('localidade', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telefone', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telemovel', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('fax', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('email', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('paginaweb', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('serv_pastoral', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('obs', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('foto', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telemovel_privado', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('cartao_sacerdotal', self.gf('django.db.models.fields.IntegerField')(max_length=2, null=True, blank=True)),
            ('nomeacoes', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('local_ordenacao', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('faleceu', self.gf('django.db.models.fields.BooleanField')(default=False)),
            ('data_faleceu', self.gf('django.db.models.fields.DateField')(null=True, blank=True)),
            ('delegado_coordenador', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('local_nascimento', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
        ))
        db.send_create_signal('diocese', ['DiaconoPermanente'])

        # Adding model 'DiaconoPermanenteRetiros'
        db.create_table('diocese_diaconopermanenteretiros', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('diaconopermanente', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_diaconopermanenteretiros_diaconopermanenteretiros', to=orm['diocese.DiaconoPermanente'])),
            ('ano', self.gf('django.db.models.fields.IntegerField')(max_length=4, null=True, blank=True)),
            ('observacoes', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
        ))
        db.send_create_signal('diocese', ['DiaconoPermanenteRetiros'])

        # Adding unique constraint on 'DiaconoPermanenteRetiros', fields ['diaconopermanente', 'ano']
        db.create_unique('diocese_diaconopermanenteretiros', ['diaconopermanente_id', 'ano'])

        # Adding model 'Arciprestado'
        db.create_table('diocese_arciprestado', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_arciprestado_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_arciprestado_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_arciprestado_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('codigo_ecclesia', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('arciprestado', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('arcipreste', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('arcipreste_adjunto', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('presbitero_arcipreste', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_arciprestado_presbitero_arcipreste', null=True, to=orm['diocese.Presbitero'])),
            ('presbitero_arcipreste_adjunto', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_arciprestado_presbitero_arcipreste_adjunto', null=True, to=orm['diocese.Presbitero'])),
            ('logo', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
        ))
        db.send_create_signal('diocese', ['Arciprestado'])

        # Adding model 'NotaHistorica'
        db.create_table('diocese_notahistorica', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_notahistorica_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_notahistorica_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_notahistorica_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('codigo_ecclesia', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('nome', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('sufraganea', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('nota_historica', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
        ))
        db.send_create_signal('diocese', ['NotaHistorica'])

        # Adding model 'Bispo'
        db.create_table('diocese_bispo', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_bispo_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_bispo_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_bispo_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('codigo_ecclesia', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('nome', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('bispo_tipo', self.gf('django.db.models.fields.PositiveIntegerField')(default=1, max_length=1)),
            ('data_nascimento', self.gf('django.db.models.fields.DateField')(null=True, blank=True)),
            ('local_nascimento', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('data_orden_presbiteral', self.gf('django.db.models.fields.DateField')(null=True, blank=True)),
            ('local_ordenacao_presb', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('data_orden_episc', self.gf('django.db.models.fields.DateField')(null=True, blank=True)),
            ('local_ordenacoa_episc', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('curriculo', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('data_nomeacao', self.gf('django.db.models.fields.DateField')(null=True, blank=True)),
            ('data_tomada', self.gf('django.db.models.fields.DateField')(null=True, blank=True)),
            ('data_resignacao', self.gf('django.db.models.fields.DateField')(null=True, blank=True)),
            ('morada', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('codigo_postal', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('localidade', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telefone', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telemovel', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('fax', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('email', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('paginaweb', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('observacoes', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('foto', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telemovel_privado', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('faleceu', self.gf('django.db.models.fields.BooleanField')(default=False)),
            ('data_faleceu', self.gf('django.db.models.fields.DateField')(null=True, blank=True)),
            ('fraternidade_sacerdotal', self.gf('django.db.models.fields.BooleanField')(default=False)),
            ('habilitacoes_academicas', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('nomeacoes', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
        ))
        db.send_create_signal('diocese', ['Bispo'])

        # Adding model 'CuriaDiocesana'
        db.create_table('diocese_curiadiocesana', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_curiadiocesana_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_curiadiocesana_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_curiadiocesana_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('codigo_ecclesia', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('nome', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('morada', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('codigo_postal', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('localidade', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telefone', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telemovel', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('fax', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('email', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('paginaweb', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('horarios', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('conselho_episcopal', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('moderador', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('vigarios_gerais', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('vigarios_gerais_ad', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('provigario_geral', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('direvigarios_episcopais', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('delegados_episcopais', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('secretaria_episcopal', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('chefe_gabinete', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('secretario_particular', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('gabinete_informacao', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('arciprestado', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_curiadiocesana_arciprestado', null=True, to=orm['diocese.Arciprestado'])),
            ('director', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('chanceler', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('secretariado_geral', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('consultor_juridico', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('servico_legados_pios', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('associacoes_religiosas', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('arquivo_secreto', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('arquivo_historico', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('notario', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('feriados', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('administradorcasaarquiepiscopal', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('foto', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
        ))
        db.send_create_signal('diocese', ['CuriaDiocesana'])

        # Adding model 'Chancelaria'
        db.create_table('diocese_chancelaria', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_chancelaria_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_chancelaria_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_chancelaria_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('codigo_ecclesia', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('nome', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('morada', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('codigo_postal', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('localidade', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telefone', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telemovel', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('fax', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('email', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('paginaweb', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('chanceler', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('vice_chanceler', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('secretariado_deral', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('consultor_juridico', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('notario', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('servico_del_pios', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('associacoes_religiosas', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('arquivo_secreto', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('arquivo_historico', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('arciprestado', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_chancelaria_arciprestado', null=True, to=orm['diocese.Arciprestado'])),
            ('foto', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
        ))
        db.send_create_signal('diocese', ['Chancelaria'])

        # Adding model 'GestaoRecursos'
        db.create_table('diocese_gestaorecursos', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_gestaorecursos_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_gestaorecursos_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_gestaorecursos_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('codigo_ecclesia', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('nome', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('morada', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('codigo_postal', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('localidade', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telefone', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telemovel', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('fax', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('email', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('paginaweb', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('assuntos_economicos', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('economo', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('tesouraria', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('arciprestado', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_gestaorecursos_arciprestado', null=True, to=orm['diocese.Arciprestado'])),
            ('membros_natos', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('membros_eleitos', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('foto', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
        ))
        db.send_create_signal('diocese', ['GestaoRecursos'])

        # Adding model 'ConselhoPresbiteral'
        db.create_table('diocese_conselhopresbiteral', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_conselhopresbiteral_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_conselhopresbiteral_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_conselhopresbiteral_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('codigo_ecclesia', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('nome', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('membros_natos', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('associados_presidencia', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('por_eleicao', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('designados_bispo', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('conselho_permanente', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('arciprestado', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_conselhopresbiteral_arciprestado', null=True, to=orm['diocese.Arciprestado'])),
            ('morada', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('codigo_postal', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('localidade', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telefone', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('fax', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('email', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('paginaweb', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('foto', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
        ))
        db.send_create_signal('diocese', ['ConselhoPresbiteral'])

        # Adding model 'ColegioConsultores'
        db.create_table('diocese_colegioconsultores', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_colegioconsultores_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_colegioconsultores_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_colegioconsultores_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('codigo_ecclesia', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('nome', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('colegio_consultores', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('arciprestado', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_colegioconsultores_arciprestado', null=True, to=orm['diocese.Arciprestado'])),
            ('morada', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('codigo_postal', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('localidade', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telefone', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('fax', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('email', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('paginaweb', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('foto', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
        ))
        db.send_create_signal('diocese', ['ColegioConsultores'])

        # Adding model 'Cabido'
        db.create_table('diocese_cabido', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_cabido_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_cabido_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_cabido_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('codigo_ecclesia', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('nome', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('presidente', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('vice_presidente', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('secretario', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('dignidades', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('deao', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('chantre', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('mestre_escola', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('arcediago', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('tesoureiro', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('penitenciario', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('capitulares', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('honorarios', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('jubilados', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('beneficiados', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('arquivo_capitular', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('morada', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telefone', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('email', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('arcipreste', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('fax', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
        ))
        db.send_create_signal('diocese', ['Cabido'])

        # Adding model 'ConselhoPastoral'
        db.create_table('diocese_conselhopastoral', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_conselhopastoral_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_conselhopastoral_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_conselhopastoral_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('codigo_ecclesia', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('nome', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('mandato', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('membros_natos', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('membros_designados', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('membros_eleitos', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('comissao_permanente', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('arciprestado', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_conselhopastoral_arciprestado', null=True, to=orm['diocese.Arciprestado'])),
            ('morada', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('codigo_postal', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('localidade', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telefone', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('fax', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('email', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('paginaweb', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('foto', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
        ))
        db.send_create_signal('diocese', ['ConselhoPastoral'])

        # Adding model 'ColegioArciprestes'
        db.create_table('diocese_colegioarciprestes', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_colegioarciprestes_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_colegioarciprestes_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_colegioarciprestes_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('codigo_ecclesia', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('nome', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('colegio_arciprestes', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('arciprestado', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_colegioarciprestes_arciprestado', null=True, to=orm['diocese.Arciprestado'])),
            ('morada', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('codigo_postal', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('localidade', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telefone', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('fax', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('email', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('paginaweb', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('foto', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
        ))
        db.send_create_signal('diocese', ['ColegioArciprestes'])

        # Adding model 'Secretariado'
        db.create_table('diocese_secretariado', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_secretariado_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_secretariado_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_secretariado_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('codigo_ecclesia', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('nome', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('morada', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('codigo_postal', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('localidade', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telefone', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telemovel', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('fax', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('email', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('paginaweb', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('director', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('coordenador', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('assistente', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('sector_departamento', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('arciprestado', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_secretariado_arciprestado', null=True, to=orm['diocese.Arciprestado'])),
            ('foto', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
        ))
        db.send_create_signal('diocese', ['Secretariado'])

        # Adding model 'Comissao'
        db.create_table('diocese_comissao', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_comissao_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_comissao_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_comissao_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('codigo_ecclesia', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('nome', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('morada', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('codigo_postal', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('localidade', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telefone', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telemovel', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('fax', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('email', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('paginaweb', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('presidente', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('assistente', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('membros', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('sector_departamento', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('arciprestado', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_comissao_arciprestado', null=True, to=orm['diocese.Arciprestado'])),
            ('foto', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
        ))
        db.send_create_signal('diocese', ['Comissao'])

        # Adding model 'TribunalEclesiastico'
        db.create_table('diocese_tribunaleclesiastico', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_tribunaleclesiastico_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_tribunaleclesiastico_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_tribunaleclesiastico_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('codigo_ecclesia', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('nome', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('morada', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('codigo_postal', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('localidade', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telefone', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telemovel', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('fax', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('email', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('paginaweb', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('vigario_judicial', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('vigariojudicialad', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('juizes_diocesanos', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('auditores', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('promotor_justica', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('defensor_vinculo', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('notario_actuario', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('advogados_oficio', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('meirinho', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('obs', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('arciprestado', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_tribunaleclesiastico_arciprestado', null=True, to=orm['diocese.Arciprestado'])),
            ('foto', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
        ))
        db.send_create_signal('diocese', ['TribunalEclesiastico'])

        # Adding model 'Seminario'
        db.create_table('diocese_seminario', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_seminario_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_seminario_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_seminario_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('codigo_ecclesia', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('nome', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('morada', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('codigo_postal', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('localidade', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telefone', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telemovel', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('fax', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('email', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('paginaweb', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('reitor', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('vice_reitor', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('prefeito', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('secretario', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('confessor', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('director_espiritual', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('tesoureiro', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('economo', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('equipa_resp', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('obs', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('arciprestado', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_seminario_arciprestado', null=True, to=orm['diocese.Arciprestado'])),
            ('foto', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
        ))
        db.send_create_signal('diocese', ['Seminario'])

        # Adding model 'DiaconadoPermanente'
        db.create_table('diocese_diaconadopermanente', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_diaconadopermanente_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_diaconadopermanente_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_diaconadopermanente_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('codigo_ecclesia', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('nome', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('morada', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('codigo_postal', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('localidade', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telefone', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telemovel', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('fax', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('email', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('paginaweb', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('seleccao_formacao', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('delegado', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('arciprestado', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_diaconadopermanente_arciprestado', null=True, to=orm['diocese.Arciprestado'])),
            ('foto', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
        ))
        db.send_create_signal('diocese', ['DiaconadoPermanente'])

        # Adding model 'FormacaoAgentePastoral'
        db.create_table('diocese_formacaoagentepastoral', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_formacaoagentepastoral_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_formacaoagentepastoral_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_formacaoagentepastoral_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('codigo_ecclesia', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('nome', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('director', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('propriedade', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('morada', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('codigo_postal', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('localidade', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telefone', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telemovel', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('fax', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('email', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('paginaweb', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('obs', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('arciprestado', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_formacaoagentepastoral_arciprestado', null=True, to=orm['diocese.Arciprestado'])),
            ('foto', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
        ))
        db.send_create_signal('diocese', ['FormacaoAgentePastoral'])

        # Adding model 'CentroVidaCrista'
        db.create_table('diocese_centrovidacrista', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_centrovidacrista_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_centrovidacrista_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_centrovidacrista_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('codigo_ecclesia', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('nome', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('tipo', self.gf('django.db.models.fields.PositiveIntegerField')(default=1, max_length=1)),
            ('director', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('propriedade', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('morada', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('codigo_postal', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('localidade', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telefone', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telemovel', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('fax', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('email', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('paginaweb', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('obs', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('arciprestado', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_centrovidacrista_arciprestado', null=True, to=orm['diocese.Arciprestado'])),
            ('foto', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
        ))
        db.send_create_signal('diocese', ['CentroVidaCrista'])

        # Adding model 'AssociacaoObraPresbitero'
        db.create_table('diocese_associacaoobrapresbitero', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_associacaoobrapresbitero_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_associacaoobrapresbitero_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_associacaoobrapresbitero_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('codigo_ecclesia', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('nome', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('director', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('morada', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('codigo_postal', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('localidade', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telefone', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telemovel', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('fax', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('email', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('paginaweb', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('obs', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('arciprestado', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_associacaoobrapresbitero_arciprestado', null=True, to=orm['diocese.Arciprestado'])),
            ('membros_eleitos', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('foto', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
        ))
        db.send_create_signal('diocese', ['AssociacaoObraPresbitero'])

        # Adding model 'PrelaturaPessoal'
        db.create_table('diocese_prelaturapessoal', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_prelaturapessoal_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_prelaturapessoal_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_prelaturapessoal_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('codigo_ecclesia', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('nome', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('congregacao_id', self.gf('django.db.models.fields.PositiveIntegerField')(max_length=3, null=True, blank=True)),
            ('comunidade', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('superiora', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('membros', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('morada', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('codigo_postal', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('localidade', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telefone', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telemovel', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('fax', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('email', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('paginaweb', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('arciprestado', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_prelaturapessoal_arciprestado', null=True, to=orm['diocese.Arciprestado'])),
            ('foto', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
        ))
        db.send_create_signal('diocese', ['PrelaturaPessoal'])

        # Adding model 'InstitutoReligiosoFeminino'
        db.create_table('diocese_institutoreligiosofeminino', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_institutoreligiosofeminino_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_institutoreligiosofeminino_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_institutoreligiosofeminino_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('codigo_ecclesia', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('nome', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('congregacao_id', self.gf('django.db.models.fields.PositiveIntegerField')(max_length=3, null=True, blank=True)),
            ('comunidade', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('superiora', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('membros', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('morada', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('codigo_postal', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('localidade', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telefone', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telemovel', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('fax', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('email', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('paginaweb', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('arciprestado', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_institutoreligiosofeminino_arciprestado', null=True, to=orm['diocese.Arciprestado'])),
            ('foto', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
        ))
        db.send_create_signal('diocese', ['InstitutoReligiosoFeminino'])

        # Adding model 'InstitutoReligiosoMasculino'
        db.create_table('diocese_institutoreligiosomasculino', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_institutoreligiosomasculino_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_institutoreligiosomasculino_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_institutoreligiosomasculino_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('codigo_ecclesia', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('nome', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('congregacao_id', self.gf('django.db.models.fields.PositiveIntegerField')(max_length=2, null=True, blank=True)),
            ('comunidade', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('superior', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('membros', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('morada', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('codigo_postal', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('localidade', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telefone', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telemovel', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('fax', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('email', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('paginaweb', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('arciprestado', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_institutoreligiosomasculino_arciprestado', null=True, to=orm['diocese.Arciprestado'])),
            ('foto', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
        ))
        db.send_create_signal('diocese', ['InstitutoReligiosoMasculino'])

        # Adding model 'InstitutoSecular'
        db.create_table('diocese_institutosecular', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_institutosecular_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_institutosecular_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_institutosecular_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('codigo_ecclesia', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('nome', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('instituto_secular_n_id', self.gf('django.db.models.fields.PositiveIntegerField')(max_length=2, null=True, blank=True)),
            ('comunidade', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('director', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('morada', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('codigo_postal', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('localidade', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telefone', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telemovel', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('fax', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('email', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('paginaweb', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('obs', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('arciprestado', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_institutosecular_arciprestado', null=True, to=orm['diocese.Arciprestado'])),
            ('assistente', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('foto', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
        ))
        db.send_create_signal('diocese', ['InstitutoSecular'])

        # Adding model 'SociedadeVidaApostolica'
        db.create_table('diocese_sociedadevidaapostolica', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_sociedadevidaapostolica_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_sociedadevidaapostolica_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_sociedadevidaapostolica_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('codigo_ecclesia', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('nome', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('director', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('morada', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('codigo_postal', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('localidade', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telefone', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telemovel', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('fax', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('email', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('paginaweb', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('foto', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
        ))
        db.send_create_signal('diocese', ['SociedadeVidaApostolica'])

        # Adding model 'AssociacaoMovimentoObra'
        db.create_table('diocese_associacaomovimentoobra', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_associacaomovimentoobra_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_associacaomovimentoobra_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_associacaomovimentoobra_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('codigo_ecclesia', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('nome', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('presidente', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('assistente', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('morada', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('codigo_postal', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('localidade', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telefone', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telemovel', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('fax', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('email', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('paginaweb', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('arciprestado', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_associacaomovimentoobra_arciprestado', null=True, to=orm['diocese.Arciprestado'])),
            ('foto', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
        ))
        db.send_create_signal('diocese', ['AssociacaoMovimentoObra'])

        # Adding model 'CentroAnimacaoEspiritual'
        db.create_table('diocese_centroanimacaoespiritual', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_centroanimacaoespiritual_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_centroanimacaoespiritual_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_centroanimacaoespiritual_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('codigo_ecclesia', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('nome', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('director', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('propiedade', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('morada', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('codigo_postal', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('localidade', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telefone', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telemovel', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('fax', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('email', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('paginaweb', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('obs', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('arciprestado', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_centroanimacaoespiritual_arciprestado', null=True, to=orm['diocese.Arciprestado'])),
            ('assistente', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('foto', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
        ))
        db.send_create_signal('diocese', ['CentroAnimacaoEspiritual'])

        # Adding model 'Valencias'
        db.create_table('diocese_valencias', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_valencias_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_valencias_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_valencias_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('codigo_ecclesia', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('nome', self.gf('django.db.models.fields.CharField')(max_length=255)),
        ))
        db.send_create_signal('diocese', ['Valencias'])

        # Adding model 'ObraAccaoSocioCaritativa'
        db.create_table('diocese_obraaccaosociocaritativa', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_obraaccaosociocaritativa_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_obraaccaosociocaritativa_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_obraaccaosociocaritativa_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('codigo_ecclesia', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('nome', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('tipo', self.gf('django.db.models.fields.PositiveIntegerField')(default=15, max_length=2)),
            ('propriedade', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('responsavel', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('morada', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('codigo_postal', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('localidade', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telefone', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telemovel', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('fax', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('email', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('paginaweb', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('obs', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('arciprestado', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_obraaccaosociocaritativa_arciprestado', null=True, to=orm['diocese.Arciprestado'])),
            ('assistente', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('foto', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
        ))
        db.send_create_signal('diocese', ['ObraAccaoSocioCaritativa'])

        # Adding M2M table for field multipo_id on 'ObraAccaoSocioCaritativa'
        db.create_table('diocese_obraaccaosociocaritativa_multipo_id', (
            ('id', models.AutoField(verbose_name='ID', primary_key=True, auto_created=True)),
            ('obraaccaosociocaritativa', models.ForeignKey(orm['diocese.obraaccaosociocaritativa'], null=False)),
            ('valencias', models.ForeignKey(orm['diocese.valencias'], null=False))
        ))
        db.create_unique('diocese_obraaccaosociocaritativa_multipo_id', ['obraaccaosociocaritativa_id', 'valencias_id'])

        # Adding model 'EscolaCatolica'
        db.create_table('diocese_escolacatolica', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_escolacatolica_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_escolacatolica_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_escolacatolica_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('codigo_ecclesia', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('nome', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('escolaridade', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('propriedade', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('director', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('morada', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('codigo_postal', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('localidade', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telefone', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telemovel', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('fax', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('email', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('paginaweb', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('arciprestado', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_escolacatolica_arciprestado', null=True, to=orm['diocese.Arciprestado'])),
            ('foto', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
        ))
        db.send_create_signal('diocese', ['EscolaCatolica'])

        # Adding model 'InstituicaoCultural'
        db.create_table('diocese_instituicaocultural', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_instituicaocultural_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_instituicaocultural_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_instituicaocultural_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('codigo_ecclesia', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('nome', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('director', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('propriedade', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('morada', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('codigo_postal', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('localidade', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telefone', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telemovel', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('fax', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('email', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('paginaweb', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('obs', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('arciprestado', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_instituicaocultural_arciprestado', null=True, to=orm['diocese.Arciprestado'])),
            ('foto', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
        ))
        db.send_create_signal('diocese', ['InstituicaoCultural'])

        # Adding model 'ComunicacaoSocial'
        db.create_table('diocese_comunicacaosocial', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_comunicacaosocial_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_comunicacaosocial_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_comunicacaosocial_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('codigo_ecclesia', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('nome', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('tipo', self.gf('django.db.models.fields.PositiveIntegerField')(max_length=1, null=True, blank=True)),
            ('periocidade', self.gf('django.db.models.fields.PositiveIntegerField')(max_length=1, null=True, blank=True)),
            ('director', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('propriedade', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('morada', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('codigo_postal', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('localidade', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telefone', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telemovel', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('fax', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('email', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('paginaweb', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('obs', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('arciprestado', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_comunicacaosocial_arciprestado', null=True, to=orm['diocese.Arciprestado'])),
            ('foto', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
        ))
        db.send_create_signal('diocese', ['ComunicacaoSocial'])

        # Adding model 'DadosEstatisticos'
        db.create_table('diocese_dadosestatisticos', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_dadosestatisticos_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_dadosestatisticos_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_dadosestatisticos_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('codigo_ecclesia', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('ano', self.gf('django.db.models.fields.IntegerField')(unique=True)),
            ('superficie', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('populacao', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('catolicos', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('arciprestados', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('paroquias', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('pclerodiocesano', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('pcleroreligioso', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('poutrosacerdote', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('pdiaconosper', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('preligiosas', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('pleigos', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('totalmentevacantes', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('capelanias', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('sacerdotesdiocesanos', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('spdiocesepropria', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('spnoutradiocese', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('foraservicopastoral', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('srrdiocese', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('srrtotalpartesdiocese', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('srrservicoinstituto', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('srrforaservicopastoral', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('religiososprofessosnsacerdotes', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('religiosasprofessasrd', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('diaconospermanentes', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('candidatossacerdocio', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('cscelrodiocesano', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('cscleroreligioso', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('del1', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('cficlerodiocesano', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('cficleroreligioso', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('del2', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('cieescolasmaternoinfantis', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('cieescolasprimarias', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('cieescolassecundarias', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('cieinstitutossuperiores', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('cieuniversidadecatolica', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('cashospitais', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('casambulatorios', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('cascasasdeidosos', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('casorfanatos', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('cascreches', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('casconsultoriosfamiliares', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('cascentrosespeciais', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('cascentrossociais', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('casconfrarias', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('casmisericordias', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('vsbaptizados', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('vsate1ano', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('vsde1a7anos', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('vsapos7anos', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('vsconfirmacoes', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('vsprimeirascomunhoes', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('vsmatrimonioscanonicos', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('vsmcentrecatolicos', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('vsmcentrecatolicoencatolico', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('ecseditorascatolicas', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('ecslivrarias', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('ecsjornaisdiarios', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('ecsjornaissemanarios', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('ecsjornaisquinzenarios', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('ecsjornaismensarios', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('ecsboletinsparoquiais', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('ecsradiosregionais', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('ecsradioslocais', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('obs', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
        ))
        db.send_create_signal('diocese', ['DadosEstatisticos'])

        # Adding model 'Paroquia'
        db.create_table('diocese_paroquia', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_paroquia_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='diocese_paroquia_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_paroquia_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('codigo_ecclesia', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('nome', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('morada', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('codigo_postal', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('localidade', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telefone', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('telemovel', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('fax', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('email', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('paginaweb', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('arciprestado', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_paroquia_paroquia_arciprestado', null=True, to=orm['diocese.Arciprestado'])),
            ('orago', self.gf('django.db.models.fields.PositiveIntegerField')(max_length=3, null=True, blank=True)),
            ('padre1', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_paroquia_paroquia_padre1', null=True, to=orm['diocese.Presbitero'])),
            ('padre2', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_paroquia_paroquia_padre2', null=True, to=orm['diocese.Presbitero'])),
            ('padre3', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='diocese_paroquia_paroquia_padre3', null=True, to=orm['diocese.Presbitero'])),
        ))
        db.send_create_signal('diocese', ['Paroquia'])


    def backwards(self, orm):
        # Removing unique constraint on 'DiaconoPermanenteRetiros', fields ['diaconopermanente', 'ano']
        db.delete_unique('diocese_diaconopermanenteretiros', ['diaconopermanente_id', 'ano'])

        # Removing unique constraint on 'PresbiteroRetiros', fields ['presbitero', 'ano']
        db.delete_unique('diocese_presbiteroretiros', ['presbitero_id', 'ano'])

        # Deleting model 'Ecclesia'
        db.delete_table('diocese_ecclesia')

        # Deleting model 'Presbitero'
        db.delete_table('diocese_presbitero')

        # Deleting model 'PresbiteroRetiros'
        db.delete_table('diocese_presbiteroretiros')

        # Deleting model 'DiaconoPermanente'
        db.delete_table('diocese_diaconopermanente')

        # Deleting model 'DiaconoPermanenteRetiros'
        db.delete_table('diocese_diaconopermanenteretiros')

        # Deleting model 'Arciprestado'
        db.delete_table('diocese_arciprestado')

        # Deleting model 'NotaHistorica'
        db.delete_table('diocese_notahistorica')

        # Deleting model 'Bispo'
        db.delete_table('diocese_bispo')

        # Deleting model 'CuriaDiocesana'
        db.delete_table('diocese_curiadiocesana')

        # Deleting model 'Chancelaria'
        db.delete_table('diocese_chancelaria')

        # Deleting model 'GestaoRecursos'
        db.delete_table('diocese_gestaorecursos')

        # Deleting model 'ConselhoPresbiteral'
        db.delete_table('diocese_conselhopresbiteral')

        # Deleting model 'ColegioConsultores'
        db.delete_table('diocese_colegioconsultores')

        # Deleting model 'Cabido'
        db.delete_table('diocese_cabido')

        # Deleting model 'ConselhoPastoral'
        db.delete_table('diocese_conselhopastoral')

        # Deleting model 'ColegioArciprestes'
        db.delete_table('diocese_colegioarciprestes')

        # Deleting model 'Secretariado'
        db.delete_table('diocese_secretariado')

        # Deleting model 'Comissao'
        db.delete_table('diocese_comissao')

        # Deleting model 'TribunalEclesiastico'
        db.delete_table('diocese_tribunaleclesiastico')

        # Deleting model 'Seminario'
        db.delete_table('diocese_seminario')

        # Deleting model 'DiaconadoPermanente'
        db.delete_table('diocese_diaconadopermanente')

        # Deleting model 'FormacaoAgentePastoral'
        db.delete_table('diocese_formacaoagentepastoral')

        # Deleting model 'CentroVidaCrista'
        db.delete_table('diocese_centrovidacrista')

        # Deleting model 'AssociacaoObraPresbitero'
        db.delete_table('diocese_associacaoobrapresbitero')

        # Deleting model 'PrelaturaPessoal'
        db.delete_table('diocese_prelaturapessoal')

        # Deleting model 'InstitutoReligiosoFeminino'
        db.delete_table('diocese_institutoreligiosofeminino')

        # Deleting model 'InstitutoReligiosoMasculino'
        db.delete_table('diocese_institutoreligiosomasculino')

        # Deleting model 'InstitutoSecular'
        db.delete_table('diocese_institutosecular')

        # Deleting model 'SociedadeVidaApostolica'
        db.delete_table('diocese_sociedadevidaapostolica')

        # Deleting model 'AssociacaoMovimentoObra'
        db.delete_table('diocese_associacaomovimentoobra')

        # Deleting model 'CentroAnimacaoEspiritual'
        db.delete_table('diocese_centroanimacaoespiritual')

        # Deleting model 'Valencias'
        db.delete_table('diocese_valencias')

        # Deleting model 'ObraAccaoSocioCaritativa'
        db.delete_table('diocese_obraaccaosociocaritativa')

        # Removing M2M table for field multipo_id on 'ObraAccaoSocioCaritativa'
        db.delete_table('diocese_obraaccaosociocaritativa_multipo_id')

        # Deleting model 'EscolaCatolica'
        db.delete_table('diocese_escolacatolica')

        # Deleting model 'InstituicaoCultural'
        db.delete_table('diocese_instituicaocultural')

        # Deleting model 'ComunicacaoSocial'
        db.delete_table('diocese_comunicacaosocial')

        # Deleting model 'DadosEstatisticos'
        db.delete_table('diocese_dadosestatisticos')

        # Deleting model 'Paroquia'
        db.delete_table('diocese_paroquia')


    models = {
        'auth.group': {
            'Meta': {'object_name': 'Group'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '80'}),
            'permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'})
        },
        'auth.permission': {
            'Meta': {'ordering': "('content_type__app_label', 'content_type__model', 'codename')", 'unique_together': "(('content_type', 'codename'),)", 'object_name': 'Permission'},
            'codename': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'content_type': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['contenttypes.ContentType']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '50'})
        },
        'auth.user': {
            'Meta': {'object_name': 'User'},
            'date_joined': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'email': ('django.db.models.fields.EmailField', [], {'max_length': '75', 'blank': 'True'}),
            'first_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'groups': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Group']", 'symmetrical': 'False', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'is_active': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'is_staff': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_superuser': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'last_login': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'last_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'password': ('django.db.models.fields.CharField', [], {'max_length': '128'}),
            'user_permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'}),
            'username': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '30'})
        },
        'contenttypes.contenttype': {
            'Meta': {'ordering': "('name',)", 'unique_together': "(('app_label', 'model'),)", 'object_name': 'ContentType', 'db_table': "'django_content_type'"},
            'app_label': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'model': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'})
        },
        'diocese.arciprestado': {
            'Meta': {'object_name': 'Arciprestado'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_arciprestado_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'arcipreste': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'arcipreste_adjunto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_arciprestado_criado_por'", 'to': "orm['auth.User']"}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_arciprestado_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'logo': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'presbitero_arcipreste': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_arciprestado_presbitero_arcipreste'", 'null': 'True', 'to': "orm['diocese.Presbitero']"}),
            'presbitero_arcipreste_adjunto': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_arciprestado_presbitero_arcipreste_adjunto'", 'null': 'True', 'to': "orm['diocese.Presbitero']"})
        },
        'diocese.associacaomovimentoobra': {
            'Meta': {'object_name': 'AssociacaoMovimentoObra'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_associacaomovimentoobra_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_associacaomovimentoobra_arciprestado'", 'null': 'True', 'to': "orm['diocese.Arciprestado']"}),
            'assistente': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_associacaomovimentoobra_criado_por'", 'to': "orm['auth.User']"}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_associacaomovimentoobra_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'presidente': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.associacaoobrapresbitero': {
            'Meta': {'object_name': 'AssociacaoObraPresbitero'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_associacaoobrapresbitero_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_associacaoobrapresbitero_arciprestado'", 'null': 'True', 'to': "orm['diocese.Arciprestado']"}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_associacaoobrapresbitero_criado_por'", 'to': "orm['auth.User']"}),
            'director': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_associacaoobrapresbitero_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'membros_eleitos': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'obs': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.bispo': {
            'Meta': {'object_name': 'Bispo'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_bispo_alterado_por'", 'to': "orm['auth.User']"}),
            'bispo_tipo': ('django.db.models.fields.PositiveIntegerField', [], {'default': '1', 'max_length': '1'}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_bispo_criado_por'", 'to': "orm['auth.User']"}),
            'curriculo': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'data_faleceu': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'data_nascimento': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'data_nomeacao': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'data_orden_episc': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'data_orden_presbiteral': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'data_resignacao': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'data_tomada': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'faleceu': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fraternidade_sacerdotal': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_bispo_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'habilitacoes_academicas': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'local_nascimento': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'local_ordenacao_presb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'local_ordenacoa_episc': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'nomeacoes': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'observacoes': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel_privado': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.cabido': {
            'Meta': {'object_name': 'Cabido'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_cabido_alterado_por'", 'to': "orm['auth.User']"}),
            'arcediago': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'arcipreste': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'arquivo_capitular': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'beneficiados': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'capitulares': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'chantre': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_cabido_criado_por'", 'to': "orm['auth.User']"}),
            'deao': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'dignidades': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_cabido_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'honorarios': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'jubilados': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'mestre_escola': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'penitenciario': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'presidente': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'secretario': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'tesoureiro': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'vice_presidente': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.centroanimacaoespiritual': {
            'Meta': {'object_name': 'CentroAnimacaoEspiritual'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_centroanimacaoespiritual_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_centroanimacaoespiritual_arciprestado'", 'null': 'True', 'to': "orm['diocese.Arciprestado']"}),
            'assistente': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_centroanimacaoespiritual_criado_por'", 'to': "orm['auth.User']"}),
            'director': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_centroanimacaoespiritual_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'obs': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'propiedade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.centrovidacrista': {
            'Meta': {'object_name': 'CentroVidaCrista'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_centrovidacrista_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_centrovidacrista_arciprestado'", 'null': 'True', 'to': "orm['diocese.Arciprestado']"}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_centrovidacrista_criado_por'", 'to': "orm['auth.User']"}),
            'director': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_centrovidacrista_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'obs': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'propriedade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'tipo': ('django.db.models.fields.PositiveIntegerField', [], {'default': '1', 'max_length': '1'})
        },
        'diocese.chancelaria': {
            'Meta': {'object_name': 'Chancelaria'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_chancelaria_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_chancelaria_arciprestado'", 'null': 'True', 'to': "orm['diocese.Arciprestado']"}),
            'arquivo_historico': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'arquivo_secreto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'associacoes_religiosas': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'chanceler': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'consultor_juridico': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_chancelaria_criado_por'", 'to': "orm['auth.User']"}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_chancelaria_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'notario': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'secretariado_deral': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'servico_del_pios': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'vice_chanceler': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.colegioarciprestes': {
            'Meta': {'object_name': 'ColegioArciprestes'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_colegioarciprestes_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_colegioarciprestes_arciprestado'", 'null': 'True', 'to': "orm['diocese.Arciprestado']"}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'colegio_arciprestes': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_colegioarciprestes_criado_por'", 'to': "orm['auth.User']"}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_colegioarciprestes_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.colegioconsultores': {
            'Meta': {'object_name': 'ColegioConsultores'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_colegioconsultores_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_colegioconsultores_arciprestado'", 'null': 'True', 'to': "orm['diocese.Arciprestado']"}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'colegio_consultores': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_colegioconsultores_criado_por'", 'to': "orm['auth.User']"}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_colegioconsultores_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.comissao': {
            'Meta': {'object_name': 'Comissao'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_comissao_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_comissao_arciprestado'", 'null': 'True', 'to': "orm['diocese.Arciprestado']"}),
            'assistente': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_comissao_criado_por'", 'to': "orm['auth.User']"}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_comissao_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'membros': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'presidente': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'sector_departamento': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.comunicacaosocial': {
            'Meta': {'object_name': 'ComunicacaoSocial'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_comunicacaosocial_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_comunicacaosocial_arciprestado'", 'null': 'True', 'to': "orm['diocese.Arciprestado']"}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_comunicacaosocial_criado_por'", 'to': "orm['auth.User']"}),
            'director': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_comunicacaosocial_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'obs': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'periocidade': ('django.db.models.fields.PositiveIntegerField', [], {'max_length': '1', 'null': 'True', 'blank': 'True'}),
            'propriedade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'tipo': ('django.db.models.fields.PositiveIntegerField', [], {'max_length': '1', 'null': 'True', 'blank': 'True'})
        },
        'diocese.conselhopastoral': {
            'Meta': {'object_name': 'ConselhoPastoral'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_conselhopastoral_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_conselhopastoral_arciprestado'", 'null': 'True', 'to': "orm['diocese.Arciprestado']"}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'comissao_permanente': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_conselhopastoral_criado_por'", 'to': "orm['auth.User']"}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_conselhopastoral_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'mandato': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'membros_designados': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'membros_eleitos': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'membros_natos': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.conselhopresbiteral': {
            'Meta': {'object_name': 'ConselhoPresbiteral'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_conselhopresbiteral_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_conselhopresbiteral_arciprestado'", 'null': 'True', 'to': "orm['diocese.Arciprestado']"}),
            'associados_presidencia': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'conselho_permanente': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_conselhopresbiteral_criado_por'", 'to': "orm['auth.User']"}),
            'designados_bispo': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_conselhopresbiteral_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'membros_natos': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'por_eleicao': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.curiadiocesana': {
            'Meta': {'object_name': 'CuriaDiocesana'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'administradorcasaarquiepiscopal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_curiadiocesana_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_curiadiocesana_arciprestado'", 'null': 'True', 'to': "orm['diocese.Arciprestado']"}),
            'arquivo_historico': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'arquivo_secreto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'associacoes_religiosas': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'chanceler': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'chefe_gabinete': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'conselho_episcopal': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'consultor_juridico': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_curiadiocesana_criado_por'", 'to': "orm['auth.User']"}),
            'delegados_episcopais': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'director': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'direvigarios_episcopais': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'feriados': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_curiadiocesana_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'gabinete_informacao': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'horarios': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'moderador': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'notario': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'provigario_geral': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'secretaria_episcopal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'secretariado_geral': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'secretario_particular': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'servico_legados_pios': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'vigarios_gerais': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'vigarios_gerais_ad': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'})
        },
        'diocese.dadosestatisticos': {
            'Meta': {'object_name': 'DadosEstatisticos'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_dadosestatisticos_alterado_por'", 'to': "orm['auth.User']"}),
            'ano': ('django.db.models.fields.IntegerField', [], {'unique': 'True'}),
            'arciprestados': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'candidatossacerdocio': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'capelanias': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'casambulatorios': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'cascasasdeidosos': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'cascentrosespeciais': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'cascentrossociais': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'casconfrarias': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'casconsultoriosfamiliares': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'cascreches': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'cashospitais': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'casmisericordias': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'casorfanatos': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'catolicos': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'cficlerodiocesano': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'cficleroreligioso': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'cieescolasmaternoinfantis': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'cieescolasprimarias': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'cieescolassecundarias': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'cieinstitutossuperiores': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'cieuniversidadecatolica': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_dadosestatisticos_criado_por'", 'to': "orm['auth.User']"}),
            'cscelrodiocesano': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'cscleroreligioso': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'del1': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'del2': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'diaconospermanentes': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'ecsboletinsparoquiais': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'ecseditorascatolicas': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'ecsjornaisdiarios': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'ecsjornaismensarios': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'ecsjornaisquinzenarios': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'ecsjornaissemanarios': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'ecslivrarias': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'ecsradioslocais': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'ecsradiosregionais': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'foraservicopastoral': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_dadosestatisticos_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'obs': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'paroquias': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'pclerodiocesano': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'pcleroreligioso': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'pdiaconosper': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'pleigos': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'populacao': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'poutrosacerdote': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'preligiosas': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'religiosasprofessasrd': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'religiososprofessosnsacerdotes': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'sacerdotesdiocesanos': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'spdiocesepropria': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'spnoutradiocese': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'srrdiocese': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'srrforaservicopastoral': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'srrservicoinstituto': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'srrtotalpartesdiocese': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'superficie': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'totalmentevacantes': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'vsapos7anos': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'vsate1ano': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'vsbaptizados': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'vsconfirmacoes': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'vsde1a7anos': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'vsmatrimonioscanonicos': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'vsmcentrecatolicoencatolico': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'vsmcentrecatolicos': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'vsprimeirascomunhoes': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'})
        },
        'diocese.diaconadopermanente': {
            'Meta': {'object_name': 'DiaconadoPermanente'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_diaconadopermanente_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_diaconadopermanente_arciprestado'", 'null': 'True', 'to': "orm['diocese.Arciprestado']"}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_diaconadopermanente_criado_por'", 'to': "orm['auth.User']"}),
            'delegado': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_diaconadopermanente_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'seleccao_formacao': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.diaconopermanente': {
            'Meta': {'object_name': 'DiaconoPermanente'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_diaconopermanente_alterado_por'", 'to': "orm['auth.User']"}),
            'cartao_sacerdotal': ('django.db.models.fields.IntegerField', [], {'max_length': '2', 'null': 'True', 'blank': 'True'}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_diaconopermanente_criado_por'", 'to': "orm['auth.User']"}),
            'data_faleceu': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'data_nascimento': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'data_ordenacoa': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'delegado_coordenador': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'faleceu': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_diaconopermanente_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'local_nascimento': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'local_ordenacao': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'nomeacoes': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'obs': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'serv_pastoral': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel_privado': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.diaconopermanenteretiros': {
            'Meta': {'unique_together': "(('diaconopermanente', 'ano'),)", 'object_name': 'DiaconoPermanenteRetiros'},
            'ano': ('django.db.models.fields.IntegerField', [], {'max_length': '4', 'null': 'True', 'blank': 'True'}),
            'diaconopermanente': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_diaconopermanenteretiros_diaconopermanenteretiros'", 'to': "orm['diocese.DiaconoPermanente']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'observacoes': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.ecclesia': {
            'Meta': {'object_name': 'Ecclesia'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_ecclesia_alterado_por'", 'to': "orm['auth.User']"}),
            'codigo': ('django.db.models.fields.IntegerField', [], {}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_ecclesia_criado_por'", 'to': "orm['auth.User']"}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_ecclesia_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'tabela': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'tipo': ('django.db.models.fields.CharField', [], {'max_length': '1'})
        },
        'diocese.escolacatolica': {
            'Meta': {'object_name': 'EscolaCatolica'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_escolacatolica_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_escolacatolica_arciprestado'", 'null': 'True', 'to': "orm['diocese.Arciprestado']"}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_escolacatolica_criado_por'", 'to': "orm['auth.User']"}),
            'director': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'escolaridade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_escolacatolica_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'propriedade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.formacaoagentepastoral': {
            'Meta': {'object_name': 'FormacaoAgentePastoral'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_formacaoagentepastoral_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_formacaoagentepastoral_arciprestado'", 'null': 'True', 'to': "orm['diocese.Arciprestado']"}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_formacaoagentepastoral_criado_por'", 'to': "orm['auth.User']"}),
            'director': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_formacaoagentepastoral_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'obs': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'propriedade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.gestaorecursos': {
            'Meta': {'object_name': 'GestaoRecursos'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_gestaorecursos_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_gestaorecursos_arciprestado'", 'null': 'True', 'to': "orm['diocese.Arciprestado']"}),
            'assuntos_economicos': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_gestaorecursos_criado_por'", 'to': "orm['auth.User']"}),
            'economo': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_gestaorecursos_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'membros_eleitos': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'membros_natos': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'tesouraria': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.instituicaocultural': {
            'Meta': {'object_name': 'InstituicaoCultural'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_instituicaocultural_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_instituicaocultural_arciprestado'", 'null': 'True', 'to': "orm['diocese.Arciprestado']"}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_instituicaocultural_criado_por'", 'to': "orm['auth.User']"}),
            'director': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_instituicaocultural_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'obs': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'propriedade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.institutoreligiosofeminino': {
            'Meta': {'object_name': 'InstitutoReligiosoFeminino'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_institutoreligiosofeminino_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_institutoreligiosofeminino_arciprestado'", 'null': 'True', 'to': "orm['diocese.Arciprestado']"}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'comunidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'congregacao_id': ('django.db.models.fields.PositiveIntegerField', [], {'max_length': '3', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_institutoreligiosofeminino_criado_por'", 'to': "orm['auth.User']"}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_institutoreligiosofeminino_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'membros': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'superiora': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.institutoreligiosomasculino': {
            'Meta': {'object_name': 'InstitutoReligiosoMasculino'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_institutoreligiosomasculino_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_institutoreligiosomasculino_arciprestado'", 'null': 'True', 'to': "orm['diocese.Arciprestado']"}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'comunidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'congregacao_id': ('django.db.models.fields.PositiveIntegerField', [], {'max_length': '2', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_institutoreligiosomasculino_criado_por'", 'to': "orm['auth.User']"}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_institutoreligiosomasculino_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'membros': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'superior': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.institutosecular': {
            'Meta': {'object_name': 'InstitutoSecular'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_institutosecular_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_institutosecular_arciprestado'", 'null': 'True', 'to': "orm['diocese.Arciprestado']"}),
            'assistente': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'comunidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_institutosecular_criado_por'", 'to': "orm['auth.User']"}),
            'director': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_institutosecular_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'instituto_secular_n_id': ('django.db.models.fields.PositiveIntegerField', [], {'max_length': '2', 'null': 'True', 'blank': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'obs': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.notahistorica': {
            'Meta': {'object_name': 'NotaHistorica'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_notahistorica_alterado_por'", 'to': "orm['auth.User']"}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_notahistorica_criado_por'", 'to': "orm['auth.User']"}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_notahistorica_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'nota_historica': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'sufraganea': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.obraaccaosociocaritativa': {
            'Meta': {'object_name': 'ObraAccaoSocioCaritativa'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_obraaccaosociocaritativa_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_obraaccaosociocaritativa_arciprestado'", 'null': 'True', 'to': "orm['diocese.Arciprestado']"}),
            'assistente': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_obraaccaosociocaritativa_criado_por'", 'to': "orm['auth.User']"}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_obraaccaosociocaritativa_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'multipo_id': ('django.db.models.fields.related.ManyToManyField', [], {'symmetrical': 'False', 'to': "orm['diocese.Valencias']", 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'obs': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'propriedade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'responsavel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'tipo': ('django.db.models.fields.PositiveIntegerField', [], {'default': '15', 'max_length': '2'})
        },
        'diocese.paroquia': {
            'Meta': {'object_name': 'Paroquia'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_paroquia_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_paroquia_paroquia_arciprestado'", 'null': 'True', 'to': "orm['diocese.Arciprestado']"}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_paroquia_criado_por'", 'to': "orm['auth.User']"}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_paroquia_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'orago': ('django.db.models.fields.PositiveIntegerField', [], {'max_length': '3', 'null': 'True', 'blank': 'True'}),
            'padre1': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_paroquia_paroquia_padre1'", 'null': 'True', 'to': "orm['diocese.Presbitero']"}),
            'padre2': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_paroquia_paroquia_padre2'", 'null': 'True', 'to': "orm['diocese.Presbitero']"}),
            'padre3': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_paroquia_paroquia_padre3'", 'null': 'True', 'to': "orm['diocese.Presbitero']"}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.prelaturapessoal': {
            'Meta': {'object_name': 'PrelaturaPessoal'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_prelaturapessoal_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_prelaturapessoal_arciprestado'", 'null': 'True', 'to': "orm['diocese.Arciprestado']"}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'comunidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'congregacao_id': ('django.db.models.fields.PositiveIntegerField', [], {'max_length': '3', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_prelaturapessoal_criado_por'", 'to': "orm['auth.User']"}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_prelaturapessoal_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'membros': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'superiora': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.presbitero': {
            'Meta': {'object_name': 'Presbitero'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_presbitero_alterado_por'", 'to': "orm['auth.User']"}),
            'arcipreste': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'capelao': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'cartao_sacerdotal': ('django.db.models.fields.IntegerField', [], {'max_length': '2', 'null': 'True', 'blank': 'True'}),
            'clero_tipo': ('django.db.models.fields.PositiveIntegerField', [], {'default': '1', 'max_length': '1'}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_presbitero_criado_por'", 'to': "orm['auth.User']"}),
            'data_faleceu': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'data_nascimento': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'data_ordenacoa': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'faleceu': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'formacao_permanente': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fraternidade_sacerdotal': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_presbitero_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'habilitacoes_academicas': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'igreja': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'local_nascimento': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'local_ordenacao': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'nomeacoes': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'nomeacoes_actuais': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'obs': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'paroco': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'publicacoes': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'reitor': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'serv_pastoral': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel_privado': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'tipo_clero': ('django.db.models.fields.PositiveIntegerField', [], {'max_length': '1', 'null': 'True', 'blank': 'True'}),
            'vice_arcipreste': ('django.db.models.fields.BooleanField', [], {'default': 'False'})
        },
        'diocese.presbiteroretiros': {
            'Meta': {'unique_together': "(('presbitero', 'ano'),)", 'object_name': 'PresbiteroRetiros'},
            'ano': ('django.db.models.fields.IntegerField', [], {'max_length': '4', 'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'observacoes': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'presbitero': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_presbiteroretiros_presbiteroretiros'", 'to': "orm['diocese.Presbitero']"})
        },
        'diocese.secretariado': {
            'Meta': {'object_name': 'Secretariado'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_secretariado_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_secretariado_arciprestado'", 'null': 'True', 'to': "orm['diocese.Arciprestado']"}),
            'assistente': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'coordenador': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_secretariado_criado_por'", 'to': "orm['auth.User']"}),
            'director': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_secretariado_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'sector_departamento': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.seminario': {
            'Meta': {'object_name': 'Seminario'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_seminario_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_seminario_arciprestado'", 'null': 'True', 'to': "orm['diocese.Arciprestado']"}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'confessor': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_seminario_criado_por'", 'to': "orm['auth.User']"}),
            'director_espiritual': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'economo': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'equipa_resp': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_seminario_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'obs': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'prefeito': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'reitor': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'secretario': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'tesoureiro': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'vice_reitor': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.sociedadevidaapostolica': {
            'Meta': {'object_name': 'SociedadeVidaApostolica'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_sociedadevidaapostolica_alterado_por'", 'to': "orm['auth.User']"}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_sociedadevidaapostolica_criado_por'", 'to': "orm['auth.User']"}),
            'director': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_sociedadevidaapostolica_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.tribunaleclesiastico': {
            'Meta': {'object_name': 'TribunalEclesiastico'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'advogados_oficio': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_tribunaleclesiastico_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_tribunaleclesiastico_arciprestado'", 'null': 'True', 'to': "orm['diocese.Arciprestado']"}),
            'auditores': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_tribunaleclesiastico_criado_por'", 'to': "orm['auth.User']"}),
            'defensor_vinculo': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_tribunaleclesiastico_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'juizes_diocesanos': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'meirinho': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'notario_actuario': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'obs': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'promotor_justica': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'vigario_judicial': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'vigariojudicialad': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.valencias': {
            'Meta': {'object_name': 'Valencias'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_valencias_alterado_por'", 'to': "orm['auth.User']"}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_valencias_criado_por'", 'to': "orm['auth.User']"}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_valencias_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'})
        },
        'elfinder.filecollection': {
            'Meta': {'object_name': 'FileCollection'},
            'dir': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'url': ('django.db.models.fields.CharField', [], {'max_length': '255'})
        }
    }

    complete_apps = ['diocese']