#coding: utf-8

from .models import *

from django.utils.translation import ugettext_lazy as _



class PresbiteroForm(modelsPresbitero.getBasePresbiteroForm(Presbitero)):
    foto = forms.CharField(label=u'Foto', widget=ElfinderImageWidget, required=False)
    nome = forms.CharField(label=_(u'Nome'), max_length=255, required=True, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    clero_tipo = forms.ChoiceField(label=_(u'Residência'), initial=1, required=False, choices=PRESBITERO_TIPOS_CHOICES, widget=forms.widgets.Select(attrs={'class':'fieldEcclesia'}))
    data_nascimento = forms.DateField(label=_(u'data nascimento'), help_text='(aaaa-mm-dd)', required=False, widget=forms.widgets.DateInput(attrs={'class':'vDateField fieldEcclesia', 'size':10}))
    data_ordenacoa = forms.DateField(label=_(u'data ordenação'), help_text='(aaaa-mm-dd)', required=False, widget=forms.widgets.DateInput(attrs={'class':'vDateField fieldEcclesia', 'size':10}))
    morada = forms.CharField(label=_(u'Morada'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    codigo_postal = forms.CharField(label=_(u'Código postal'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    localidade = forms.CharField(label=_(u'Localidade'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telefone = forms.CharField(label=_(u'Telefone'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telemovel = forms.CharField(label=_(u'Telemóvel'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    fax = forms.CharField(label=_(u'Fax'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    email = forms.CharField(label=_(u'Email'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    paginaweb = forms.CharField(label=_(u'Página web'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    serv_pastoral = forms.CharField(label=_(u'Serviço Pastoral'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    obs = forms.CharField(label=_(u'Observações'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    #diacono = models.BooleanField(_(u'Diacono'), default=False)

    class Meta(modelsPresbitero.getBasePresbiteroForm(Presbitero).Meta):
        widgets = {
                'fs': forms.widgets.HiddenInput,
                'foto': ElfinderImageWidget(attrs={'a':'a'}),
            }



class BispoForm(modelsBispo.getBaseBispoForm(Bispo)):
    foto = forms.CharField(label=u'Foto', widget=ElfinderImageWidget, required=False)
    nome = forms.CharField(label=_(u'Nome'), max_length=255, required=True, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    bispo_tipo = forms.ChoiceField(label=_(u'Tipo'), initial=1, required=False, choices=BISPO_TIPOS_CHOICES, widget=forms.widgets.Select(attrs={'class':'fieldEcclesia'}))
    data_nascimento = forms.DateField(label=_(u'Data Nascimento'), help_text='(aaaa-mm-dd)', required=False, widget=forms.widgets.DateInput(attrs={'class':'vDateField fieldEcclesia', 'size':10}))
    local_nascimento = forms.CharField(label=_(u'Local Nascimento'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    data_orden_presbiteral = forms.DateField(label=_(u'Data ordenação Presbiteral'), help_text='(aaaa-mm-dd)', required=False, widget=forms.widgets.DateInput(attrs={'class':'vDateField fieldEcclesia', 'size':10}))
    local_ordenacao_presb = forms.CharField(label=_(u'Local Ordenação presbiteral'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    data_orden_episc = forms.DateField(label=_(u'Data Ordenação Episcopal'), help_text='(aaaa-mm-dd)', required=False, widget=forms.widgets.DateInput(attrs={'class':'vDateField fieldEcclesia', 'size':10}))
    local_ordenacoa_episc = forms.CharField(label=_(u'Local Ordenação Episcopal'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    curriculo = forms.CharField(label=_(u'Currículo'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    data_nomeacao = forms.DateField(label=_(u'Data da nomeação'), help_text='(aaaa-mm-dd)', required=False, widget=forms.widgets.DateInput(attrs={'class':'vDateField fieldEcclesia', 'size':10}))
    data_tomada = forms.DateField(label=_(u'Data da tomada de posse'), help_text='(aaaa-mm-dd)', required=False, widget=forms.widgets.DateInput(attrs={'class':'vDateField fieldEcclesia', 'size':10}))
    data_resignacao = forms.DateField(label=_(u'Data resignação'), help_text='(aaaa-mm-dd)', required=False, widget=forms.widgets.DateInput(attrs={'class':'vDateField fieldEcclesia', 'size':10}))
    morada = forms.CharField(label=_(u'Morada'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    codigo_postal = forms.CharField(label=_(u'Cód. postal'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    localidade = forms.CharField(label=_(u'Localidade'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telefone = forms.CharField(label=_(u'Telefone'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telemovel = forms.CharField(label=_(u'Telemóvel'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    fax = forms.CharField(label=_(u'Fax'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    email = forms.CharField(label=_(u'Email'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    paginaweb = forms.CharField(label=_(u'Página web'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    observacoes = forms.CharField(label=_(u'Observacões'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    #noticia = forms.CharField(widget=tinymce_widgets.AdminTinyMCE)

    class Meta(modelsBispo.getBaseBispoForm(Bispo).Meta):
        widgets = {
                'fs': forms.widgets.HiddenInput,
                'foto': ElfinderImageWidget(attrs={'a':'a'}),
            }

    #pass




class DiaconoPermanenteForm(modelsDiaconoPermanente.getBaseDiaconoPermanenteForm(DiaconoPermanente)):
    foto = forms.CharField(label=u'Foto', widget=ElfinderImageWidget, required=False)
    nome = forms.CharField(label=_(u'Nome'), max_length=255, required=True, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    data_nascimento = forms.DateField(label=_(u'data nascimento'), help_text='(aaaa-mm-dd)', required=False, widget=forms.widgets.DateInput(attrs={'class':'vDateField fieldEcclesia', 'size':10}))
    data_ordenacoa = forms.DateField(label=_(u'data ordenação'), help_text='(aaaa-mm-dd)', required=False, widget=forms.widgets.DateInput(attrs={'class':'vDateField fieldEcclesia', 'size':10}))
    morada = forms.CharField(label=_(u'Morada'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    codigo_postal = forms.CharField(label=_(u'Código postal'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    localidade = forms.CharField(label=_(u'Localidade'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telefone = forms.CharField(label=_(u'Telefone'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telemovel = forms.CharField(label=_(u'Telemóvel'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    fax = forms.CharField(label=_(u'Fax'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    email = forms.CharField(label=_(u'Email'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    paginaweb = forms.CharField(label=_(u'Página web'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    serv_pastoral = forms.CharField(label=_(u'Serviço Pastoral'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    obs = forms.CharField(label=_(u'Observações'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))

    class Meta(modelsDiaconoPermanente.getBaseDiaconoPermanenteForm(DiaconoPermanente).Meta):
        widgets = {
                'fs': forms.widgets.HiddenInput,
                'foto': ElfinderImageWidget(attrs={'a':'a'}),
            }





class ArciprestadoForm(modelsArciprestado.getBaseArciprestadoForm(Arciprestado)):
    logo = forms.CharField(label=u'Logo', widget=ElfinderImageWidget, required=False)
    arciprestado = forms.CharField(label=_(u'Arciprestado'), max_length=255, required=True, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    presbitero_arcipreste = forms.ModelChoiceField(label=_(u'Arcipreste'), queryset=Presbitero.objects.all(), required=False, widget=forms.widgets.Select(attrs={'class':'fieldEcclesia'}))
    presbitero_arcipreste_adjunto = forms.ModelChoiceField(label=_(u'Arcipreste Adjunto'), queryset=Presbitero.objects.all(), required=False, widget=forms.widgets.Select(attrs={'class':'fieldEcclesia'}))

    arcipreste = forms.CharField(label=_(u'Arcipreste'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    arcipreste_adjunto = forms.CharField(label=_(u'Arcipreste Adjunto'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    class Meta(modelsArciprestado.getBaseArciprestadoForm(Arciprestado).Meta):
        widgets = {
                'fs': forms.widgets.HiddenInput,
                'logo': ElfinderImageWidget(attrs={'a':'a'}),
            }




class NotaHistoricaForm(modelsNotaHistorica.getBaseNotaHistoricaForm(NotaHistorica)):
    nome = forms.CharField(label=_(u'Nome'), max_length=255, required=True, initial=_(u'Nota Histórica de ')+diocese_nome, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    sufraganea = forms.CharField(label=_(u'Nota histórica'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    nota_historica = forms.CharField(label=_(u'Sufragânea'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))





class CuriaDiocesanaForm(modelsCuriaDiocesana.getBaseCuriaDiocesanaForm(CuriaDiocesana)):
    nome = forms.CharField(label=_(u'Nome'), max_length=255, required=True, initial=_(u'Cúria Diocesana de ')+diocese_nome, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    morada = forms.CharField(label=_(u'Morada'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    codigo_postal = forms.CharField(label=_(u'Código postal'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    localidade = forms.CharField(label=_(u'Localidade'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telefone = forms.CharField(label=_(u'Telefone'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telemovel = forms.CharField(label=_(u'Telemóvel'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    fax = forms.CharField(label=_(u'Fax'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    email = forms.CharField(label=_(u'Email'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    paginaweb = forms.CharField(label=_(u'Página web'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    horarios = forms.CharField(label=_(u'Horário'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    conselho_episcopal = forms.CharField(label=_(u'Conselho episcopal'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    moderador = forms.CharField(label=_(u'Moderador'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    vigarios_gerais = forms.CharField(label=_(u'Vigários Gerais'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    vigarios_gerais_ad = forms.CharField(label=_(u'Vigarios Gerais Adjuntos'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    provigario_geral = forms.CharField(label=_(u'Provigário Geral'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    direvigarios_episcopais = forms.CharField(label=_(u'Vigários Episcopais'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    delegados_episcopais = forms.CharField(label=_(u'Delegados Episcopais'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    secretaria_episcopal = forms.CharField(label=_(u'Secretaria Episcopal'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    chefe_gabinete = forms.CharField(label=_(u'Chefe de Gabinete'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    secretario_particular = forms.CharField(label=_(u'Secretário particular'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    gabinete_informacao = forms.CharField(label=_(u'Gabinete de Informação'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    foto = forms.CharField(label=u'Foto', widget=ElfinderImageWidget, required=False)

    class Meta(modelsCuriaDiocesana.getBaseCuriaDiocesanaForm(CuriaDiocesana).Meta):
        widgets = {
                'fs': forms.widgets.HiddenInput,
                'foto': ElfinderImageWidget(attrs={'a':'a'}),
            }







class ChancelariaForm(modelsChancelaria.getBaseChancelariaForm(Chancelaria)):
    nome = forms.CharField(label=_(u'Nome'), max_length=255, required=True, initial=_(u'Chancelaria/secretaria geral de ')+diocese_nome, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    morada = forms.CharField(label=_(u'Morada'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    codigo_postal = forms.CharField(label=_(u'Código postal'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    localidade = forms.CharField(label=_(u'Localidade'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telefone = forms.CharField(label=_(u'Telefone'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telemovel = forms.CharField(label=_(u'Telemóvel'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    fax = forms.CharField(label=_(u'Fax'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    email = forms.CharField(label=_(u'Email'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    paginaweb = forms.CharField(label=_(u'Página web'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    chanceler = forms.CharField(label=_(u'Chanceler'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    vice_chanceler = forms.CharField(label=_(u'Vice-Chanceler'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    secretariado_deral = forms.CharField(label=_(u'Secretário Geral'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    consultor_juridico = forms.CharField(label=_(u'Consultor Jurídico'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    notario = forms.CharField(label=_(u'Notário'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    servico_del_pios = forms.CharField(label=_(u'Serviço de Legados Pios'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    associacoes_religiosas = forms.CharField(label=_(u'Associações Religiosas'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    arquivo_secreto = forms.CharField(label=_(u'Arquivo Secreto'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    arquivo_historico = forms.CharField(label=_(u'Arquivo Histórico'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    foto = forms.CharField(label=u'Foto', widget=ElfinderImageWidget, required=False)

    class Meta(modelsChancelaria.getBaseChancelariaForm(Chancelaria).Meta):
        widgets = {
                'fs': forms.widgets.HiddenInput,
                'foto': ElfinderImageWidget(attrs={'a':'a'}),
            }






class GestaoRecursosForm(modelsGestaoRecursos.getBaseGestaoRecursosForm(GestaoRecursos)):
    nome = forms.CharField(label=_(u'Nome'), max_length=255, required=True, initial=_(u'Gestão de recursos pessoais, patrimoniais e financeiros de ')+diocese_nome, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    morada = forms.CharField(label=_(u'Morada'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    codigo_postal = forms.CharField(label=_(u'Código postal'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    localidade = forms.CharField(label=_(u'Localidade'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telefone = forms.CharField(label=_(u'Telefone'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telemovel = forms.CharField(label=_(u'Telemóvel'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    fax = forms.CharField(label=_(u'Fax'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    email = forms.CharField(label=_(u'Email'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    paginaweb = forms.CharField(label=_(u'Página web'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    assuntos_economicos = forms.CharField(label=_(u'Conselho para os assuntos económicos'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    economo = forms.CharField(label=_(u'Ecónomo'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    tesouraria = forms.CharField(label=_(u'Tesouraria e contabilidade'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    foto = forms.CharField(label=u'Foto', widget=ElfinderImageWidget, required=False)

    class Meta(modelsGestaoRecursos.getBaseGestaoRecursosForm(GestaoRecursos).Meta):
        widgets = {
                'fs': forms.widgets.HiddenInput,
                'foto': ElfinderImageWidget(attrs={'a':'a'}),
            }





class ConselhoPresbiteralForm(modelsConselhoPresbiteral.getBaseConselhoPresbiteralForm(ConselhoPresbiteral)):
    nome = forms.CharField(label=_(u'Nome'), max_length=255, required=True, initial=_(u'Conselho Presbiteral ')+diocese_nome, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    membros_natos = forms.CharField(label=_(u'Membros Natos'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia'}))
    associados_presidencia = forms.CharField(label=_(u'Associados à Presidência'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    por_eleicao = forms.CharField(label=_(u'Por Eleição'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    designados_bispo = forms.CharField(label=_(u'Designados pelo Bispo'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    conselho_permanente = forms.CharField(label=_(u'Conselho Permanente'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    foto = forms.CharField(label=u'Foto', widget=ElfinderImageWidget, required=False)

    class Meta(modelsConselhoPresbiteral.getBaseConselhoPresbiteralForm(ConselhoPresbiteral).Meta):
        widgets = {
                'fs': forms.widgets.HiddenInput,
                'foto': ElfinderImageWidget(attrs={'a':'a'}),
            }



class ColegioConsultoresForm(modelsColegioConsultores.getBaseColegioConsultoresForm(ColegioConsultores)):
    nome = forms.CharField(label=_(u'Nome'), max_length=255, required=True, initial=_(u'Colégio de consultores de ')+diocese_nome, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    colegio_consultores = forms.CharField(label=_(u'Colégio de Consultores'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    foto = forms.CharField(label=u'Foto', widget=ElfinderImageWidget, required=False)

    class Meta(modelsColegioConsultores.getBaseColegioConsultoresForm(ColegioConsultores).Meta):
        widgets = {
                'fs': forms.widgets.HiddenInput,
                'foto': ElfinderImageWidget(attrs={'a':'a'}),
            }



class CabidoForm(modelsCabido.getBaseCabidoForm(Cabido)):
    nome = forms.CharField(label=(u'Nome'), max_length=255, initial=_(u'Cabido da Diocese ')+diocese_nome, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    presidente = forms.CharField(label=_(u'Presidente'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    vice_presidente = forms.CharField(label=_(u'Vice-Presidente'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    secretario = forms.CharField(label=_(u'Secretário'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    dignidades = forms.CharField(label=_(u'Dignidades'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    deao = forms.CharField(label=_(u'Deão'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    chantre = forms.CharField(label=_(u'Chantre'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    mestre_escola = forms.CharField(label=_(u'Mestre Escola'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    arcediago = forms.CharField(label=_(u'Arcediago'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    tesoureiro = forms.CharField(label=_(u'Tesoureiro'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    penitenciario = forms.CharField(label=_(u'Penitenciario'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    capitulares = forms.CharField(label=_(u'Capitulares'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    honorarios = forms.CharField(label=_(u'Honorários'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    jubilados = forms.CharField(label=_(u'Jubilados Eméritos'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    beneficiados = forms.CharField(label=_(u'Beneficiados'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    arquivo_capitular = forms.CharField(label=_(u'Arquivo capitular'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))





class ConselhoPastoralForm(modelsConselhoPastoral.getBaseConselhoPastoralForm(ConselhoPastoral)):
    nome = forms.CharField(label=_(u'Nome'), max_length=255, required=True, initial=_(u'Conselho Pastoral ')+diocese_nome, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    mandato = forms.CharField(label=_(u'Mandato'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    membros_natos = forms.CharField(label=_(u'Membros Natos'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    membros_designados = forms.CharField(label=_(u'Membros Designados'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    membros_eleitos = forms.CharField(label=_(u'Membros Eleitos'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    comissao_permanente = forms.CharField(label=_(u'Comissão Permanente'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    foto = forms.CharField(label=u'Foto', widget=ElfinderImageWidget, required=False)

    class Meta(modelsConselhoPastoral.getBaseConselhoPastoralForm(ConselhoPastoral).Meta):
        widgets = {
                'fs': forms.widgets.HiddenInput,
                'foto': ElfinderImageWidget(attrs={'a':'a'}),
            }




class ColegioArciprestesForm(modelsColegioArciprestes.getBaseColegioArciprestesForm(ColegioArciprestes)):
    nome = forms.CharField(label=_(u'Nome'), max_length=255, required=True, initial=_(u'Colégio de Arciprestes de ')+diocese_nome, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    colegio_arciprestes = forms.CharField(label=_(u'Colégio de Arciprestes'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    foto = forms.CharField(label=u'Foto', widget=ElfinderImageWidget, required=False)

    class Meta(modelsColegioArciprestes.getBaseColegioArciprestesForm(ColegioArciprestes).Meta):
        widgets = {
                'fs': forms.widgets.HiddenInput,
                'foto': ElfinderImageWidget(attrs={'a':'a'}),
            }




class SecretariadoForm(modelsSecretariado.getBaseSecretariadoForm(Secretariado)):
    nome = forms.CharField(label=_(u'Nome'), max_length=255, required=True, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    morada = forms.CharField(label=_(u'Morada'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    codigo_postal = forms.CharField(label=_(u'Código postal'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    localidade = forms.CharField(label=_(u'Localidade'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telefone = forms.CharField(label=_(u'Telefone'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telemovel = forms.CharField(label=_(u'Telemóvel'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    fax = forms.CharField(label=_(u'Fax'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    email = forms.CharField(label=_(u'Email'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    paginaweb = forms.CharField(label=_(u'Página web'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    director = forms.CharField(label=_(u'Director'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    coordenador = forms.CharField(label=_(u'Coordenador'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    assistente = forms.CharField(label=_(u'Assistente'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    sector_departamento = forms.CharField(label=_(u'Sectores/departamentos'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    foto = forms.CharField(label=u'Foto', widget=ElfinderImageWidget, required=False)

    class Meta(modelsSecretariado.getBaseSecretariadoForm(Secretariado).Meta):
        widgets = {
                'fs': forms.widgets.HiddenInput,
                'foto': ElfinderImageWidget(attrs={'a':'a'}),
            }




class ComissaoForm(modelsComissao.getBaseComissaoForm(Comissao)):
    nome = forms.CharField(label=_(u'Nome'), max_length=255, required=True, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    morada = forms.CharField(label=_(u'Morada'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    codigo_postal = forms.CharField(label=_(u'Código postal'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    localidade = forms.CharField(label=_(u'Localidade'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telefone = forms.CharField(label=_(u'Telefone'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telemovel = forms.CharField(label=_(u'Telemóvel'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    fax = forms.CharField(label=_(u'Fax'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    email = forms.CharField(label=_(u'Email'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    paginaweb = forms.CharField(label=_(u'Página web'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    presidente = forms.CharField(label=_(u'Presidente'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    assistente = forms.CharField(label=_(u'Assistente'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    membros = forms.CharField(label=_(u'Membros'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    sector_departamento = forms.CharField(label=_(u'Sectores/departamentos'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    foto = forms.CharField(label=u'Foto', widget=ElfinderImageWidget, required=False)

    class Meta(modelsComissao.getBaseComissaoForm(Comissao).Meta):
        widgets = {
                'fs': forms.widgets.HiddenInput,
                'foto': ElfinderImageWidget(attrs={'a':'a'}),
            }




class TribunalEclesiasticoForm(modelsTribunalEclesiastico.getBaseTribunalEclesiasticoForm(TribunalEclesiastico)):
    nome = forms.CharField(label=_(u'Nome'), max_length=255, required=True, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    morada = forms.CharField(label=_(u'Morada'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    codigo_postal = forms.CharField(label=_(u'Código postal'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    localidade = forms.CharField(label=_(u'Localidade'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telefone = forms.CharField(label=_(u'Telefone'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telemovel = forms.CharField(label=_(u'Telemóvel'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    fax = forms.CharField(label=_(u'Fax'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    email = forms.CharField(label=_(u'Email'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    paginaweb = forms.CharField(label=_(u'Página web'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    vigario_judicial = forms.CharField(label=_(u'Vigário Judicial'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    vigariojudicialad = forms.CharField(label=_(u'Vigário Judicial Adjunto'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    juizes_diocesanos = forms.CharField(label=_(u'Juizes Diocesanos'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    auditores = forms.CharField(label=_(u'Auditores'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    promotor_justica = forms.CharField(label=_(u'Promotor da Justiça'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    defensor_vinculo = forms.CharField(label=_(u'Defensor do Vínculo'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    notario_actuario = forms.CharField(label=_(u'Notário actuario'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    advogados_oficio = forms.CharField(label=_(u'Advogados ofício'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    meirinho = forms.CharField(label=_(u'Meirinho'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    obs = forms.CharField(label=_(u'Observações'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    foto = forms.CharField(label=u'Foto', widget=ElfinderImageWidget, required=False)

    class Meta(modelsTribunalEclesiastico.getBaseTribunalEclesiasticoForm(TribunalEclesiastico).Meta):
        widgets = {
                'fs': forms.widgets.HiddenInput,
                'foto': ElfinderImageWidget(attrs={'a':'a'}),
            }




class SeminarioForm(modelsSeminario.getBaseSeminarioForm(Seminario)):
    nome = forms.CharField(label=_(u'Nome'), max_length=255, required=True, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    morada = forms.CharField(label=_(u'Morada'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    codigo_postal = forms.CharField(label=_(u'Código postal'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    localidade = forms.CharField(label=_(u'Localidade'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telefone = forms.CharField(label=_(u'Telefone'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telemovel = forms.CharField(label=_(u'Telemóvel'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    fax = forms.CharField(label=_(u'Fax'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    email = forms.CharField(label=_(u'Email'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    paginaweb = forms.CharField(label=_(u'Página web'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    reitor = forms.CharField(label=_(u'Reitor'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    vice_reitor = forms.CharField(label=_(u'Vice-Reitor'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    prefeito = forms.CharField(label=_(u'Prefeito'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    secretario = forms.CharField(label=_(u'Secretário'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    confessor = forms.CharField(label=_(u'Confessor'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    director_espiritual = forms.CharField(label=_(u'Director Espiritual'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    tesoureiro = forms.CharField(label=_(u'Tesoureiro'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    economo = forms.CharField(label=_(u'Ecónomo'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    equipa_resp = forms.CharField(label=_(u'Equipa Responsável'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    obs = forms.CharField(label=_(u'Obervações'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    foto = forms.CharField(label=u'Foto', widget=ElfinderImageWidget, required=False)

    class Meta(modelsSeminario.getBaseSeminarioForm(Seminario).Meta):
        widgets = {
                'fs': forms.widgets.HiddenInput,
                'foto': ElfinderImageWidget(attrs={'a':'a'}),
            }





class DiaconadoPermanenteForm(modelsDiaconadoPermanente.getBaseDiaconadoPermanenteForm(DiaconadoPermanente)):
    nome = forms.CharField(label=_(u'Nome'), max_length=255, required=True, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    morada = forms.CharField(label=_(u'Morada'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    codigo_postal = forms.CharField(label=_(u'Código postal'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    localidade = forms.CharField(label=_(u'Localidade'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telefone = forms.CharField(label=_(u'Telefone'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telemovel = forms.CharField(label=_(u'Telemóvel'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    fax = forms.CharField(label=_(u'Fax'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    email = forms.CharField(label=_(u'Email'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    paginaweb = forms.CharField(label=_(u'Página web'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    seleccao_formacao = forms.CharField(label=_(u'Serviço de selecção e formação'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    delegado = forms.CharField(label=_(u'Delegado/Coordenador'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    foto = forms.CharField(label=u'Foto', widget=ElfinderImageWidget, required=False)

    class Meta(modelsDiaconadoPermanente.getBaseDiaconadoPermanenteForm(DiaconadoPermanente).Meta):
        widgets = {
                'fs': forms.widgets.HiddenInput,
                'foto': ElfinderImageWidget(attrs={'a':'a'}),
            }




class FormacaoAgentePastoralForm(modelsFormacaoAgentePastoral.getBaseFormacaoAgentePastoralForm(FormacaoAgentePastoral)):
    nome = forms.CharField(label=_(u'Nome'), max_length=255, required=True, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    director = forms.CharField(label=_(u'Director'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    propriedade = forms.CharField(label=_(u'Propriedade'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    morada = forms.CharField(label=_(u'Morada'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    codigo_postal = forms.CharField(label=_(u'Código postal'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    localidade = forms.CharField(label=_(u'Localidade'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telefone = forms.CharField(label=_(u'Telefone'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telemovel = forms.CharField(label=_(u'Telemóvel'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    fax = forms.CharField(label=_(u'Fax'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    email = forms.CharField(label=_(u'Email'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    paginaweb = forms.CharField(label=_(u'Página web'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    obs = forms.CharField(label=_(u'Observações'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    foto = forms.CharField(label=u'Foto', widget=ElfinderImageWidget, required=False)

    class Meta(modelsFormacaoAgentePastoral.getBaseFormacaoAgentePastoralForm(FormacaoAgentePastoral).Meta):
        widgets = {
                'fs': forms.widgets.HiddenInput,
                'foto': ElfinderImageWidget(attrs={'a':'a'}),
            }




class CentroVidaCristaForm(modelsCentroVidaCrista.getBaseCentroVidaCristaForm(CentroVidaCrista)):
    nome = forms.CharField(label=_(u'Nome'), max_length=255, required=True, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    tipo = forms.ChoiceField(label=_(u'Tipo'), initial=1, required=False, choices=CENTROVIDACRISTA_TIPOS_CHOICES, widget=forms.widgets.Select(attrs={'class':'vTextField fieldEcclesia'}))
    director = forms.CharField(label=_(u'Director/Responsável'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    propriedade = forms.CharField(label=_(u'Propriedade'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    morada = forms.CharField(label=_(u'Morada'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    codigo_postal = forms.CharField(label=_(u'Código postal'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    localidade = forms.CharField(label=_(u'Localidade'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telefone = forms.CharField(label=_(u'Telefone'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telemovel = forms.CharField(label=_(u'Telemóvel'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    fax = forms.CharField(label=_(u'Fax'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    email = forms.CharField(label=_(u'Email'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    paginaweb = forms.CharField(label=_(u'Página web'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    obs = forms.CharField(label=_(u'Observações'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    foto = forms.CharField(label=u'Foto', widget=ElfinderImageWidget, required=False)

    class Meta(modelsCentroVidaCrista.getBaseCentroVidaCristaForm(CentroVidaCrista).Meta):
        widgets = {
                'fs': forms.widgets.HiddenInput,
                'foto': ElfinderImageWidget(attrs={'a':'a'}),
            }



class AssociacaoObraPresbiteroForm(modelsAssociacaoObraPresbitero.getBaseAssociacaoObraPresbiteroForm(AssociacaoObraPresbitero)):
    nome = forms.CharField(label=_(u'Nome'), max_length=255, required=True, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    director = forms.CharField(label=_(u'Director/Direcção'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    morada = forms.CharField(label=_(u'Morada'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    codigo_postal = forms.CharField(label=_(u'Código postal'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    localidade = forms.CharField(label=_(u'Localidade'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telefone = forms.CharField(label=_(u'Telefone'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telemovel = forms.CharField(label=_(u'Telemóvel'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    fax = forms.CharField(label=_(u'Fax'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    email = forms.CharField(label=_(u'Email'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    paginaweb = forms.CharField(label=_(u'Página web'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    obs = forms.CharField(label=_(u'Observações'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    foto = forms.CharField(label=u'Foto', widget=ElfinderImageWidget, required=False)

    class Meta(modelsAssociacaoObraPresbitero.getBaseAssociacaoObraPresbiteroForm(AssociacaoObraPresbitero).Meta):
        widgets = {
                'fs': forms.widgets.HiddenInput,
                'foto': ElfinderImageWidget(attrs={'a':'a'}),
            }




class PrelaturaPessoalForm(modelsPrelaturaPessoal.getBasePrelaturaPessoalForm(PrelaturaPessoal)):
    nome = forms.CharField(label=_(u'Nome'), max_length=255, required=True, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    congregacao_id = forms.ChoiceField(label=_(u'Congregação'), required=False, initial=None, choices=PRELATURAPESSOAL_CONGREGACOES_CHOICES, widget=forms.widgets.Select(attrs={'class':'fieldEcclesia'}))
    comunidade = forms.CharField(label=_(u'Casa/comunidade'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    superiora = forms.CharField(label=_(u'Superiora'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    membros = forms.CharField(label=_(u'Membros da Comunidade'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    morada = forms.CharField(label=_(u'Morada'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    codigo_postal = forms.CharField(label=_(u'Código postal'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    localidade = forms.CharField(label=_(u'Localidade'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telefone = forms.CharField(label=_(u'Telefone'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telemovel = forms.CharField(label=_(u'Telemóvel'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    fax = forms.CharField(label=_(u'Fax'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    email = forms.CharField(label=_(u'Email'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    paginaweb = forms.CharField(label=_(u'Página web'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    foto = forms.CharField(label=u'Foto', widget=ElfinderImageWidget, required=False)

    class Meta(modelsPrelaturaPessoal.getBasePrelaturaPessoalForm(PrelaturaPessoal).Meta):
        widgets = {
                'fs': forms.widgets.HiddenInput,
                'foto': ElfinderImageWidget(attrs={'a':'a'}),
            }

    def clean(self):
        cleaned_data = super(PrelaturaPessoalForm, self).clean()
        field = cleaned_data.get("congregacao_id")
        if field=='':
            self.cleaned_data['congregacao_id']=None
        return cleaned_data




class InstitutoReligiosoFemininoForm(modelsInstitutoReligiosoFeminino.getBaseInstitutoReligiosoFemininoForm(InstitutoReligiosoFeminino)):
    nome = forms.CharField(label=_(u'Nome'), max_length=255, required=True, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    congregacao_id = forms.ChoiceField(label=_(u'Congregação'), required=False, initial='', choices=INSTITUTORELIGIOSOFEMININO_CONGREGACOES_CHOICES, widget=forms.widgets.Select(attrs={'class':'fieldEcclesia'}))
    comunidade = forms.CharField(label=_(u'Casa/comunidade'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    superiora = forms.CharField(label=_(u'Superiora'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    membros = forms.CharField(label=_(u'Membros da Comunidade'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    morada = forms.CharField(label=_(u'Morada'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    codigo_postal = forms.CharField(label=_(u'Código postal'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    localidade = forms.CharField(label=_(u'Localidade'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telefone = forms.CharField(label=_(u'Telefone'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telemovel = forms.CharField(label=_(u'Telemóvel'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    fax = forms.CharField(label=_(u'Fax'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    email = forms.CharField(label=_(u'Email'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    paginaweb = forms.CharField(label=_(u'Página web'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    foto = forms.CharField(label=u'Foto', widget=ElfinderImageWidget, required=False)

    class Meta(modelsInstitutoReligiosoFeminino.getBaseInstitutoReligiosoFemininoForm(InstitutoReligiosoFeminino).Meta):
        widgets = {
                'fs': forms.widgets.HiddenInput,
                'foto': ElfinderImageWidget(attrs={'a':'a'}),
            }

    def clean(self):
        cleaned_data = super(InstitutoReligiosoFemininoForm, self).clean()
        field = cleaned_data.get("congregacao_id")
        if field=='':
            self.cleaned_data['congregacao_id']=None
        return cleaned_data





class InstitutoReligiosoMasculinoForm(modelsInstitutoReligiosoMasculino.getBaseInstitutoReligiosoMasculinoForm(InstitutoReligiosoMasculino)):
    nome = forms.CharField(label=_(u'Nome'), max_length=255, required=True, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    congregacao_id = forms.ChoiceField(label=_(u'Congregação'), required=False, initial='', choices=INSTITUTORELIGIOSOMASCULINO_CONGREGACOES_CHOICES, widget=forms.widgets.Select(attrs={'class':'fieldEcclesia'}))
    comunidade = forms.CharField(label=_(u'Casa/comunidade'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    superior = forms.CharField(label=_(u'Superior'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    membros = forms.CharField(label=_(u'Membros da Comunidade'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    morada = forms.CharField(label=_(u'Morada'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    codigo_postal = forms.CharField(label=_(u'Código postal'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    localidade = forms.CharField(label=_(u'Localidade'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telefone = forms.CharField(label=_(u'Telefone'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telemovel = forms.CharField(label=_(u'Telemóvel'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    fax = forms.CharField(label=_(u'Fax'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    email = forms.CharField(label=_(u'Email'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    paginaweb = forms.CharField(label=_(u'Página web'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    foto = forms.CharField(label=u'Foto', widget=ElfinderImageWidget, required=False)

    class Meta(modelsInstitutoReligiosoMasculino.getBaseInstitutoReligiosoMasculinoForm(InstitutoReligiosoMasculino).Meta):
        widgets = {
                'fs': forms.widgets.HiddenInput,
                'foto': ElfinderImageWidget(attrs={'a':'a'}),
            }

    def clean(self):
        cleaned_data = super(InstitutoReligiosoMasculinoForm, self).clean()
        field = cleaned_data.get("congregacao_id")
        if field=='':
            self.cleaned_data['congregacao_id']=None
        return cleaned_data




class InstitutoSecularForm(modelsInstitutoSecular.getBaseInstitutoSecularForm(InstitutoSecular)):
    nome = forms.CharField(label=_(u'Nome'), max_length=255, required=True, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    instituto_secular_n_id = forms.ChoiceField(label=_(u'Instituto Secular'), required=False, initial='', choices=INSTITUTOSECLARES_INSTITUTOS_CHOICES, widget=forms.widgets.Select(attrs={'class':'fieldEcclesia'}))
    comunidade = forms.CharField(label=_(u'Casa/comunidade'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    director = forms.CharField(label=_(u'Responsável/ Director'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    morada = forms.CharField(label=_(u'Morada'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    codigo_postal = forms.CharField(label=_(u'Código postal'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    localidade = forms.CharField(label=_(u'Localidade'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telefone = forms.CharField(label=_(u'Telefone'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telemovel = forms.CharField(label=_(u'Telemóvel'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    fax = forms.CharField(label=_(u'Fax'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    email = forms.CharField(label=_(u'Email'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    paginaweb = forms.CharField(label=_(u'Página web'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    obs = forms.CharField(label=_(u'Observações'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    foto = forms.CharField(label=u'Foto', widget=ElfinderImageWidget, required=False)

    class Meta(modelsInstitutoSecular.getBaseInstitutoSecularForm(InstitutoSecular).Meta):
        widgets = {
                'fs': forms.widgets.HiddenInput,
                'foto': ElfinderImageWidget(attrs={'a':'a'}),
            }

    def clean(self):
        cleaned_data = super(InstitutoSecularForm, self).clean()
        field = cleaned_data.get("instituto_secular_n_id")
        if field=='':
            self.cleaned_data['instituto_secular_n_id']=None
        return cleaned_data



class SociedadeVidaApostolicaForm(modelsSociedadeVidaApostolica.getBaseSociedadeVidaApostolicaForm(SociedadeVidaApostolica)):
    nome = forms.CharField(label=_(u'Nome'), max_length=255, required=True, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    director = forms.CharField(label=_(u'Responsável/ Director'), max_length=255,  required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    morada = forms.CharField(label=_(u'Morada'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    codigo_postal = forms.CharField(label=_(u'Código postal'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    localidade = forms.CharField(label=_(u'Localidade'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telefone = forms.CharField(label=_(u'Telefone'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telemovel = forms.CharField(label=_(u'Telemóvel'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    fax = forms.CharField(label=_(u'Fax'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    email = forms.CharField(label=_(u'Email'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    paginaweb = forms.CharField(label=_(u'Página web'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    foto = forms.CharField(label=u'Foto', widget=ElfinderImageWidget, required=False)

    class Meta(modelsSociedadeVidaApostolica.getBaseSociedadeVidaApostolicaForm(SociedadeVidaApostolica).Meta):
        widgets = {
                'fs': forms.widgets.HiddenInput,
                'foto': ElfinderImageWidget(attrs={'a':'a'}),
            }



class AssociacaoMovimentoObraForm(modelsAssociacaoMovimentoObra.getBaseAssociacaoMovimentoObraForm(AssociacaoMovimentoObra)):
    nome = forms.CharField(label=_(u'Nome'), max_length=255, required=True, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    presidente = forms.CharField(label=_(u'Presidente/ Coordenador'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    assistente = forms.CharField(label=_(u'Assistente'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    morada = forms.CharField(label=_(u'Morada'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    codigo_postal = forms.CharField(label=_(u'Código postal'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    localidade = forms.CharField(label=_(u'Localidade'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telefone = forms.CharField(label=_(u'Telefone'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telemovel = forms.CharField(label=_(u'Telemóvel'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    fax = forms.CharField(label=_(u'Fax'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    email = forms.CharField(label=_(u'Email'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    paginaweb = forms.CharField(label=_(u'Página web'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    foto = forms.CharField(label=u'Foto', widget=ElfinderImageWidget, required=False)

    class Meta(modelsAssociacaoMovimentoObra.getBaseAssociacaoMovimentoObraForm(AssociacaoMovimentoObra).Meta):
        widgets = {
                'fs': forms.widgets.HiddenInput,
                'foto': ElfinderImageWidget(attrs={'a':'a'}),
            }





class CentroAnimacaoEspiritualForm(modelsCentroAnimacaoEspiritual.getBaseCentroAnimacaoEspiritualForm(CentroAnimacaoEspiritual)):
    nome = forms.CharField(label=_(u'Nome'), max_length=255, required=True, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    director = forms.CharField(label=_(u'Responsável/ Director'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    propiedade = forms.CharField(label=_(u'Propriedade'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    morada = forms.CharField(label=_(u'Morada'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    codigo_postal = forms.CharField(label=_(u'Código postal'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    localidade = forms.CharField(label=_(u'Localidade'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telefone = forms.CharField(label=_(u'Telefone'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telemovel = forms.CharField(label=_(u'Telemóvel'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    fax = forms.CharField(label=_(u'Fax'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    email = forms.CharField(label=_(u'Email'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    paginaweb = forms.CharField(label=_(u'Página web'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    obs = forms.CharField(label=_(u'Observações'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    foto = forms.CharField(label=u'Foto', widget=ElfinderImageWidget, required=False)

    class Meta(modelsCentroAnimacaoEspiritual.getBaseCentroAnimacaoEspiritualForm(CentroAnimacaoEspiritual).Meta):
        widgets = {
                'fs': forms.widgets.HiddenInput,
                'foto': ElfinderImageWidget(attrs={'a':'a'}),
            }




class ObraAccaoSocioCaritativaForm(modelsObraAccaoSocioCaritativa.getBaseObraAccaoSocioCaritativaForm(ObraAccaoSocioCaritativa, OBRAACAOCARITATIVA_VALENCIAS_CHOICES)):
    nome = forms.CharField(label=_(u'Nome'), max_length=255, required=True, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    tipo = forms.ChoiceField(label=_(u'Valências'), required=False, initial=15, choices=OBRAACAOCARITATIVA_VALENCIAS_CHOICES, widget=forms.widgets.Select(attrs={'class':'fieldEcclesia'}))
    multipo_id = forms.ModelMultipleChoiceField(label=_(u'para instituições com várias valências'), queryset=Valencias.objects.all(), required=False, widget=forms.widgets.SelectMultiple(attrs={'class':'vTextField fieldEcclesia'}))
    propriedade = forms.CharField(label=_(u'Propriedade'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    responsavel = forms.CharField(label=_(u'Responsável/Director'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    morada = forms.CharField(label=_(u'Morada'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    codigo_postal = forms.CharField(label=_(u'Código postal'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    localidade = forms.CharField(label=_(u'Localidade'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telefone = forms.CharField(label=_(u'Telefone'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telemovel = forms.CharField(label=_(u'Telemóvel'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    fax = forms.CharField(label=_(u'Fax'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    email = forms.CharField(label=_(u'Email'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    paginaweb = forms.CharField(label=_(u'Página web'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    obs = forms.CharField(label=_(u'Observações'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    foto = forms.CharField(label=u'Foto', widget=ElfinderImageWidget, required=False)

    class Meta(modelsObraAccaoSocioCaritativa.getBaseObraAccaoSocioCaritativaForm(ObraAccaoSocioCaritativa, OBRAACAOCARITATIVA_VALENCIAS_CHOICES).Meta):
        widgets = {
                'fs': forms.widgets.HiddenInput,
                'foto': ElfinderImageWidget(attrs={'a':'a'}),
            }

    def clean(self):
        cleaned_data = super(ObraAccaoSocioCaritativaForm, self).clean()
        field = cleaned_data.get("tipo")
        if field=='':
            self.cleaned_data['tipo']=None
        return cleaned_data




class EscolaCatolicaForm(modelsEscolaCatolica.getBaseEscolaCatolicaForm(EscolaCatolica)):
    nome = forms.CharField(label=_(u'Nome'), max_length=255, required=True, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    escolaridade = forms.CharField(label=_(u'Escolaridade'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    propriedade = forms.CharField(label=_(u'Propriedade'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    director = forms.CharField(label=_(u'Director/responsavel'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    morada = forms.CharField(label=_(u'Morada'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    codigo_postal = forms.CharField(label=_(u'Código postal'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    localidade = forms.CharField(label=_(u'Localidade'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telefone = forms.CharField(label=_(u'Telefone'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telemovel = forms.CharField(label=_(u'Telemóvel'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    fax = forms.CharField(label=_(u'Fax'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    email = forms.CharField(label=_(u'Email'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    paginaweb = forms.CharField(label=_(u'Página web'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    foto = forms.CharField(label=u'Foto', widget=ElfinderImageWidget, required=False)

    class Meta(modelsEscolaCatolica.getBaseEscolaCatolicaForm(EscolaCatolica).Meta):
        widgets = {
                'fs': forms.widgets.HiddenInput,
                'foto': ElfinderImageWidget(attrs={'a':'a'}),
            }







class ComunicacaoSocialForm(modelsComunicacaoSocial.getBaseComunicacaoSocialForm(ComunicacaoSocial)):
    nome = forms.CharField(label=_(u'Nome'), max_length=255, required=True, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    tipo = forms.ChoiceField(label=_(u'Tipo'), initial='', required=False, choices=COMUNICACAOSOCIAL_TIPOS_CHOICES, widget=forms.widgets.Select(attrs={'class':'fieldEcclesia'}))
    periocidade = forms.ChoiceField(label=_(u'Periodicidade'), initial='', required=False, choices=COMUNICACAOSOCIAL_PERIOCIDADES_CHOICES, widget=forms.widgets.Select(attrs={'class':'fieldEcclesia'}))
    director = forms.CharField(label=_(u'Director'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    propriedade = forms.CharField(label=_(u'Propriedade'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    morada = forms.CharField(label=_(u'Morada'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    codigo_postal = forms.CharField(label=_(u'Código postal'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    localidade = forms.CharField(label=_(u'Localidade'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telefone = forms.CharField(label=_(u'Telefone'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telemovel = forms.CharField(label=_(u'Telemóvel'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    fax = forms.CharField(label=_(u'Fax'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    email = forms.CharField(label=_(u'Email'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    paginaweb = forms.CharField(label=_(u'Página web'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    obs = forms.CharField(label=_(u'Observações'), required=False, widget=forms.widgets.Textarea(attrs={'class':'vLargeTextField fieldEcclesia', 'cols':40, 'rows':10}))
    foto = forms.CharField(label=u'Foto', widget=ElfinderImageWidget, required=False)

    class Meta(modelsComunicacaoSocial.getBaseComunicacaoSocialForm(ComunicacaoSocial).Meta):
        widgets = {
                'fs': forms.widgets.HiddenInput,
                'foto': ElfinderImageWidget(attrs={'a':'a'}),
            }

    def clean(self):
        cleaned_data = super(ComunicacaoSocialForm, self).clean()
        field = cleaned_data.get("tipo")
        if field=='':
            self.cleaned_data['tipo']=None
        field = cleaned_data.get("periocidade")
        if field=='':
            self.cleaned_data['periocidade']=None
        return cleaned_data





class ParoquiaForm(modelsParoquia.getBaseParoquiaForm(Paroquia)):
    nome = forms.CharField(label=_(u'Nome'), max_length=255, required=True, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    morada = forms.CharField(label=_(u'Morada'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    codigo_postal = forms.CharField(label=_(u'Código postal'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    localidade = forms.CharField(label=_(u'Localidade'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telefone = forms.CharField(label=_(u'Telefone'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    telemovel = forms.CharField(label=_(u'Telemóvel'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    fax = forms.CharField(label=_(u'Fax'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    email = forms.CharField(label=_(u'Email'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    paginaweb = forms.CharField(label=_(u'Página web'), max_length=255, required=False, widget=forms.widgets.TextInput(attrs={'class':'vTextField fieldEcclesia'}))
    arciprestado = forms.ModelChoiceField(label=_(u'Arciprestado'), queryset=Arciprestado.objects.all(), required=False, widget=forms.widgets.Select(attrs={'class':'fieldEcclesia'}))
    orago = forms.ChoiceField(label=_(u'Orago'), initial='', required=False, choices=PAROQUIA_ORAGOS_CHOICES, widget=forms.widgets.Select(attrs={'class':'fieldEcclesia'}))
    padre1 = forms.ModelChoiceField(label=_(u'Padre 1'), queryset=Presbitero.objects.all(), required=False, widget=forms.widgets.Select(attrs={'class':'fieldEcclesia'}))
    padre2 = forms.ModelChoiceField(label=_(u'Padre 2'), queryset=Presbitero.objects.all(), required=False, widget=forms.widgets.Select(attrs={'class':'fieldEcclesia'}))
    padre3 = forms.ModelChoiceField(label=_(u'Padre 3'), queryset=Presbitero.objects.all(), required=False, widget=forms.widgets.Select(attrs={'class':'fieldEcclesia'}))
    foto = models.CharField(_(u'Foto'), max_length=255, null=True, blank=True)

    class Meta(modelsParoquia.getBaseParoquiaForm(Paroquia).Meta):
        widgets = {
                'fs': forms.widgets.HiddenInput,
                'foto': ElfinderImageWidget(attrs={'a':'a'}),
            }

    def clean(self):
        cleaned_data = super(ParoquiaForm, self).clean()
        field = cleaned_data.get("orago")
        if field=='':
            self.cleaned_data['orago']=None
        return cleaned_data

























class PresbiteroArciprestadoInline(admin.TabularInline):
    extra = 0
    model = PresbiteroArciprestado


class DiaconoPermanenteArciprestadoInline(admin.TabularInline):
    extra = 0
    model = DiaconoPermanenteArciprestado


class BispoArciprestadoInline(admin.TabularInline):
    extra = 0
    model = BispoArciprestado


class DiaconoArciprestadoInline(admin.TabularInline):
    extra = 0
    model = DiaconoArciprestado




class DiaconoRetirosInline(admin.TabularInline):
    extra = 0
    model = DiaconoRetiros

class DiaconoParoquiasInline(admin.TabularInline):
    extra = 0
    model = DiaconoParoquias

class DiaconoForm(forms.ModelForm):
    foto = forms.CharField(label=u'Foto', widget=ElfinderImageWidget, required=False)

    class Meta:
        model = Diacono
        widgets = {
                'fs': forms.widgets.HiddenInput,
                'foto': ElfinderImageWidget(attrs={'a':'a'}),
            }









class OutraInstituicaoForm(forms.ModelForm):
    foto = forms.CharField(label=u'Foto', widget=ElfinderImageWidget, required=False)

    class Meta:
        model = OutraInstituicao
        widgets = {
                'fs': forms.widgets.HiddenInput,
                'foto': ElfinderImageWidget(attrs={'a':'a'}),
            }
