# -*- coding: utf-8 *-*
MY_APP = 'dbraga'
import os
import djcelery
djcelery.setup_loader()

PATH = os.path.realpath(os.path.dirname(__file__) + '/../') + '/'

PID_PATH = '/tmp'
PID_LIFETIME = 30 #minutes
CRONTAB_PYTHON_EXECUTABLE = os.path.realpath(PATH + '../venv/bin/python')
CRONJOBS = [
    ('*/10 * * * *', 'newsletter.cron.add_queue'),
	('*/10 * * * *', 'newsletter.cron.dispatch_queue'),
    ('*/10 * * * *', 'sms_email.cron.add_queue'),
	('*/10 * * * *', 'sms_email.cron.dispatch_queue')

]

#CONSTANCE_BACKEND = constance.backends.database.DatabaseBackend
#CONSTANCE_DATABASE_CACHE_BACKEND = 'memcached://127.0.0.1:11211/'

"""
Para o celery funcionar:
    rabbitmq-server > tem de funcionar como daemon
    ./manage.py celeryd -B

    ./manage.py celery worker > tem de funcionar como daemon
    ./manage.py shell :
        from newsletter.models import Newsletter
        Newsletter().handler('add_queue')
        Newsletter().handler('dispatch_queue')
"""

BROKER_URL = 'librabbitmq://dbraga:dbraga@localhost:5672/dbraga'
BROKER_POOL_LIMIT = 1
CELERY_ACKS_LATE = True
CELERYD_PREFETCH_MULTIPLIER = 1
CELERYD_CONCURRENCY = 1

RECAPTCHA_PUBLIC_KEY = '6LfsHdMSAAAAAIuhBoI2Rmyjh-F32yCkd63xreQq'
RECAPTCHA_PRIVATE_KEY = '6LfsHdMSAAAAAJd6Ig1UH6nbktR8k9-9au2bZye1'

SIM4_CONN = ('localhost', 'peakit_diocese', 'dios2006', 'peakit_diocese')

EMAIL_HOST = 'mail.diocese-braga.pt'
EMAIL_PORT = '25'
EMAIL_HOST_USER = 'site@diocese-braga.pt'
EMAIL_HOST_PASSWORD = 'ola123'
EMAIL_USE_TLS = False

EMAIL_FROM = 'diocese@diocese-braga.pt'
SITE_URL = 'http://diocese-braga.pt/'

THUMBNAIL_DEBUG = False
THUMBNAIL_KVSTORE = 'sorl.thumbnail.kvstores.cached_db_kvstore.KVStore'
THUMBNAIL_ENGINE = 'sorl.thumbnail.engines.pil_engine.Engine'
THUMBNAIL_PREFIX = 'miniaturas/'

#TINYMCE_DEFAULT_CONFIG = {'theme': "advanced", 'relative_urls': True}

REDACTOR_OPTIONS = {
    'lang': 'pt_br',
    'plugins': ['fullscreen']
}

#HAYSTACK_SITECONF = 'conteudos.search_indexes'
#HAYSTACK_SEARCH_ENGINE = 'whoosh'
#HAYSTACK_WHOOSH_PATH = os.path.join(PATH, '../', 'whoosh_index')
HAYSTACK_CONNECTIONS = {
    'default': {
        'ENGINE': 'haystack.backends.solr_backend.SolrEngine',
        'URL': 'http://127.0.0.1:7872/solr/diocese-braga'        
        #'ENGINE': 'haystack.backends.whoosh_backend.WhooshEngine',
        #'PATH': os.path.join(PATH, '../', 'whoosh_index')
    },
}

HASYTACK_SEARCH_INDEX_TIMER = '60'

INTERNAL_IPS = ('127.0.0.1',)

NEWSLETTER_FROM_EMAIL = 'geral@diocese-braga.pt'
# Default 500
NEWSLETTER_MAX_TO_DISPATCH = 50
# Add to queue every x minutes, default 1
NEWSLETTER_QUEUE_EVERY = '1'
# Dispatch queue every x minutes, default 1
NEWSLETTER_DISPATCH_EVERY = '1'

ADMIN_TOOLS_MENU = 'menu.CustomMenu'
ADMIN_TOOLS_INDEX_DASHBOARD = 'dashboard.CustomIndexDashboard'
ADMIN_TOOLS_APP_INDEX_DASHBOARD = 'dashboard.CustomAppIndexDashboard'

GOOGLE_ANALYTICS_PROPERTY_ID = 'UA-546688-3'

SESSION_COOKIE_DOMAIN_COOKIE = 'diocese-braga.pt'
#SESSION_COOKIE_SECURE=False


def custom_show_toolbar(request):
    return True  # Always show toolbar, for example purposes only.

DEBUG_TOOLBAR_CONFIG = {
    'INTERCEPT_REDIRECTS': False,
    'SHOW_TOOLBAR_CALLBACK': custom_show_toolbar,
    'HIDE_DJANGO_SQL': False,
    'TAG': 'body',
    'ENABLE_STACKTRACES': True,
}

DEBUG_TOOLBAR_PANELS = (
    'debug_toolbar.panels.version.VersionDebugPanel',
    'debug_toolbar.panels.timer.TimerDebugPanel',
    'debug_toolbar.panels.settings_vars.SettingsVarsDebugPanel',
    'debug_toolbar.panels.headers.HeaderDebugPanel',
    'debug_toolbar.panels.request_vars.RequestVarsDebugPanel',
    'debug_toolbar.panels.template.TemplateDebugPanel',
    'debug_toolbar.panels.sql.SQLDebugPanel',
    'debug_toolbar.panels.signals.SignalDebugPanel',
    'debug_toolbar.panels.logger.LoggingPanel',
)

#DIOCESE_ECCLESIA='Braga'
DIOCESE_NOME = 'Braga'

DEBUG = str(os.getenv('PKT_DEBUG', '')) == '1'
TEMPLATE_DEBUG = DEBUG

ADMINS = (
     ('Ruben Rodrigues', 'ruben.rodrigues@peakit.pt'),
)

MANAGERS = ADMINS

DATABASES = {
    'default': {
        # Add 'postgresql_psycopg2', 'mysql', 'sqlite3' or 'oracle'.
        'ENGINE': 'django.db.backends.mysql',
        'NAME': 'dbraga_sim',
        'USER': 'dbraga_sim',
        'PASSWORD': 'dbraga0812',
        'HOST': '',
        'PORT': '',
        'OPTIONS': {
           'init_command': 'SET storage_engine=INNODB',
        }
    }
}

# http://en.wikipedia.org/wiki/List_of_tz_zones_by_name
TIME_ZONE = 'Europe/Lisbon'

# http://www.i18nguy.com/unicode/language-identifiers.html
LANGUAGE_CODE = 'pt-pt'

SITE_ID = 1



USE_I18N = True

USE_L10N = True

USE_TZ = False

# Example: "/home/media/media.lawrence.com/media/"
MEDIA_ROOT = PATH + 'media/'

# Examples: "http://media.lawrence.com/media/", "http://example.com/media/"
MEDIA_URL = '/media/'

# Example: "/home/media/media.lawrence.com/static/"
STATIC_ROOT = PATH + 'static/'

# Example: "http://media.lawrence.com/static/"
STATIC_URL = '/static/'

# Additional locations of static files
STATICFILES_DIRS = (
    # Put strings here, like "/home/html/static" or "C:/www/django/static".
    PATH + 'static_admin/',
#    PATH+'../site/static/',
)

# List of finder classes that knowhow to find staticfiles in various locations.
STATICFILES_FINDERS = (
    'django.contrib.staticfiles.finders.FileSystemFinder',
    'django.contrib.staticfiles.finders.AppDirectoriesFinder',
#    'django.contrib.staticfiles.finders.DefaultStorageFinder',
)

# Make this unique, and don't share it with anybody.
SECRET_KEY = 'w!84gr5_ew-=v*6o8d^z%%$&amp;e)uyyz!pcn^+*r-mf&amp;pz=a!tjb'

# List of callables that know how to import templates from various sources.
TEMPLATE_LOADERS = (
    'django.template.loaders.filesystem.Loader',
    'django.template.loaders.app_directories.Loader',
#     'django.template.loaders.eggs.Loader',
)

MIDDLEWARE_CLASSES = ()

if DEBUG:
    MIDDLEWARE_CLASSES += (
    'debug_toolbar.middleware.DebugToolbarMiddleware',
    )

MIDDLEWARE_CLASSES += (
    'django.middleware.common.CommonMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    # Uncomment the next line for simple clickjacking protection:
    # 'django.middleware.clickjacking.XFrameOptionsMiddleware',

)


ROOT_URLCONF = MY_APP + '.urls'

# Python dotted path to the WSGI application used by Django's runserver.
WSGI_APPLICATION = MY_APP + '.wsgi.application'

TEMPLATE_CONTEXT_PROCESSORS = (
    'django.contrib.auth.context_processors.auth',
    'django.core.context_processors.debug',
    'django.core.context_processors.i18n',
    'django.core.context_processors.media',
    'django.core.context_processors.static',
    'django.contrib.messages.context_processors.messages',
    # required by django-admin-tools
    'django.core.context_processors.request',
    'dbraga.context_processors_siteconfig.siteconfig',
)

TEMPLATE_DIRS = (
    # Don't forget to use absolute paths, not relative paths.
    PATH + 'templates/',
    #PATH+'site/templates/',
)

GRAPPELLI_INDEX_DASHBOARD = 'dashboard.CustomIndexDashboard'

DJANGO_APPS = (
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.sites',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'django.contrib.sitemaps',
)

THIRD_PARTY_APPS = {
    'before_django_apps': (
        ##'grappelli.dashboard',
        #'grappelli',

        'admin_tools',
        #'admin_tools.theming',
        'admin_tools.menu',
        'admin_tools.dashboard',
        'django.contrib.admin',
    ),
    'after_peakit_apps': (
        'tinymce',
        'mptt',
        'feincms',
        'elfinder',
        'inline_ordering',
        'haystack',
        'analytics',
        'analytical',
        'sorl.thumbnail',
        'captcha',
        'south',
        'redactor',

        'djcelery',
        'tastypie',
        'reportlab',
	'django_crontab'
    )
}

if DEBUG:
    THIRD_PARTY_APPS['after_peakit_apps'] += (
    'debug_toolbar',
    )

PEAKIT_APPS = (
    'extensions',
    'diocese',
    'myadmin',
    'conteudos',
    'newsletter',
    'sms_email',
    'horario',
    'agenda',
    'sitemenu',
    'website',
)

INSTALLED_APPS = THIRD_PARTY_APPS['before_django_apps'] + DJANGO_APPS
INSTALLED_APPS += PEAKIT_APPS + THIRD_PARTY_APPS['after_peakit_apps']

# A sample logging configuration. The only tangible logging
# performed by this configuration is to send an email to
# the site admins on every HTTP 500 error when DEBUG=False.
# See http://docs.djangoproject.com/en/dev/topics/logging for
# more details on how to customize your logging configuration.
LOGGING = {
    'version': 1,
    'disable_existing_loggers': True,
    'handlers': {
        'mail_admins': {
            'level': 'ERROR',
            'class': 'django.utils.log.AdminEmailHandler'
        },
        'file':{
            'level': 'ERROR',
            'class': 'logging.FileHandler',
            'filename': PATH + 'debug.log',
        }
    },
    'loggers': {
        'django': {
            'handlers':['file'],
            'propagate': True,
            'level':'INFO',
        },
        'django.request': {
            'handlers': ['file'],
            'level': 'ERROR',
            'propagate': True,
        }
    }
}

CACHES = {
    'default': {
        'BACKEND': 'django.core.cache.backends.filebased.FileBasedCache',
        'LOCATION': MEDIA_ROOT + '/django_cache',
    }
}

base_path = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                         "..", "djblets"))

for entry in os.listdir(base_path):
    fullpath = os.path.join(base_path, entry)

    if (os.path.isdir(fullpath) and
        os.path.exists(os.path.join(fullpath, "__init__.py"))):
        INSTALLED_APPS += ("djblets.%s" % entry, )
