#coding: utf-8
from django.db import models
from django.contrib import admin
from django import forms

from elfinder.hooks.ElfinderImageField import ElfinderImageWidget
from tinymce import widgets as tinymce_widgets
from django.utils.translation import ugettext_lazy as _
from datetime import datetime

from peakitcms.models import DEFAULT_FIELDSETS
from peakitcms.manager import CmsDefaultManager

from django.contrib.auth.models import User

from myadmin.admin import MyBaseAdmin, MyBaseForm

from django.db.models import get_model

#from website import models as modelsDbraga

from django.core.cache import cache
from django.db.models.signals import post_save


# Seccao
from peakitcms.conteudos.seccoes import models as modelsSeccao

class Seccao(modelsSeccao.getBaseSeccao()):
    website = models.ForeignKey(get_model('website','WebSite'), verbose_name=_(u'Website'), related_name='conteudoss_seccaos_website', default=1)
    foto = models.CharField(_(u'Foto'), max_length=255, null=True, blank=True)
    objects = models.Manager()
    publicado = CmsDefaultManager()
    #pass


def seccao_save(sender, **args):
    cache.clear()

post_save.connect( seccao_save, sender=Seccao )


class SeccaoForm(MyBaseForm, modelsSeccao.getBaseSeccaoForm(Seccao)):
    foto = forms.CharField(label=u'Foto', widget=ElfinderImageWidget, required=False)
    #pass
    class Meta(modelsSeccao.getBaseSeccaoForm(Seccao).Meta):
        widgets = {
                'fs': forms.widgets.HiddenInput,
                'foto': ElfinderImageWidget(attrs={'a':'a'}),
            }

#seccao_fieldsets = modelsSeccao.getBaseSeccaoAdmin(Seccao).fieldsets
seccao_fieldsets = (
                     #DEFAULT_FIELDSETS['informacao'],
                     #DEFAULT_FIELDSETS['publicacao'],
                     (None, {
                             'fields':(
                                       'title',
                                       'descricao',
                                       'parent',
                                       ('fs','foto')
                                       )
                             }),
                     )

class SeccaoAdmin(MyBaseAdmin, modelsSeccao.getBaseSeccaoAdmin(Seccao)):
    form = SeccaoForm
    fieldsets = seccao_fieldsets

# Fim Seccao


"""
# Audio
from peakitcms.conteudos.audio import models as modelsAudio

class Audio(modelsAudio.getBaseAudio()):
    ficheiro_firefox = models.CharField(max_length=255)
    ficheiro_opera = models.CharField(max_length=255)
    website = models.ForeignKey(get_model('website','WebSite'), verbose_name=_(u'Website'), related_name='%(app_label)s_%(class)s_website', default=1)
    objects = models.Manager()
    publicado = CmsDefaultManager()

class AudioForm(modelsAudio.getBaseAudioForm(Audio)):
    ficheiro = forms.CharField(label=u'Ficheiro m4a', widget=ElfinderImageWidget)
    ficheiro_firefox = forms.CharField(label=u'Ficheiro mp3', widget=ElfinderImageWidget)
    ficheiro_opera = forms.CharField(label=u'Ficheiro ogg', widget=ElfinderImageWidget)

    class Meta(modelsAudio.getBaseAudioForm(Audio).Meta):
        widgets = {
                'fs': forms.widgets.HiddenInput,
                'ficheiro': ElfinderImageWidget(attrs={'a':'a'}),
                'ficheiro_firefox': ElfinderImageWidget(attrs={'a':'a'}),
                'ficheiro_opera': ElfinderImageWidget(attrs={'a':'a'}),
            }

audio_fieldsets = modelsAudio.getBaseAudioAdmin(Audio).fieldsets
audio_fieldsets[2][1]['fields'] = (('titulo', 'fs',),)
audio_fieldsets += ((u'Ficheiros', {'fields':('ficheiro','ficheiro_firefox', 'ficheiro_opera')}),)
class AudioAdmin(MyBaseAdmin, modelsAudio.getBaseAudioAdmin(Audio)):
    form = AudioForm
    fieldsets = audio_fieldsets
# Fim Audio

# Videos
from peakitcms.conteudos.video import models as modelsVideo

class Video(modelsVideo.getBaseVideo()):
    website = models.ForeignKey(get_model('website','WebSite'), verbose_name=_(u'Website'), related_name='%(app_label)s_%(class)s_website', default=1)
    objects = models.Manager()
    publicado = CmsDefaultManager()
    #pass

class VideoForm(modelsVideo.getBaseVideoForm(Video)):
    pass

multimedia_fieldsets = modelsVideo.getBaseVideoAdmin(Video).fieldsets

class VideoAdmin(MyBaseAdmin, modelsVideo.getBaseVideoAdmin(Video)):
    form = VideoForm
    fieldsets = multimedia_fieldsets

# Fim Videos
"""
# Multimedia
from peakitcms.conteudos.multimedia import models as modelsMultimedia

class Multimedia(modelsMultimedia.getBaseMultimedia(Seccao, 'MultimediaSeccao', 'Multimedia', 'MultimediaRelacao')):
    website = models.ForeignKey(get_model('website','WebSite'), verbose_name=_(u'Website'), related_name='conteudoss_multimedias_website', default=1)
    objects = models.Manager()
    publicado = CmsDefaultManager()
    #pass

class MultimediaForm(MyBaseForm, modelsMultimedia.getBaseMultimediaForm(Multimedia)):
    pass

multimedia_fieldsets = modelsMultimedia.getBaseMultimediaAdmin(Multimedia).fieldsets

class MultimediaSeccao(modelsMultimedia.getBaseMultimediaSeccao(Multimedia, Seccao)): pass

class MultimediaRelacao(modelsMultimedia.getBaseMultimediaRelacao(Multimedia, Multimedia)): pass

class MultimediaAdmin(MyBaseAdmin, modelsMultimedia.getBaseMultimediaAdmin(Multimedia)):
    form = MultimediaForm
    fieldsets = multimedia_fieldsets
    inlines = [modelsMultimedia.getBaseMultimediaSeccaoInline(MultimediaSeccao),]

# Fim Multimedia





# Link
from peakitcms.conteudos.link import models as modelsLink

class Link(modelsLink.getBaseLink()):
    website = models.ForeignKey(get_model('website','WebSite'), verbose_name=_(u'Website'), related_name='conteudoss_links_website', default=1)
    objects = models.Manager()
    publicado = CmsDefaultManager()
    #pass

    def get_url(self):
        return ('http://' if not self.url.startswith('http://') else '') + self.url


class LinkForm(MyBaseForm, modelsLink.getBaseLinkForm(Link)):
    pass

link_fieldsets = modelsLink.getBaseLinkAdmin(Link).fieldsets

class LinkAdmin(MyBaseAdmin, modelsLink.getBaseLinkAdmin(Link)):
    form = LinkForm
    fieldsets = link_fieldsets

# Fim Link



# Fotogalerias
from peakitcms.conteudos.fotogalerias import models as modelsFotogalerias

class Fotogaleria(modelsFotogalerias.getBaseFotogaleria(Seccao, 'FotogaleriaSeccao', 'Fotogaleria', 'FotogaleriaRelacao')):
    #noticia = models.TextField('noticia', null=True, blank=True)
    capa = models.CharField(u'capa', max_length=255, null=True, blank=True)
    website = models.ForeignKey(get_model('website','WebSite'), verbose_name=_(u'Website'), related_name='conteudoss_fotogalerias_website', default=1)
    objects = models.Manager()
    publicado = CmsDefaultManager()

    class Meta(modelsFotogalerias.getBaseFotogaleria(Seccao, 'FotogaleriaSeccao', 'Fotogaleria', 'FotogaleriaRelacao').Meta):
        verbose_name=u'Fotogaleria'
        verbose_name_plural=u'Fotogalerias'

fotogaleria_fildsets = modelsFotogalerias.getBaseFotogaleriaAdmin(Fotogaleria).fieldsets
fotogaleria_fildsets[3][1]['fields'] =  fotogaleria_fildsets[3][1]['fields'] + ('capa',)

class FotogaleriaImagem(modelsFotogalerias.getBaseFotogaleriaImagem(Fotogaleria)): pass

class FotogaleriaForm(MyBaseForm, modelsFotogalerias.getBaseFotogaleriaForm(Fotogaleria)):
    #noticia = forms.CharField(widget=tinymce_widgets.AdminTinyMCE)
    class Meta(modelsFotogalerias.getBaseFotogaleriaForm(Fotogaleria).Meta):
        widgets = {
                'fs': forms.widgets.HiddenInput,
                'imagem': ElfinderImageWidget(),
                'capa': ElfinderImageWidget(),
            }


class FotogaleriaSeccao(modelsFotogalerias.getBaseFotogaleriaSeccao(Fotogaleria, Seccao)): pass

class FotogaleriaRelacao(modelsFotogalerias.getBaseFotogaleriaRelacao(Fotogaleria, Fotogaleria)): pass


class FotogaleriaAdmin(MyBaseAdmin, modelsFotogalerias.getBaseFotogaleriaAdmin(Fotogaleria)):
    form = FotogaleriaForm
    fieldsets = fotogaleria_fildsets
    inlines = [modelsFotogalerias.getBaseImagemInline(FotogaleriaImagem),modelsFotogalerias.getBaseFotogaleriaSeccaoInline(FotogaleriaSeccao),]
# Fim Fotogalerias








# PDF
from peakitcms.conteudos.fotogalerias import models as modelsPDF

class PDF(modelsPDF.getBaseFotogaleria(Seccao, 'PDFSeccao', 'PDF', 'PDFRelacao')):
    #noticia = models.TextField('noticia', null=True, blank=True)
    capa = models.CharField(u'capa', max_length=255, null=True, blank=True)
    pdf = models.CharField(u'pdf', max_length=255, null=True, blank=True)
    website = models.ForeignKey(get_model('website','WebSite'), verbose_name=_(u'Website'), related_name='conteudoss_pdfs_website', default=1)
    objects = models.Manager()
    publicado = CmsDefaultManager()

    def get_next_by_publicada_inicio(self):
        try:
            return PDF.publicado.filter(publicada_inicio__gte=self.publicada_inicio).exclude(pk=self.pk).order_by('publicada_inicio')[0]
        except Exception,e:
            print str(e)
            return None
    def get_previous_by_publicada_inicio(self):
        try:
            return PDF.publicado.filter(publicada_inicio__lte=self.publicada_inicio).exclude(pk=self.pk).order_by('-publicada_inicio')[0]
        except Exception,e:
            print str(e)
            return None

    class Meta(modelsPDF.getBaseFotogaleria(Seccao, 'PDFSeccao', 'PDF', 'PDFRelacao').Meta):
        verbose_name=u'PDF'
        verbose_name_plural=u'PDFs'

"""
pdf_fildsets = modelsPDF.getBaseFotogaleriaAdmin(PDF).fieldsets
pdf_fildsets[3][1]['fields'] =  pdf_fildsets[3][1]['fields'] + ('capa',)
"""
pdf_fildsets =      (
                     DEFAULT_FIELDSETS['informacao'],
                     DEFAULT_FIELDSETS['publicacao'],
                     #(None, {
                     #                    'fields':(
                     #                              ('aceitar_comentarios', 'fs'),
                     #                              )
                     #                    }),
                     (None, {
                             'fields':(
                                       'titulo',
                                       #'resumo',
                                       ('fs','capa',),
                                       'pdf',
                                       )
                             }),
                     )

class PDFImagem(modelsPDF.getBaseFotogaleriaImagem(PDF)): pass

class PDFForm(MyBaseForm, modelsPDF.getBaseFotogaleriaForm(PDF)):
    #noticia = forms.CharField(widget=tinymce_widgets.AdminTinyMCE)
    class Meta(modelsPDF.getBaseFotogaleriaForm(PDF).Meta):
        widgets = {
                'fs': forms.widgets.HiddenInput,
                'imagem': ElfinderImageWidget(),
                'capa': ElfinderImageWidget(),
                'pdf': ElfinderImageWidget(),
            }


class PDFSeccao(modelsPDF.getBaseFotogaleriaSeccao(PDF, Seccao)):
    pass

class PDFRelacao(modelsFotogalerias.getBaseFotogaleriaRelacao(PDF, PDF)): pass


class PDFAdmin(MyBaseAdmin, modelsPDF.getBaseFotogaleriaAdmin(PDF)):
    form = PDFForm
    fieldsets = pdf_fildsets
    #inlines = [modelsPDF.getBaseImagemInline(PDFImagem),modelsPDF.getBaseFotogaleriaSeccaoInline(PDFSeccao),]
    #inlines = [modelsPDF.getBaseImagemInline(PDFImagem),]
# Fim Fotogalerias







from django.utils.translation import ugettext_lazy as _
from django.contrib.admin import SimpleListFilter

class SeccaoListFilter(SimpleListFilter):       
  
    title = ('sessoes')
    parameter_name = 'seccoes__exact'
     
    def lookups(self, request, model_admin):

        #if request.user.is_superuser:
        #    userwebsites = get_model('website','WebSite').objects.all()
        #else:
        if request:
            userwebsites = request.user.websites_websites_users.all()
        else:
            userwebsites = None

        seccoes = Seccao.tree.filter(website__in = userwebsites).order_by('tree_id','lft')
        lookup_choices = []
        for seccao in seccoes:
            lookup_choices.append((seccao.pk, u'%s%s' % ('---'* seccao.level, seccao.title)))
     
        return lookup_choices
     
    def queryset(self,request,queryset):
        pass   
        #if self.value():
        #    return queryset.filter(seccoes__exact=self.value())


# Noticia
from peakitcms.conteudos.noticias import models as modelsNoticia
#(baseseccao, noticia_seccao, basenoticia, noticia_noticia):
class Noticia(modelsNoticia.getBaseNoticia(Seccao, 'NoticiaSeccao', 'Noticia', 'NoticiaRelacao')):
    foto1 = models.CharField(u'Foto1', max_length=255, null=True, blank=True)
    foto2 = models.CharField(u'Foto2', max_length=255, null=True, blank=True)
    subsidio = models.CharField(u'Subsídio Pastoral', max_length=255, null=True, blank=True)
    equipa = models.ForeignKey(User, related_name='%(app_label)s_%(class)s_equipa', editable=False, null=True, blank=True)
    local = models.CharField(u'Local', max_length=255, null=True, blank=True)
    autor_capa_local = models.CharField(u'Local', max_length=255, null=True, blank=True)
    website = models.ForeignKey(get_model('website','WebSite'), verbose_name=_(u'Website'), related_name='conteudoss_noticias_website', default=1)
    objects = models.Manager()
    publicado = CmsDefaultManager()

    
def noticia_save(sender, **args):
    cache.clear()

post_save.connect( noticia_save, sender=Noticia )

class NoticiaForm(MyBaseForm, modelsNoticia.getBaseNoticiaForm(Noticia)):
    foto1 = forms.CharField(label=u'Foto1', widget=ElfinderImageWidget, required=False)
    foto2 = forms.CharField(label=u'Foto2', widget=ElfinderImageWidget, required=False)
    equipa = forms.ModelChoiceField(label=_(u'Equipa'), queryset=User.objects.all(), required=False)

    class Meta(modelsNoticia.getBaseNoticiaForm(Noticia).Meta):
        widgets = {
                'fs': forms.widgets.HiddenInput,
                #'imagem': ElfinderImageWidget(),
                'capa': ElfinderImageWidget(),
                'foto1': ElfinderImageWidget(),
                'foto2': ElfinderImageWidget(),
                'subsidio': ElfinderImageWidget(),
            }
"""
noticia_fieldsets = modelsNoticia.getBaseNoticiaAdmin(Noticia).fieldsets
noticia_fieldsets[3][1]['fields'] =  noticia_fieldsets[3][1]['fields'] + ('foto1','foto2',)
#noticia_fieldsets+= ((u'Fotos', {'fields':('foto1','foto2',)}),)
"""
noticia_fieldsets = (
                     DEFAULT_FIELDSETS['informacao'],
                     DEFAULT_FIELDSETS['publicacao'],
                     #(None, {
                     #                    'fields':(
                     #                              ('restrito', 'aceitar_comentarios'),
                     #                              )
                     #                    }),
                     (None, {
                             'fields':(
                                       ('ante_titulo', 'titulo', 'pos_titulo'),
                                       'resumo',
                                       'noticia',
                                       'autor',
                                       'local',
                                       'foto1',
                                       'foto2',
                                       'equipa',
                                       'subsidio',
                                       )
                             }),
                     (_(u'Capa'), {
                             'fields':(
                                       ('capa', 'fs'),
                                       'autor_capa',
                                       'autor_capa_local',
                                       )
                             }),
                     )

class NoticiaSeccao(modelsNoticia.getBaseNoticiaSeccao(Noticia, Seccao)): pass

class NoticiaRelacao(modelsNoticia.getBaseNoticiaRelacao(Noticia, Noticia)): pass

class NoticiaAdmin(MyBaseAdmin, modelsNoticia.getBaseNoticiaAdmin(Noticia)):
    form = NoticiaForm
    fieldsets = noticia_fieldsets
    inlines = [modelsNoticia.getBaseSeccaoInline(NoticiaSeccao),]
    list_filter = ('activo', SeccaoListFilter,)#'seccoes'
# Fim Noticia


