# -*- coding: utf-8 -*-
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):
        # Adding model 'Seccao'
        db.create_table('conteudos_seccao', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='conteudos_seccao_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='conteudos_seccao_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='conteudos_seccao_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('title', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('parent', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='conteudos_seccao_parent', null=True, to=orm['conteudos.Seccao'])),
            ('lft', self.gf('django.db.models.fields.PositiveIntegerField')(db_index=True)),
            ('rght', self.gf('django.db.models.fields.PositiveIntegerField')(db_index=True)),
            ('tree_id', self.gf('django.db.models.fields.PositiveIntegerField')(db_index=True)),
            ('level', self.gf('django.db.models.fields.PositiveIntegerField')(db_index=True)),
            ('descricao', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('website', self.gf('django.db.models.fields.related.ForeignKey')(default=1, related_name='conteudos_seccao_website', to=orm['website.WebSite'])),
        ))
        db.send_create_signal('conteudos', ['Seccao'])

        # Adding model 'Multimedia'
        db.create_table('conteudos_multimedia', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='conteudos_multimedia_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='conteudos_multimedia_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='conteudos_multimedia_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('publicada_inicio', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, db_index=True, blank=True)),
            ('publicada_fim', self.gf('django.db.models.fields.DateTimeField')(db_index=True, null=True, blank=True)),
            ('aprovado_por', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='conteudos_multimedia_aprovado_por', null=True, to=orm['auth.User'])),
            ('aprovado', self.gf('django.db.models.fields.DateTimeField')(null=True, blank=True)),
            ('video', self.gf('django.db.models.fields.URLField')(max_length=200)),
            ('titulo', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('foto', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('ficheiro', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('descricao', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('tipo', self.gf('django.db.models.fields.PositiveIntegerField')(default=0, max_length=1)),
            ('assinatura', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('website', self.gf('django.db.models.fields.related.ForeignKey')(default=1, related_name='conteudos_multimedia_website', to=orm['website.WebSite'])),
        ))
        db.send_create_signal('conteudos', ['Multimedia'])

        # Adding model 'MultimediaSeccao'
        db.create_table('conteudos_multimediaseccao', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('noticia', self.gf('django.db.models.fields.related.ForeignKey')(related_name='conteudos_multimediaseccao_multimedia', to=orm['conteudos.Multimedia'])),
            ('seccao', self.gf('django.db.models.fields.related.ForeignKey')(related_name='conteudos_multimediaseccao_seccao', to=orm['conteudos.Seccao'])),
            ('seccao_publicacao', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
        ))
        db.send_create_signal('conteudos', ['MultimediaSeccao'])

        # Adding unique constraint on 'MultimediaSeccao', fields ['noticia', 'seccao']
        db.create_unique('conteudos_multimediaseccao', ['noticia_id', 'seccao_id'])

        # Adding model 'MultimediaRelacao'
        db.create_table('conteudos_multimediarelacao', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('multimedia', self.gf('django.db.models.fields.related.ForeignKey')(related_name='conteudos_multimediarelacao_noticia_ori', to=orm['conteudos.Multimedia'])),
            ('multimedia_rel', self.gf('django.db.models.fields.related.ForeignKey')(related_name='conteudos_multimediarelacao_noticia_rel', to=orm['conteudos.Multimedia'])),
        ))
        db.send_create_signal('conteudos', ['MultimediaRelacao'])

        # Adding unique constraint on 'MultimediaRelacao', fields ['multimedia', 'multimedia_rel']
        db.create_unique('conteudos_multimediarelacao', ['multimedia_id', 'multimedia_rel_id'])

        # Adding model 'Link'
        db.create_table('conteudos_link', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='conteudos_link_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='conteudos_link_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='conteudos_link_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('publicada_inicio', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, db_index=True, blank=True)),
            ('publicada_fim', self.gf('django.db.models.fields.DateTimeField')(db_index=True, null=True, blank=True)),
            ('aprovado_por', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='conteudos_link_aprovado_por', null=True, to=orm['auth.User'])),
            ('aprovado', self.gf('django.db.models.fields.DateTimeField')(null=True, blank=True)),
            ('titulo', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('descricao', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('url', self.gf('django.db.models.fields.URLField')(max_length=200, null=True, blank=True)),
            ('categoria', self.gf('django.db.models.fields.PositiveIntegerField')(default=0, max_length=1)),
            ('website', self.gf('django.db.models.fields.related.ForeignKey')(default=1, related_name='conteudos_link_website', to=orm['website.WebSite'])),
        ))
        db.send_create_signal('conteudos', ['Link'])

        # Adding model 'Fotogaleria'
        db.create_table('conteudos_fotogaleria', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='conteudos_fotogaleria_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='conteudos_fotogaleria_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='conteudos_fotogaleria_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('publicada_inicio', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, db_index=True, blank=True)),
            ('publicada_fim', self.gf('django.db.models.fields.DateTimeField')(db_index=True, null=True, blank=True)),
            ('aprovado_por', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='conteudos_fotogaleria_aprovado_por', null=True, to=orm['auth.User'])),
            ('aprovado', self.gf('django.db.models.fields.DateTimeField')(null=True, blank=True)),
            ('titulo', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('resumo', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('aceitar_comentarios', self.gf('django.db.models.fields.IntegerField')(default=1)),
            ('capa', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('website', self.gf('django.db.models.fields.related.ForeignKey')(default=1, related_name='conteudos_fotogaleria_website', to=orm['website.WebSite'])),
        ))
        db.send_create_signal('conteudos', ['Fotogaleria'])

        # Adding model 'FotogaleriaImagem'
        db.create_table('conteudos_fotogaleriaimagem', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('inline_ordering_position', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('fotogaleria', self.gf('django.db.models.fields.related.ForeignKey')(related_name='conteudos_fotogaleriaimagem_fotogaleria_imagem', to=orm['conteudos.Fotogaleria'])),
            ('imagem', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('titulo', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
        ))
        db.send_create_signal('conteudos', ['FotogaleriaImagem'])

        # Adding model 'FotogaleriaSeccao'
        db.create_table('conteudos_fotogaleriaseccao', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('noticia', self.gf('django.db.models.fields.related.ForeignKey')(related_name='conteudos_fotogaleriaseccao_multimedia', to=orm['conteudos.Fotogaleria'])),
            ('seccao', self.gf('django.db.models.fields.related.ForeignKey')(related_name='conteudos_fotogaleriaseccao_seccao', to=orm['conteudos.Seccao'])),
            ('seccao_publicacao', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
        ))
        db.send_create_signal('conteudos', ['FotogaleriaSeccao'])

        # Adding unique constraint on 'FotogaleriaSeccao', fields ['noticia', 'seccao']
        db.create_unique('conteudos_fotogaleriaseccao', ['noticia_id', 'seccao_id'])

        # Adding model 'FotogaleriaRelacao'
        db.create_table('conteudos_fotogaleriarelacao', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('fotogaleria', self.gf('django.db.models.fields.related.ForeignKey')(related_name='conteudos_fotogaleriarelacao_noticia_ori', to=orm['conteudos.Fotogaleria'])),
            ('fotogaleria_rel', self.gf('django.db.models.fields.related.ForeignKey')(related_name='conteudos_fotogaleriarelacao_noticia_rel', to=orm['conteudos.Fotogaleria'])),
        ))
        db.send_create_signal('conteudos', ['FotogaleriaRelacao'])

        # Adding unique constraint on 'FotogaleriaRelacao', fields ['fotogaleria', 'fotogaleria_rel']
        db.create_unique('conteudos_fotogaleriarelacao', ['fotogaleria_id', 'fotogaleria_rel_id'])

        # Adding model 'PDF'
        db.create_table('conteudos_pdf', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='conteudos_pdf_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='conteudos_pdf_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='conteudos_pdf_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('publicada_inicio', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, db_index=True, blank=True)),
            ('publicada_fim', self.gf('django.db.models.fields.DateTimeField')(db_index=True, null=True, blank=True)),
            ('aprovado_por', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='conteudos_pdf_aprovado_por', null=True, to=orm['auth.User'])),
            ('aprovado', self.gf('django.db.models.fields.DateTimeField')(null=True, blank=True)),
            ('titulo', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('resumo', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('aceitar_comentarios', self.gf('django.db.models.fields.IntegerField')(default=1)),
            ('capa', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('pdf', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('website', self.gf('django.db.models.fields.related.ForeignKey')(default=1, related_name='conteudos_pdf_website', to=orm['website.WebSite'])),
        ))
        db.send_create_signal('conteudos', ['PDF'])

        # Adding model 'PDFImagem'
        db.create_table('conteudos_pdfimagem', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('inline_ordering_position', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('fotogaleria', self.gf('django.db.models.fields.related.ForeignKey')(related_name='conteudos_pdfimagem_fotogaleria_imagem', to=orm['conteudos.PDF'])),
            ('imagem', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('titulo', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
        ))
        db.send_create_signal('conteudos', ['PDFImagem'])

        # Adding model 'PDFSeccao'
        db.create_table('conteudos_pdfseccao', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('noticia', self.gf('django.db.models.fields.related.ForeignKey')(related_name='conteudos_pdfseccao_multimedia', to=orm['conteudos.PDF'])),
            ('seccao', self.gf('django.db.models.fields.related.ForeignKey')(related_name='conteudos_pdfseccao_seccao', to=orm['conteudos.Seccao'])),
            ('seccao_publicacao', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
        ))
        db.send_create_signal('conteudos', ['PDFSeccao'])

        # Adding unique constraint on 'PDFSeccao', fields ['noticia', 'seccao']
        db.create_unique('conteudos_pdfseccao', ['noticia_id', 'seccao_id'])

        # Adding model 'PDFRelacao'
        db.create_table('conteudos_pdfrelacao', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('fotogaleria', self.gf('django.db.models.fields.related.ForeignKey')(related_name='conteudos_pdfrelacao_noticia_ori', to=orm['conteudos.PDF'])),
            ('fotogaleria_rel', self.gf('django.db.models.fields.related.ForeignKey')(related_name='conteudos_pdfrelacao_noticia_rel', to=orm['conteudos.PDF'])),
        ))
        db.send_create_signal('conteudos', ['PDFRelacao'])

        # Adding unique constraint on 'PDFRelacao', fields ['fotogaleria', 'fotogaleria_rel']
        db.create_unique('conteudos_pdfrelacao', ['fotogaleria_id', 'fotogaleria_rel_id'])

        # Adding model 'Noticia'
        db.create_table('conteudos_noticia', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='conteudos_noticia_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='conteudos_noticia_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='conteudos_noticia_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('publicada_inicio', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, db_index=True, blank=True)),
            ('publicada_fim', self.gf('django.db.models.fields.DateTimeField')(db_index=True, null=True, blank=True)),
            ('aprovado_por', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='conteudos_noticia_aprovado_por', null=True, to=orm['auth.User'])),
            ('aprovado', self.gf('django.db.models.fields.DateTimeField')(null=True, blank=True)),
            ('ante_titulo', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('titulo', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('pos_titulo', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('resumo', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('noticia', self.gf('django.db.models.fields.TextField')()),
            ('autor', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('restrito', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('aceitar_comentarios', self.gf('django.db.models.fields.IntegerField')(default=1)),
            ('capa', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('autor_capa', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('foto1', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('foto2', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('equipa', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='conteudos_noticia_equipa', null=True, to=orm['auth.User'])),
            ('local', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('autor_capa_local', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('website', self.gf('django.db.models.fields.related.ForeignKey')(default=1, related_name='conteudos_noticia_website', to=orm['website.WebSite'])),
        ))
        db.send_create_signal('conteudos', ['Noticia'])

        # Adding model 'NoticiaSeccao'
        db.create_table('conteudos_noticiaseccao', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('noticia', self.gf('django.db.models.fields.related.ForeignKey')(related_name='conteudos_noticiaseccao_noticia', to=orm['conteudos.Noticia'])),
            ('seccao', self.gf('django.db.models.fields.related.ForeignKey')(related_name='conteudos_noticiaseccao_seccao', to=orm['conteudos.Seccao'])),
            ('seccao_publicacao', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
        ))
        db.send_create_signal('conteudos', ['NoticiaSeccao'])

        # Adding unique constraint on 'NoticiaSeccao', fields ['noticia', 'seccao']
        db.create_unique('conteudos_noticiaseccao', ['noticia_id', 'seccao_id'])

        # Adding model 'NoticiaRelacao'
        db.create_table('conteudos_noticiarelacao', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('noticia', self.gf('django.db.models.fields.related.ForeignKey')(related_name='conteudos_noticiarelacao_noticia_ori', to=orm['conteudos.Noticia'])),
            ('noticia_rel', self.gf('django.db.models.fields.related.ForeignKey')(related_name='conteudos_noticiarelacao_noticia_rel', to=orm['conteudos.Noticia'])),
        ))
        db.send_create_signal('conteudos', ['NoticiaRelacao'])

        # Adding unique constraint on 'NoticiaRelacao', fields ['noticia', 'noticia_rel']
        db.create_unique('conteudos_noticiarelacao', ['noticia_id', 'noticia_rel_id'])


    def backwards(self, orm):
        # Removing unique constraint on 'NoticiaRelacao', fields ['noticia', 'noticia_rel']
        db.delete_unique('conteudos_noticiarelacao', ['noticia_id', 'noticia_rel_id'])

        # Removing unique constraint on 'NoticiaSeccao', fields ['noticia', 'seccao']
        db.delete_unique('conteudos_noticiaseccao', ['noticia_id', 'seccao_id'])

        # Removing unique constraint on 'PDFRelacao', fields ['fotogaleria', 'fotogaleria_rel']
        db.delete_unique('conteudos_pdfrelacao', ['fotogaleria_id', 'fotogaleria_rel_id'])

        # Removing unique constraint on 'PDFSeccao', fields ['noticia', 'seccao']
        db.delete_unique('conteudos_pdfseccao', ['noticia_id', 'seccao_id'])

        # Removing unique constraint on 'FotogaleriaRelacao', fields ['fotogaleria', 'fotogaleria_rel']
        db.delete_unique('conteudos_fotogaleriarelacao', ['fotogaleria_id', 'fotogaleria_rel_id'])

        # Removing unique constraint on 'FotogaleriaSeccao', fields ['noticia', 'seccao']
        db.delete_unique('conteudos_fotogaleriaseccao', ['noticia_id', 'seccao_id'])

        # Removing unique constraint on 'MultimediaRelacao', fields ['multimedia', 'multimedia_rel']
        db.delete_unique('conteudos_multimediarelacao', ['multimedia_id', 'multimedia_rel_id'])

        # Removing unique constraint on 'MultimediaSeccao', fields ['noticia', 'seccao']
        db.delete_unique('conteudos_multimediaseccao', ['noticia_id', 'seccao_id'])

        # Deleting model 'Seccao'
        db.delete_table('conteudos_seccao')

        # Deleting model 'Multimedia'
        db.delete_table('conteudos_multimedia')

        # Deleting model 'MultimediaSeccao'
        db.delete_table('conteudos_multimediaseccao')

        # Deleting model 'MultimediaRelacao'
        db.delete_table('conteudos_multimediarelacao')

        # Deleting model 'Link'
        db.delete_table('conteudos_link')

        # Deleting model 'Fotogaleria'
        db.delete_table('conteudos_fotogaleria')

        # Deleting model 'FotogaleriaImagem'
        db.delete_table('conteudos_fotogaleriaimagem')

        # Deleting model 'FotogaleriaSeccao'
        db.delete_table('conteudos_fotogaleriaseccao')

        # Deleting model 'FotogaleriaRelacao'
        db.delete_table('conteudos_fotogaleriarelacao')

        # Deleting model 'PDF'
        db.delete_table('conteudos_pdf')

        # Deleting model 'PDFImagem'
        db.delete_table('conteudos_pdfimagem')

        # Deleting model 'PDFSeccao'
        db.delete_table('conteudos_pdfseccao')

        # Deleting model 'PDFRelacao'
        db.delete_table('conteudos_pdfrelacao')

        # Deleting model 'Noticia'
        db.delete_table('conteudos_noticia')

        # Deleting model 'NoticiaSeccao'
        db.delete_table('conteudos_noticiaseccao')

        # Deleting model 'NoticiaRelacao'
        db.delete_table('conteudos_noticiarelacao')


    models = {
        'auth.group': {
            'Meta': {'object_name': 'Group'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '80'}),
            'permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'})
        },
        'auth.permission': {
            'Meta': {'ordering': "('content_type__app_label', 'content_type__model', 'codename')", 'unique_together': "(('content_type', 'codename'),)", 'object_name': 'Permission'},
            'codename': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'content_type': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['contenttypes.ContentType']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '50'})
        },
        'auth.user': {
            'Meta': {'object_name': 'User'},
            'date_joined': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'email': ('django.db.models.fields.EmailField', [], {'max_length': '75', 'blank': 'True'}),
            'first_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'groups': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Group']", 'symmetrical': 'False', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'is_active': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'is_staff': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_superuser': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'last_login': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'last_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'password': ('django.db.models.fields.CharField', [], {'max_length': '128'}),
            'user_permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'}),
            'username': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '30'})
        },
        'contenttypes.contenttype': {
            'Meta': {'ordering': "('name',)", 'unique_together': "(('app_label', 'model'),)", 'object_name': 'ContentType', 'db_table': "'django_content_type'"},
            'app_label': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'model': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'})
        },
        'conteudos.fotogaleria': {
            'Meta': {'object_name': 'Fotogaleria'},
            'aceitar_comentarios': ('django.db.models.fields.IntegerField', [], {'default': '1'}),
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_fotogaleria_alterado_por'", 'to': "orm['auth.User']"}),
            'aprovado': ('django.db.models.fields.DateTimeField', [], {'null': 'True', 'blank': 'True'}),
            'aprovado_por': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'conteudos_fotogaleria_aprovado_por'", 'null': 'True', 'to': "orm['auth.User']"}),
            'capa': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_fotogaleria_criado_por'", 'to': "orm['auth.User']"}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'conteudos_fotogaleria_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'publicada_fim': ('django.db.models.fields.DateTimeField', [], {'db_index': 'True', 'null': 'True', 'blank': 'True'}),
            'publicada_inicio': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'db_index': 'True', 'blank': 'True'}),
            'relacoes': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'conteudos_fotogaleria_fotogaleria_relacao'", 'to': "orm['conteudos.Fotogaleria']", 'through': "orm['conteudos.FotogaleriaRelacao']", 'blank': 'True', 'symmetrical': 'False', 'null': 'True'}),
            'resumo': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'seccoes': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'conteudos_fotogaleria_fotogaleria_seccao'", 'to': "orm['conteudos.Seccao']", 'through': "orm['conteudos.FotogaleriaSeccao']", 'blank': 'True', 'symmetrical': 'False', 'null': 'True'}),
            'titulo': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'website': ('django.db.models.fields.related.ForeignKey', [], {'default': '1', 'related_name': "'conteudos_fotogaleria_website'", 'to': "orm['website.WebSite']"})
        },
        'conteudos.fotogaleriaimagem': {
            'Meta': {'ordering': "('inline_ordering_position',)", 'object_name': 'FotogaleriaImagem'},
            'fotogaleria': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_fotogaleriaimagem_fotogaleria_imagem'", 'to': "orm['conteudos.Fotogaleria']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'imagem': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'inline_ordering_position': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'titulo': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'conteudos.fotogaleriarelacao': {
            'Meta': {'unique_together': "(('fotogaleria', 'fotogaleria_rel'),)", 'object_name': 'FotogaleriaRelacao'},
            'fotogaleria': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_fotogaleriarelacao_noticia_ori'", 'to': "orm['conteudos.Fotogaleria']"}),
            'fotogaleria_rel': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_fotogaleriarelacao_noticia_rel'", 'to': "orm['conteudos.Fotogaleria']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'})
        },
        'conteudos.fotogaleriaseccao': {
            'Meta': {'unique_together': "(('noticia', 'seccao'),)", 'object_name': 'FotogaleriaSeccao'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'noticia': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_fotogaleriaseccao_multimedia'", 'to': "orm['conteudos.Fotogaleria']"}),
            'seccao': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_fotogaleriaseccao_seccao'", 'to': "orm['conteudos.Seccao']"}),
            'seccao_publicacao': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'})
        },
        'conteudos.link': {
            'Meta': {'object_name': 'Link'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_link_alterado_por'", 'to': "orm['auth.User']"}),
            'aprovado': ('django.db.models.fields.DateTimeField', [], {'null': 'True', 'blank': 'True'}),
            'aprovado_por': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'conteudos_link_aprovado_por'", 'null': 'True', 'to': "orm['auth.User']"}),
            'categoria': ('django.db.models.fields.PositiveIntegerField', [], {'default': '0', 'max_length': '1'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_link_criado_por'", 'to': "orm['auth.User']"}),
            'descricao': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'conteudos_link_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'publicada_fim': ('django.db.models.fields.DateTimeField', [], {'db_index': 'True', 'null': 'True', 'blank': 'True'}),
            'publicada_inicio': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'db_index': 'True', 'blank': 'True'}),
            'titulo': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'url': ('django.db.models.fields.URLField', [], {'max_length': '200', 'null': 'True', 'blank': 'True'}),
            'website': ('django.db.models.fields.related.ForeignKey', [], {'default': '1', 'related_name': "'conteudos_link_website'", 'to': "orm['website.WebSite']"})
        },
        'conteudos.multimedia': {
            'Meta': {'object_name': 'Multimedia'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_multimedia_alterado_por'", 'to': "orm['auth.User']"}),
            'aprovado': ('django.db.models.fields.DateTimeField', [], {'null': 'True', 'blank': 'True'}),
            'aprovado_por': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'conteudos_multimedia_aprovado_por'", 'null': 'True', 'to': "orm['auth.User']"}),
            'assinatura': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_multimedia_criado_por'", 'to': "orm['auth.User']"}),
            'descricao': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'ficheiro': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'conteudos_multimedia_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'publicada_fim': ('django.db.models.fields.DateTimeField', [], {'db_index': 'True', 'null': 'True', 'blank': 'True'}),
            'publicada_inicio': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'db_index': 'True', 'blank': 'True'}),
            'relacoes': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'conteudos_multimedia_multimedia_relacao'", 'to': "orm['conteudos.Multimedia']", 'through': "orm['conteudos.MultimediaRelacao']", 'blank': 'True', 'symmetrical': 'False', 'null': 'True'}),
            'seccoes': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'conteudos_multimedia_multimedia_seccao'", 'to': "orm['conteudos.Seccao']", 'through': "orm['conteudos.MultimediaSeccao']", 'blank': 'True', 'symmetrical': 'False', 'null': 'True'}),
            'tipo': ('django.db.models.fields.PositiveIntegerField', [], {'default': '0', 'max_length': '1'}),
            'titulo': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'video': ('django.db.models.fields.URLField', [], {'max_length': '200'}),
            'website': ('django.db.models.fields.related.ForeignKey', [], {'default': '1', 'related_name': "'conteudos_multimedia_website'", 'to': "orm['website.WebSite']"})
        },
        'conteudos.multimediarelacao': {
            'Meta': {'unique_together': "(('multimedia', 'multimedia_rel'),)", 'object_name': 'MultimediaRelacao'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'multimedia': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_multimediarelacao_noticia_ori'", 'to': "orm['conteudos.Multimedia']"}),
            'multimedia_rel': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_multimediarelacao_noticia_rel'", 'to': "orm['conteudos.Multimedia']"})
        },
        'conteudos.multimediaseccao': {
            'Meta': {'unique_together': "(('noticia', 'seccao'),)", 'object_name': 'MultimediaSeccao'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'noticia': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_multimediaseccao_multimedia'", 'to': "orm['conteudos.Multimedia']"}),
            'seccao': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_multimediaseccao_seccao'", 'to': "orm['conteudos.Seccao']"}),
            'seccao_publicacao': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'})
        },
        'conteudos.noticia': {
            'Meta': {'object_name': 'Noticia'},
            'aceitar_comentarios': ('django.db.models.fields.IntegerField', [], {'default': '1'}),
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_noticia_alterado_por'", 'to': "orm['auth.User']"}),
            'ante_titulo': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'aprovado': ('django.db.models.fields.DateTimeField', [], {'null': 'True', 'blank': 'True'}),
            'aprovado_por': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'conteudos_noticia_aprovado_por'", 'null': 'True', 'to': "orm['auth.User']"}),
            'autor': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'autor_capa': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'autor_capa_local': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'capa': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_noticia_criado_por'", 'to': "orm['auth.User']"}),
            'equipa': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'conteudos_noticia_equipa'", 'null': 'True', 'to': "orm['auth.User']"}),
            'foto1': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto2': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'conteudos_noticia_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'local': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'noticia': ('django.db.models.fields.TextField', [], {}),
            'pos_titulo': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'publicada_fim': ('django.db.models.fields.DateTimeField', [], {'db_index': 'True', 'null': 'True', 'blank': 'True'}),
            'publicada_inicio': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'db_index': 'True', 'blank': 'True'}),
            'relacoes': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'conteudos_noticia_noticia_relacao'", 'to': "orm['conteudos.Noticia']", 'through': "orm['conteudos.NoticiaRelacao']", 'blank': 'True', 'symmetrical': 'False', 'null': 'True'}),
            'restrito': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'resumo': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'seccoes': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'conteudos_noticia_noticia_seccao'", 'to': "orm['conteudos.Seccao']", 'through': "orm['conteudos.NoticiaSeccao']", 'blank': 'True', 'symmetrical': 'False', 'null': 'True'}),
            'titulo': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'website': ('django.db.models.fields.related.ForeignKey', [], {'default': '1', 'related_name': "'conteudos_noticia_website'", 'to': "orm['website.WebSite']"})
        },
        'conteudos.noticiarelacao': {
            'Meta': {'unique_together': "(('noticia', 'noticia_rel'),)", 'object_name': 'NoticiaRelacao'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'noticia': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_noticiarelacao_noticia_ori'", 'to': "orm['conteudos.Noticia']"}),
            'noticia_rel': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_noticiarelacao_noticia_rel'", 'to': "orm['conteudos.Noticia']"})
        },
        'conteudos.noticiaseccao': {
            'Meta': {'unique_together': "(('noticia', 'seccao'),)", 'object_name': 'NoticiaSeccao'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'noticia': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_noticiaseccao_noticia'", 'to': "orm['conteudos.Noticia']"}),
            'seccao': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_noticiaseccao_seccao'", 'to': "orm['conteudos.Seccao']"}),
            'seccao_publicacao': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'})
        },
        'conteudos.pdf': {
            'Meta': {'object_name': 'PDF'},
            'aceitar_comentarios': ('django.db.models.fields.IntegerField', [], {'default': '1'}),
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_pdf_alterado_por'", 'to': "orm['auth.User']"}),
            'aprovado': ('django.db.models.fields.DateTimeField', [], {'null': 'True', 'blank': 'True'}),
            'aprovado_por': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'conteudos_pdf_aprovado_por'", 'null': 'True', 'to': "orm['auth.User']"}),
            'capa': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_pdf_criado_por'", 'to': "orm['auth.User']"}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'conteudos_pdf_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'pdf': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'publicada_fim': ('django.db.models.fields.DateTimeField', [], {'db_index': 'True', 'null': 'True', 'blank': 'True'}),
            'publicada_inicio': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'db_index': 'True', 'blank': 'True'}),
            'relacoes': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'conteudos_pdf_fotogaleria_relacao'", 'to': "orm['conteudos.PDF']", 'through': "orm['conteudos.PDFRelacao']", 'blank': 'True', 'symmetrical': 'False', 'null': 'True'}),
            'resumo': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'seccoes': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'conteudos_pdf_fotogaleria_seccao'", 'to': "orm['conteudos.Seccao']", 'through': "orm['conteudos.PDFSeccao']", 'blank': 'True', 'symmetrical': 'False', 'null': 'True'}),
            'titulo': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'website': ('django.db.models.fields.related.ForeignKey', [], {'default': '1', 'related_name': "'conteudos_pdf_website'", 'to': "orm['website.WebSite']"})
        },
        'conteudos.pdfimagem': {
            'Meta': {'ordering': "('inline_ordering_position',)", 'object_name': 'PDFImagem'},
            'fotogaleria': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_pdfimagem_fotogaleria_imagem'", 'to': "orm['conteudos.PDF']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'imagem': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'inline_ordering_position': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'titulo': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'conteudos.pdfrelacao': {
            'Meta': {'unique_together': "(('fotogaleria', 'fotogaleria_rel'),)", 'object_name': 'PDFRelacao'},
            'fotogaleria': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_pdfrelacao_noticia_ori'", 'to': "orm['conteudos.PDF']"}),
            'fotogaleria_rel': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_pdfrelacao_noticia_rel'", 'to': "orm['conteudos.PDF']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'})
        },
        'conteudos.pdfseccao': {
            'Meta': {'unique_together': "(('noticia', 'seccao'),)", 'object_name': 'PDFSeccao'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'noticia': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_pdfseccao_multimedia'", 'to': "orm['conteudos.PDF']"}),
            'seccao': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_pdfseccao_seccao'", 'to': "orm['conteudos.Seccao']"}),
            'seccao_publicacao': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'})
        },
        'conteudos.seccao': {
            'Meta': {'object_name': 'Seccao'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_seccao_alterado_por'", 'to': "orm['auth.User']"}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_seccao_criado_por'", 'to': "orm['auth.User']"}),
            'descricao': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'conteudos_seccao_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'level': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'lft': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'parent': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'conteudos_seccao_parent'", 'null': 'True', 'to': "orm['conteudos.Seccao']"}),
            'rght': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'title': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'tree_id': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'website': ('django.db.models.fields.related.ForeignKey', [], {'default': '1', 'related_name': "'conteudos_seccao_website'", 'to': "orm['website.WebSite']"})
        },
        'diocese.arciprestado': {
            'Meta': {'object_name': 'Arciprestado'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_arciprestado_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'arcipreste': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'arcipreste_adjunto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_arciprestado_criado_por'", 'to': "orm['auth.User']"}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_arciprestado_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'logo': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'presbitero_arcipreste': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_arciprestado_presbitero_arcipreste'", 'null': 'True', 'to': "orm['diocese.Presbitero']"}),
            'presbitero_arcipreste_adjunto': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_arciprestado_presbitero_arcipreste_adjunto'", 'null': 'True', 'to': "orm['diocese.Presbitero']"})
        },
        'diocese.presbitero': {
            'Meta': {'object_name': 'Presbitero'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_presbitero_alterado_por'", 'to': "orm['auth.User']"}),
            'arcipreste': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'capelao': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'cartao_sacerdotal': ('django.db.models.fields.IntegerField', [], {'max_length': '2', 'null': 'True', 'blank': 'True'}),
            'clero_tipo': ('django.db.models.fields.PositiveIntegerField', [], {'default': '1', 'max_length': '1'}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_presbitero_criado_por'", 'to': "orm['auth.User']"}),
            'data_faleceu': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'data_nascimento': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'data_ordenacoa': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'faleceu': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'formacao_permanente': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fraternidade_sacerdotal': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_presbitero_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'habilitacoes_academicas': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'igreja': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'local_nascimento': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'local_ordenacao': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'nomeacoes': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'nomeacoes_actuais': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'obs': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'paroco': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'publicacoes': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'reitor': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'serv_pastoral': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel_privado': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'tipo_clero': ('django.db.models.fields.PositiveIntegerField', [], {'max_length': '1', 'null': 'True', 'blank': 'True'}),
            'vice_arcipreste': ('django.db.models.fields.BooleanField', [], {'default': 'False'})
        },
        'elfinder.filecollection': {
            'Meta': {'object_name': 'FileCollection'},
            'dir': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'url': ('django.db.models.fields.CharField', [], {'max_length': '255'})
        },
        'website.website': {
            'Meta': {'object_name': 'WebSite'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'websites_websites_arciprestado'", 'null': 'True', 'to': "orm['diocese.Arciprestado']"}),
            'email': ('django.db.models.fields.EmailField', [], {'max_length': '75'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'titulo': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'url': ('django.db.models.fields.URLField', [], {'max_length': '200'}),
            'users': ('django.db.models.fields.related.ManyToManyField', [], {'blank': 'True', 'related_name': "'websites_websites_users'", 'null': 'True', 'symmetrical': 'False', 'to': "orm['auth.User']"})
        }
    }

    complete_apps = ['conteudos']