# -*- coding: utf-8 -*-
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):
        # Adding model 'AgendaEntidade'
        db.create_table('agenda_agendaentidade', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='agenda_agendaentidade_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='agenda_agendaentidade_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='agenda_agendaentidade_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('publicada_inicio', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, db_index=True, blank=True)),
            ('publicada_fim', self.gf('django.db.models.fields.DateTimeField')(db_index=True, null=True, blank=True)),
            ('aprovado_por', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='agenda_agendaentidade_aprovado_por', null=True, to=orm['auth.User'])),
            ('aprovado', self.gf('django.db.models.fields.DateTimeField')(null=True, blank=True)),
            ('titulo', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('website', self.gf('django.db.models.fields.related.ForeignKey')(default=1, related_name='agenda_agendaentidade_website', to=orm['website.WebSite'])),
        ))
        db.send_create_signal('agenda', ['AgendaEntidade'])

        # Adding model 'AgendaLocal'
        db.create_table('agenda_agendalocal', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='agenda_agendalocal_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='agenda_agendalocal_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='agenda_agendalocal_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('publicada_inicio', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, db_index=True, blank=True)),
            ('publicada_fim', self.gf('django.db.models.fields.DateTimeField')(db_index=True, null=True, blank=True)),
            ('aprovado_por', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='agenda_agendalocal_aprovado_por', null=True, to=orm['auth.User'])),
            ('aprovado', self.gf('django.db.models.fields.DateTimeField')(null=True, blank=True)),
            ('titulo', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('website', self.gf('django.db.models.fields.related.ForeignKey')(default=1, related_name='agenda_agendalocal_website', to=orm['website.WebSite'])),
        ))
        db.send_create_signal('agenda', ['AgendaLocal'])

        # Adding model 'Agenda'
        db.create_table('agenda_agenda', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('criado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='agenda_agenda_criado_por', to=orm['auth.User'])),
            ('alterado_por', self.gf('django.db.models.fields.related.ForeignKey')(related_name='agenda_agenda_alterado_por', to=orm['auth.User'])),
            ('criado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('alterado', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, blank=True)),
            ('fs', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='agenda_agenda_file_collection', null=True, to=orm['elfinder.FileCollection'])),
            ('publicada_inicio', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, null=True, db_index=True, blank=True)),
            ('publicada_fim', self.gf('django.db.models.fields.DateTimeField')(db_index=True, null=True, blank=True)),
            ('aprovado_por', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='agenda_agenda_aprovado_por', null=True, to=orm['auth.User'])),
            ('aprovado', self.gf('django.db.models.fields.DateTimeField')(null=True, blank=True)),
            ('titulo', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('descricao', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('entidade', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='agenda_agenda_entidade', null=True, to=orm['agenda.AgendaEntidade'])),
            ('local', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='agenda_agenda_local', null=True, to=orm['agenda.AgendaLocal'])),
            ('data_inicio', self.gf('django.db.models.fields.DateTimeField')()),
            ('data_fim', self.gf('django.db.models.fields.DateTimeField')()),
            ('website', self.gf('django.db.models.fields.related.ForeignKey')(default=1, related_name='agenda_agenda_website', to=orm['website.WebSite'])),
        ))
        db.send_create_signal('agenda', ['Agenda'])


    def backwards(self, orm):
        # Deleting model 'AgendaEntidade'
        db.delete_table('agenda_agendaentidade')

        # Deleting model 'AgendaLocal'
        db.delete_table('agenda_agendalocal')

        # Deleting model 'Agenda'
        db.delete_table('agenda_agenda')


    models = {
        'agenda.agenda': {
            'Meta': {'object_name': 'Agenda'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'agenda_agenda_alterado_por'", 'to': "orm['auth.User']"}),
            'aprovado': ('django.db.models.fields.DateTimeField', [], {'null': 'True', 'blank': 'True'}),
            'aprovado_por': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'agenda_agenda_aprovado_por'", 'null': 'True', 'to': "orm['auth.User']"}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'agenda_agenda_criado_por'", 'to': "orm['auth.User']"}),
            'data_fim': ('django.db.models.fields.DateTimeField', [], {}),
            'data_inicio': ('django.db.models.fields.DateTimeField', [], {}),
            'descricao': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'entidade': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'agenda_agenda_entidade'", 'null': 'True', 'to': "orm['agenda.AgendaEntidade']"}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'agenda_agenda_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'local': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'agenda_agenda_local'", 'null': 'True', 'to': "orm['agenda.AgendaLocal']"}),
            'publicada_fim': ('django.db.models.fields.DateTimeField', [], {'db_index': 'True', 'null': 'True', 'blank': 'True'}),
            'publicada_inicio': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'db_index': 'True', 'blank': 'True'}),
            'titulo': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'website': ('django.db.models.fields.related.ForeignKey', [], {'default': '1', 'related_name': "'agenda_agenda_website'", 'to': "orm['website.WebSite']"})
        },
        'agenda.agendaentidade': {
            'Meta': {'object_name': 'AgendaEntidade'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'agenda_agendaentidade_alterado_por'", 'to': "orm['auth.User']"}),
            'aprovado': ('django.db.models.fields.DateTimeField', [], {'null': 'True', 'blank': 'True'}),
            'aprovado_por': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'agenda_agendaentidade_aprovado_por'", 'null': 'True', 'to': "orm['auth.User']"}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'agenda_agendaentidade_criado_por'", 'to': "orm['auth.User']"}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'agenda_agendaentidade_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'publicada_fim': ('django.db.models.fields.DateTimeField', [], {'db_index': 'True', 'null': 'True', 'blank': 'True'}),
            'publicada_inicio': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'db_index': 'True', 'blank': 'True'}),
            'titulo': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'website': ('django.db.models.fields.related.ForeignKey', [], {'default': '1', 'related_name': "'agenda_agendaentidade_website'", 'to': "orm['website.WebSite']"})
        },
        'agenda.agendalocal': {
            'Meta': {'object_name': 'AgendaLocal'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'agenda_agendalocal_alterado_por'", 'to': "orm['auth.User']"}),
            'aprovado': ('django.db.models.fields.DateTimeField', [], {'null': 'True', 'blank': 'True'}),
            'aprovado_por': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'agenda_agendalocal_aprovado_por'", 'null': 'True', 'to': "orm['auth.User']"}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'agenda_agendalocal_criado_por'", 'to': "orm['auth.User']"}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'agenda_agendalocal_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'publicada_fim': ('django.db.models.fields.DateTimeField', [], {'db_index': 'True', 'null': 'True', 'blank': 'True'}),
            'publicada_inicio': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'db_index': 'True', 'blank': 'True'}),
            'titulo': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'website': ('django.db.models.fields.related.ForeignKey', [], {'default': '1', 'related_name': "'agenda_agendalocal_website'", 'to': "orm['website.WebSite']"})
        },
        'auth.group': {
            'Meta': {'object_name': 'Group'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '80'}),
            'permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'})
        },
        'auth.permission': {
            'Meta': {'ordering': "('content_type__app_label', 'content_type__model', 'codename')", 'unique_together': "(('content_type', 'codename'),)", 'object_name': 'Permission'},
            'codename': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'content_type': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['contenttypes.ContentType']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '50'})
        },
        'auth.user': {
            'Meta': {'object_name': 'User'},
            'date_joined': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'email': ('django.db.models.fields.EmailField', [], {'max_length': '75', 'blank': 'True'}),
            'first_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'groups': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Group']", 'symmetrical': 'False', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'is_active': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'is_staff': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_superuser': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'last_login': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'last_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'password': ('django.db.models.fields.CharField', [], {'max_length': '128'}),
            'user_permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'}),
            'username': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '30'})
        },
        'contenttypes.contenttype': {
            'Meta': {'ordering': "('name',)", 'unique_together': "(('app_label', 'model'),)", 'object_name': 'ContentType', 'db_table': "'django_content_type'"},
            'app_label': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'model': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'})
        },
        'diocese.arciprestado': {
            'Meta': {'object_name': 'Arciprestado'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_arciprestado_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'arcipreste': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'arcipreste_adjunto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_arciprestado_criado_por'", 'to': "orm['auth.User']"}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_arciprestado_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'logo': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'presbitero_arcipreste': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_arciprestado_presbitero_arcipreste'", 'null': 'True', 'to': "orm['diocese.Presbitero']"}),
            'presbitero_arcipreste_adjunto': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_arciprestado_presbitero_arcipreste_adjunto'", 'null': 'True', 'to': "orm['diocese.Presbitero']"})
        },
        'diocese.presbitero': {
            'Meta': {'object_name': 'Presbitero'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_presbitero_alterado_por'", 'to': "orm['auth.User']"}),
            'arcipreste': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'capelao': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'cartao_sacerdotal': ('django.db.models.fields.IntegerField', [], {'max_length': '2', 'null': 'True', 'blank': 'True'}),
            'clero_tipo': ('django.db.models.fields.PositiveIntegerField', [], {'default': '1', 'max_length': '1'}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_presbitero_criado_por'", 'to': "orm['auth.User']"}),
            'data_faleceu': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'data_nascimento': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'data_ordenacoa': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'faleceu': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'formacao_permanente': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fraternidade_sacerdotal': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_presbitero_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'habilitacoes_academicas': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'igreja': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'local_nascimento': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'local_ordenacao': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'nomeacoes': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'nomeacoes_actuais': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'obs': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'paroco': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'publicacoes': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'reitor': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'serv_pastoral': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel_privado': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'tipo_clero': ('django.db.models.fields.PositiveIntegerField', [], {'max_length': '1', 'null': 'True', 'blank': 'True'}),
            'vice_arcipreste': ('django.db.models.fields.BooleanField', [], {'default': 'False'})
        },
        'elfinder.filecollection': {
            'Meta': {'object_name': 'FileCollection'},
            'dir': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'url': ('django.db.models.fields.CharField', [], {'max_length': '255'})
        },
        'website.website': {
            'Meta': {'object_name': 'WebSite'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'websites_websites_arciprestado'", 'null': 'True', 'to': "orm['diocese.Arciprestado']"}),
            'email': ('django.db.models.fields.EmailField', [], {'max_length': '75'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'titulo': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'url': ('django.db.models.fields.URLField', [], {'max_length': '200'}),
            'users': ('django.db.models.fields.related.ManyToManyField', [], {'blank': 'True', 'related_name': "'websites_websites_users'", 'null': 'True', 'symmetrical': 'False', 'to': "orm['auth.User']"})
        }
    }

    complete_apps = ['agenda']